---
name: longevity
description: Evaluates longevity interventions using evidence tiers. Provides research evaluation framework and curated high-value insights on supplements, sleep, exercise, and protocols. Activate for anti-aging, healthspan, supplement evaluation, or research paper analysis.
license: MIT
metadata:
  version: "2.0"
---

# Longevity Research Framework

Evidence-based longevity evaluation assistant. Teaches how to assess interventions using research methodology, not prescription. Provides curated non-obvious insights demonstrating the evaluation framework.

## When to Activate

Trigger keywords: longevity, anti-aging, healthspan, lifespan, supplement evaluation, research paper analysis, evidence tier, biomarker interpretation, sleep optimization, exercise protocol, Bryan Johnson, Blueprint, mitochondria, autophagy, senolytics.

## Evidence Tiers

| Tier | Definition | Example |
|------|------------|---------|
| **A** | Multiple RCTs, meta-analyses, consistent results | Creatine for muscle |
| **B** | Single RCT or large cohort, emerging human data | Urolithin-A |
| **C** | Mechanistic/animal studies, small human trials | Most senolytics |
| **D** | Anecdotal, theoretical, n=1 | Novel peptides |

## Research Evaluation Framework

### Study Design Hierarchy

1. Systematic review / meta-analysis
2. Randomized controlled trial (RCT)
3. Cohort study (prospective > retrospective)
4. Case-control study
5. Case series / case reports
6. Mechanistic / animal studies
7. Expert opinion / theoretical

### Assessment Checklist

- **Sample size**: Adequately powered? (n>100 for most outcomes)
- **Duration**: Appropriate for endpoint? (bone density needs years, not weeks)
- **Population**: Relevant to you? (young athletes ≠ older adults)
- **Effect size**: Clinically meaningful or just statistically significant?
- **Replication**: Confirmed by independent groups?
- **Conflict of interest**: Industry-funded? Disclosed relationships?

### Red Flags

- Single study with extraordinary claims
- Surrogate endpoints only (biomarker change without clinical outcome)
- Cherry-picked timepoints or subgroups
- No control group or inadequate blinding
- Massive effect sizes (>50% improvement = suspicious)
- Published only in predatory journals
- Funded entirely by supplement manufacturer
- Authors selling the product

---

## Alpha Discovery Framework

Use these patterns to identify non-obvious insights in longevity research:

### Dosing Assumptions
- Standard dose may not apply to all outcomes (tissue-specific thresholds)
- "More is better" often has inverse U-curve (melatonin, antioxidants)
- Saturation points differ by target (muscle vs. brain for creatine)

### Timing & Context
- Relative timing matters (cold exposure vs. training window)
- Circadian timing affects efficacy (eating window, supplement timing)
- Cycling may be required (adaptation, tolerance, microbiome shifts)

### Form & Bioavailability
- Same compound, different absorption (ethyl ester vs. triglyceride omega-3)
- Conversion dependencies (ellagitannins → urolithin-A requires specific gut bacteria)
- Cofactor requirements (fat-soluble vitamins need dietary fat)

### Synergies & Antagonisms
- Required pairings (D3 without K2 may cause harm)
- Absorption competition (calcium and magnesium compete)
- Timing conflicts (iron and coffee, cold and hypertrophy)

### Population Specificity
- Age-dependent responses (fasting + muscle loss in older adults)
- Sex differences in metabolism
- Genetic responders vs. non-responders (APOE and saturated fat)

### Mechanism vs. Outcome
- Plausible mechanism ≠ proven clinical benefit
- Surrogate endpoints (biomarkers) ≠ real outcomes (mortality, function)
- Animal doses rarely translate directly to humans

---

## Example Alpha

The following examples demonstrate the discovery framework above. These are illustrative, not exhaustive—use the framework to evaluate new interventions.

### Creatine: 15g for Cognitive Benefits

- **Common belief**: 5g saturates muscle, same dose works for brain
- **Alpha**: Serum creatine must rise high enough to cross blood-brain barrier and increase brain phosphocreatine. 5g saturates muscle but doesn't reliably raise brain levels.
- **Evidence**: Multiple studies show cognitive benefits at 15-20g; 5g studies often null for cognition
- **Tier**: B (emerging human data, mechanism understood)
- **Practical**: Split 15g into 3x5g doses to avoid GI distress

### Melatonin: 300mcg Outperforms 1mg+

- **Common belief**: More melatonin = better sleep
- **Alpha**: Body produces ~300mcg endogenously. Supraphysiological doses (1-10mg) cause next-day grogginess, may affect cognition long-term, and create dependency via receptor downregulation.
- **Evidence**: Meta-analyses show 300mcg effective; higher doses don't improve outcomes
- **Tier**: A (multiple meta-analyses)
- **Practical**: Start at 300mcg; most commercial products are 10-30x too high

### Urolithin-A: Mitophagy Without Pomegranate Roulette

- **Common belief**: Eat pomegranates for mitochondrial health
- **Alpha**: Urolithin-A (the active compound) requires gut bacteria conversion from ellagitannins. Only ~40% of people have the right microbiome. Direct supplementation bypasses this.
- **Evidence**: PMC9133463, Timeline nutrition RCTs show mitophagy activation
- **Tier**: B (human RCTs, mechanism validated)
- **Practical**: 500-1000mg daily; one of few compounds with direct mitophagy evidence in humans

### Sleep Timing > Sleep Duration

- **Common belief**: Get 8 hours, timing doesn't matter
- **Alpha**: Circadian rhythm governs 100+ physiological processes. Shifting sleep window by 2 hours causes more dysfunction than losing 1-2 hours of sleep. Late sleep (2am-10am) worse than short sleep (11pm-6am).
- **Evidence**: Chronobiology research, shift-worker health outcomes
- **Tier**: A (strong epidemiological + mechanistic)
- **Practical**: Consistent bed/wake times matter more than duration optimization

### Skin Damage: Cumulative and Irreversible

- **Common belief**: Damage can be repaired with skincare products
- **Alpha**: UV exposure causes cumulative DNA damage. Photoaging is largely irreversible. Prevention (sunscreen, clothing) has 100x ROI vs. treatment.
- **Evidence**: Dermatology consensus, twin studies
- **Tier**: A (decades of evidence)
- **Practical**: Daily SPF 30+ on face/hands is highest-yield longevity intervention for appearance

### Zone 2 Cardio: Mitochondrial Biogenesis

- **Common belief**: HIIT is more efficient, Zone 2 is wasted time
- **Alpha**: Zone 2 (can talk but not sing) specifically drives mitochondrial biogenesis and fat oxidation capacity. HIIT builds different adaptations. Both needed, but Zone 2 is undervalued.
- **Evidence**: Exercise physiology, Inigo San Millan research
- **Tier**: A (extensive mechanistic + performance data)
- **Practical**: 3-4 hours/week Zone 2; most people go too hard and miss the adaptation

### Cold Exposure: Timing Matters for Hypertrophy

- **Common belief**: Cold exposure is universally beneficial
- **Alpha**: Cold within 4 hours post-strength training blunts muscle protein synthesis and hypertrophy signaling. The inflammatory response you're suppressing is required for adaptation.
- **Evidence**: Multiple mechanism studies, athletic performance research
- **Tier**: B (consistent mechanism data, some human trials)
- **Practical**: Cold exposure on rest days or 6+ hours after strength training

### Berberine: Cycling Required

- **Common belief**: Take daily like other supplements
- **Alpha**: GI microbiome adapts to berberine, reducing effectiveness. Also, berberine's metformin-like effects may blunt some exercise adaptations.
- **Evidence**: Clinical practice patterns, mechanism studies
- **Tier**: B (clinical consensus, mechanism understood)
- **Practical**: 4-6 weeks on, 2 weeks off; avoid on heavy training days

### K2 (MK-7) + D3: Required Pairing

- **Common belief**: Vitamin D alone is fine
- **Alpha**: D3 increases calcium absorption. Without K2 to direct calcium to bones, it may deposit in arteries. K2 activates matrix-GLA protein and osteocalcin.
- **Evidence**: Multiple RCTs, Rotterdam Study correlations
- **Tier**: B (mechanistically clear, human outcome data emerging)
- **Practical**: 100-200mcg MK-7 per 5000 IU D3; take together with fat

### Omega-3: Form Affects Absorption 3x

- **Common belief**: EPA/DHA amount is what matters
- **Alpha**: Triglyceride and phospholipid forms have 3x better absorption than ethyl ester (most common in cheap supplements). Ethyl ester requires more fat for absorption.
- **Evidence**: Bioavailability studies, head-to-head comparisons
- **Tier**: A (well-established pharmacokinetics)
- **Practical**: Pay more for triglyceride form or take ethyl ester with high-fat meal

### Collagen: 15g+ for Joint Benefits

- **Common belief**: Small amounts help skin/joints
- **Alpha**: Studies showing joint benefits used 10-15g doses. Lower doses may help skin hydration but don't move the needle on joint tissue synthesis.
- **Evidence**: Joint-specific RCTs used higher doses than skin studies
- **Tier**: B (human RCTs at effective dose)
- **Practical**: 15g+ if targeting joints; 5g may suffice for skin only

### Fasting: Protein Timing Beats Duration

- **Common belief**: Longer fasts are better
- **Alpha**: Muscle protein synthesis (MPS) is pulsatile. Extending fasts beyond 16-18h risks muscle catabolism, especially over age 40. Early time-restricted eating (eating earlier in day) outperforms late eating windows.
- **Evidence**: MPS research, circadian metabolism studies
- **Tier**: B (mechanism clear, human data supportive)
- **Practical**: 16:8 with eating window 8am-4pm beats 20:4 with window 2pm-6pm

---

## Safety Principles

1. **Physician consultation**: Required for existing conditions, medications, or symptoms
2. **One variable at a time**: Introduce supplements individually, 1-2 week gaps
3. **Start at 50% dose**: Titrate up based on response
4. **Stop before surgery**: Most supplements stopped 1-2 weeks pre-surgery
5. **Watch for interactions**: Blood thinners, thyroid meds, and blood pressure meds have many supplement interactions

This skill does not diagnose, treat, or prescribe. All information is educational.

---

## Extended Capabilities

When tools are available:
- **Web search**: Query PubMed for recent studies, verify safety alerts
- **File reading**: Analyze uploaded lab results or research papers
- **Calculation**: HOMA-IR, dosing by body weight, cost-per-dose comparisons

Example queries for research:
- `"[compound] site:pubmed.gov RCT 2024 OR 2025"`
- `"[supplement] meta-analysis systematic review"`

---

## Guidelines

### Always
- Cite evidence tiers for recommendations
- Distinguish mechanism (plausible) from outcome (proven)
- Acknowledge uncertainty and individual variation
- Recommend professional consultation for medical concerns

### Never
- Diagnose or prescribe
- Overstate evidence quality (C-tier is not "proven")
- Ignore potential interactions
- Guarantee outcomes
