# Longbridge OpenAPI

长桥证券 OpenAPI SDK，支持港美股交易、实时行情订阅和账户管理。

## 简介

Longbridge OpenAPI Skill 是一个集成了长桥证券开放接口的 AI 技能包，让您能够通过自然语言与 OpenClaw 交互，轻松完成股票行情查询、交易下单、账户管理等操作。

## 核心功能

### 📊 行情数据
- **实时行情订阅**：订阅港股、美股、A股的实时行情推送
- **股票报价查询**：获取最新价、成交量、涨跌幅等实时数据
- **K线数据**：支持分钟、日、周、月、年线等多种周期
- **静态信息**：查询股票名称、交易所、货币、每手股数等基础信息

### 💰 交易功能
- **智能下单**：支持限价单、市价单、增强限价单等多种订单类型
- **订单管理**：撤销订单、修改订单
- **订单查询**：查看当日订单、历史订单和成交记录
- **多市场支持**：港股、美股、A股全覆盖

### 💼 账户管理
- **资金查询**：实时查看账户余额、购买力、净资产
- **持仓管理**：查询当前持仓、成本价、市值等信息
- **多币种支持**：支持港币、美元、人民币等多种货币

## 支持的市场

| 市场 | 代码格式 | 示例 |
|------|---------|------|
| 🇭🇰 港股 | `XXX.HK` | `700.HK` (腾讯)、`9988.HK` (阿里巴巴) |
| 🇺🇸 美股 | `XXX.US` | `AAPL.US` (苹果)、`TSLA.US` (特斯拉) |
| 🇨🇳 A股 | `XXX.SH/SZ` | `000001.SZ` (平安银行)、`600519.SH` (茅台) |

## 配置说明

### 1. 获取 API 凭证

访问 [Longbridge 开放平台](https://open.longportapp.com/) 注册账号并创建应用，获取：

- **App Key**：应用密钥
- **App Secret**：应用秘钥
- **Access Token**：访问令牌

### 2. 配置环境变量

使用本 skill 前，必须设置以下环境变量：

```bash
export LONGBRIDGE_APP_KEY="your_app_key_here"
export LONGBRIDGE_APP_SECRET="your_app_secret_here"
export LONGBRIDGE_ACCESS_TOKEN="your_access_token_here"
```

**持久化配置**（推荐）：

在 `~/.bashrc` 或 `~/.zshrc` 中添加：

```bash
# Longbridge OpenAPI 配置
export LONGBRIDGE_APP_KEY="your_app_key_here"
export LONGBRIDGE_APP_SECRET="your_app_secret_here"
export LONGBRIDGE_ACCESS_TOKEN="your_access_token_here"
```

然后执行 `source ~/.bashrc` 或 `source ~/.zshrc` 使配置生效。

## 使用示例

### 示例 1：查询股票行情

**用户输入：**
```
查询腾讯和阿里巴巴的最新股价
```

**OpenClaw 操作：**
- 调用 `get_realtime_quote` 工具
- 参数：`symbols=['700.HK', '9988.HK']`

**返回结果：**
```
腾讯控股（700.HK）
最新价：320.40 港元 | 涨跌：+2.40 (+0.75%)
开盘：318.00 | 最高：322.80 | 最低：317.60
成交量：1,234,567 股 | 成交额：3.95 亿港元

阿里巴巴-SW（9988.HK）
最新价：78.50 港元 | 涨跌：-1.20 (-1.51%)
开盘：79.20 | 最高：80.00 | 最低：78.00
成交量：2,345,678 股 | 成交额：1.84 亿港元
```

### 示例 2：获取K线数据

**用户输入：**
```
获取苹果股票最近 7 天的日K线数据
```

**OpenClaw 操作：**
- 调用 `get_candlesticks` 工具
- 参数：`symbol='AAPL.US', period='day', count=7`

**返回结果：**
包含开盘价、最高价、最低价、收盘价、成交量等数据的 7 根 K 线。

### 示例 3：提交买入订单

**用户输入：**
```
以 320 港元的价格买入 100 股腾讯
```

**OpenClaw 操作：**
- 先向用户确认订单详情
- 调用 `submit_order` 工具
- 参数：
  ```python
  symbol='700.HK'
  order_type='LO'  # 限价单
  side='Buy'
  quantity=100
  price=320.0
  time_in_force='Day'
  ```

**返回结果：**
```
✅ 订单已提交成功
订单号：123456789
股票：腾讯控股（700.HK）
方向：买入
数量：100 股
价格：320.00 港元
类型：限价单（当日有效）
```

### 示例 4：查询账户信息

**用户输入：**
```
我的账户余额是多少？
```

**OpenClaw 操作：**
- 调用 `get_account_balance` 工具

**返回结果：**
```
💰 账户资金情况

港币账户（HKD）
现金：50,000.00 HKD
购买力：100,000.00 HKD
净资产：150,000.00 HKD

美元账户（USD）
现金：10,000.00 USD
购买力：20,000.00 USD
净资产：30,000.00 USD
```

### 示例 5：查看持仓

**用户输入：**
```
我持有哪些股票？
```

**OpenClaw 操作：**
- 调用 `get_stock_positions` 工具

**返回结果：**
```
📊 当前持仓

1. 腾讯控股（700.HK）
   持仓：500 股 | 可用：500 股
   成本价：300.00 HKD | 现价：320.40 HKD
   市值：160,200.00 HKD | 盈亏：+10,200.00 (+6.80%)

2. 苹果（AAPL.US）
   持仓：100 股 | 可用：100 股
   成本价：150.00 USD | 现价：175.50 USD
   市值：17,550.00 USD | 盈亏：+2,550.00 (+17.00%)
```

## API 工具清单

### 行情类工具
| 工具名称 | 功能描述 |
|---------|---------|
| `quote_subscribe` | 订阅实时行情推送（报价/盘口/经纪队列/逐笔） |
| `get_realtime_quote` | 获取股票实时报价 |
| `get_static_info` | 获取股票静态信息 |
| `get_candlesticks` | 获取历史K线数据 |

### 交易类工具
| 工具名称 | 功能描述 |
|---------|---------|
| `submit_order` | 提交交易订单 |
| `cancel_order` | 撤销订单 |
| `get_today_orders` | 获取当日订单列表 |
| `get_history_orders` | 获取历史订单 |

### 账户类工具
| 工具名称 | 功能描述 |
|---------|---------|
| `get_account_balance` | 查询账户资金余额 |
| `get_stock_positions` | 查询持仓列表 |

## 订单类型说明

| 类型代码 | 订单类型 | 说明 |
|---------|---------|------|
| `LO` | 限价单 | 以指定价格或更好的价格成交 |
| `MO` | 市价单 | 以当前市场价格立即成交 |
| `ELO` | 增强限价单 | 港股特有，可与多个价位成交 |
| `ALO` | 竞价限价单 | 在竞价时段使用 |

## 订单有效期

| 代码 | 有效期 | 说明 |
|------|-------|------|
| `Day` | 当日有效 | 订单在当日交易时段有效 |
| `GTC` | 撤单前有效 | 订单一直有效直到成交或手动撤销 |
| `GTD` | 指定日期前有效 | 订单在指定日期前有效 |

## 安全注意事项

### ⚠️ 风险提示
1. **投资有风险**：股票交易存在市场风险，使用者需自行承担投资决策带来的风险
2. **仅供学习**：本 skill 仅用于技术学习和研究，不构成任何投资建议
3. **谨慎操作**：请勿在生产环境未经充分测试的情况下直接使用

### 🔒 安全建议
1. **保护密钥**：妥善保管 API 密钥，不要泄露给他人或提交到代码仓库
2. **模拟测试**：建议先在 Longbridge 模拟账户中测试
3. **订单确认**：所有交易操作应经过人工确认后再执行
4. **权限控制**：建议为 API 密钥设置最小必要权限
5. **定期轮换**：定期更换 API 密钥以提高安全性

## 技术架构

```
┌──────────────────┐
│    OpenClaw      │  ← 用户自然语言交互
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Longbridge Skill │  ← Skill 层（工具调用）
│   (skill.py)     │
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Longbridge SDK   │  ← Python SDK (FFI)
│   (longbridge)   │
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Longbridge API   │  ← REST API / WebSocket
│ (HTTP/WebSocket) │
└──────────────────┘
```

## 依赖要求

- **Python**: >= 3.7
- **longbridge**: >= 0.2.77

依赖会在安装 skill 时自动安装。

## 常见问题

### Q1: 如何获取 API 密钥？
访问 [Longbridge 开放平台](https://open.longportapp.com/)，注册账号后在"应用管理"中创建应用即可获取。

### Q2: 是否支持模拟账户？
是的，Longbridge 提供模拟账户用于测试。在开放平台可以切换到模拟环境。

### Q3: 订单提交失败怎么办？
请检查：
- 环境变量是否正确配置
- API 密钥是否有效
- 账户资金是否充足
- 交易时间是否在开市时段
- 订单参数是否合法（价格、数量等）

### Q4: 支持哪些市场？
目前支持港股、美股和A股市场的股票、ETF、权证和期权交易。

### Q5: 如何查看 API 调用日志？
SDK 内部会输出日志，您可以通过配置 Python logging 模块查看详细的调用信息。

## 更新日志

### v1.0.0 (2026-02-02)
- ✨ 初始版本发布
- ✅ 支持实时行情查询和订阅
- ✅ 支持交易下单、撤单、改单
- ✅ 支持账户资金和持仓查询
- ✅ 支持历史K线数据获取
- ✅ 港股、美股、A股全市场覆盖

## 参考资料

- 📖 [Longbridge OpenAPI 官方文档](https://open.longbridge.com/docs)
- 🐍 [Python SDK 文档](https://longbridge.readthedocs.io/en/latest/)
- 💻 [GitHub 源码仓库](https://github.com/longportapp/openapi)
- 📦 [PyPI 包地址](https://pypi.org/project/longbridge/)
- 🌐 [开放平台首页](https://open.longportapp.com/)

## 许可证

MIT License

## 作者

genkin

## 支持

如有问题或建议，欢迎通过以下方式联系：
- 提交 Issue 到 GitHub
- 访问 Longbridge 开发者社区
- 查阅官方文档

---

**免责声明**：本 skill 仅供学习和技术研究使用，不构成任何投资建议。使用者应当充分了解股票投资风险，并对自己的投资决策负责。
