# Longbridge OpenAPI

Longbridge Securities OpenAPI SDK, supporting Hong Kong and US stock trading, real-time market data subscription, and account management.

## Introduction

Longbridge OpenAPI Skill is an AI skill package integrated with Longbridge Securities Open API, allowing you to interact with OpenClaw using natural language to easily complete stock market queries, trade orders, account management, and other operations.

## Core Features

### 📊 Market Data
- **Real-time Market Subscription**: Subscribe to real-time market feeds for Hong Kong stocks, US stocks, and A-shares
- **Stock Quote Query**: Get real-time data such as latest price, volume, price change, etc.
- **Candlestick Data**: Support multiple periods including minute, day, week, month, and year
- **Static Information**: Query basic information such as stock name, exchange, currency, lot size, etc.

### 💰 Trading Features
- **Smart Order Placement**: Support various order types including limit order, market order, enhanced limit order, etc.
- **Order Management**: Cancel orders, modify orders
- **Order Query**: View today's orders, historical orders, and trade records
- **Multi-market Support**: Coverage of Hong Kong stocks, US stocks, and A-shares

### 💼 Account Management
- **Fund Query**: View account balance, buying power, and net assets in real-time
- **Position Management**: Query current positions, cost price, market value, and other information
- **Multi-currency Support**: Support multiple currencies including HKD, USD, CNY, etc.

## Supported Markets

| Market | Code Format | Examples |
|--------|------------|----------|
| 🇭🇰 Hong Kong | `XXX.HK` | `700.HK` (Tencent), `9988.HK` (Alibaba) |
| 🇺🇸 US Stocks | `XXX.US` | `AAPL.US` (Apple), `TSLA.US` (Tesla) |
| 🇨🇳 A-Shares | `XXX.SH/SZ` | `000001.SZ` (Ping An Bank), `600519.SH` (Moutai) |

## Configuration Guide

### 1. Obtain API Credentials

Visit [Longbridge Open Platform](https://open.longportapp.com/) to register an account and create an application to obtain:

- **App Key**: Application key
- **App Secret**: Application secret
- **Access Token**: Access token

### 2. Configure Environment Variables

Before using this skill, you must set the following environment variables:

```bash
export LONGBRIDGE_APP_KEY="your_app_key_here"
export LONGBRIDGE_APP_SECRET="your_app_secret_here"
export LONGBRIDGE_ACCESS_TOKEN="your_access_token_here"
```

**Persistent Configuration** (Recommended):

Add to `~/.bashrc` or `~/.zshrc`:

```bash
# Longbridge OpenAPI Configuration
export LONGBRIDGE_APP_KEY="your_app_key_here"
export LONGBRIDGE_APP_SECRET="your_app_secret_here"
export LONGBRIDGE_ACCESS_TOKEN="your_access_token_here"
```

Then execute `source ~/.bashrc` or `source ~/.zshrc` to apply the configuration.

## Usage Examples

### Example 1: Query Stock Market Data

**User Input:**
```
Query the latest stock prices of Tencent and Alibaba
```

**OpenClaw Operation:**
- Call `get_realtime_quote` tool
- Parameters: `symbols=['700.HK', '9988.HK']`

**Response:**
```
Tencent Holdings (700.HK)
Latest: 320.40 HKD | Change: +2.40 (+0.75%)
Open: 318.00 | High: 322.80 | Low: 317.60
Volume: 1,234,567 shares | Turnover: 395M HKD

Alibaba-SW (9988.HK)
Latest: 78.50 HKD | Change: -1.20 (-1.51%)
Open: 79.20 | High: 80.00 | Low: 78.00
Volume: 2,345,678 shares | Turnover: 184M HKD
```

### Example 2: Get Candlestick Data

**User Input:**
```
Get the last 7 days of daily candlestick data for Apple stock
```

**OpenClaw Operation:**
- Call `get_candlesticks` tool
- Parameters: `symbol='AAPL.US', period='day', count=7`

**Response:**
Contains 7 candlesticks with data including open, high, low, close, volume, etc.

### Example 3: Submit Buy Order

**User Input:**
```
Buy 100 shares of Tencent at 320 HKD
```

**OpenClaw Operation:**
- First confirm order details with user
- Call `submit_order` tool
- Parameters:
  ```python
  symbol='700.HK'
  order_type='LO'  # Limit order
  side='Buy'
  quantity=100
  price=320.0
  time_in_force='Day'
  ```

**Response:**
```
✅ Order submitted successfully
Order ID: 123456789
Stock: Tencent Holdings (700.HK)
Side: Buy
Quantity: 100 shares
Price: 320.00 HKD
Type: Limit Order (Day)
```

### Example 4: Query Account Information

**User Input:**
```
What is my account balance?
```

**OpenClaw Operation:**
- Call `get_account_balance` tool

**Response:**
```
💰 Account Fund Status

HKD Account
Cash: 50,000.00 HKD
Buying Power: 100,000.00 HKD
Net Assets: 150,000.00 HKD

USD Account
Cash: 10,000.00 USD
Buying Power: 20,000.00 USD
Net Assets: 30,000.00 USD
```

### Example 5: View Positions

**User Input:**
```
What stocks do I hold?
```

**OpenClaw Operation:**
- Call `get_stock_positions` tool

**Response:**
```
📊 Current Positions

1. Tencent Holdings (700.HK)
   Quantity: 500 shares | Available: 500 shares
   Cost: 300.00 HKD | Current: 320.40 HKD
   Market Value: 160,200.00 HKD | P&L: +10,200.00 (+6.80%)

2. Apple (AAPL.US)
   Quantity: 100 shares | Available: 100 shares
   Cost: 150.00 USD | Current: 175.50 USD
   Market Value: 17,550.00 USD | P&L: +2,550.00 (+17.00%)
```

## API Tool List

### Market Data Tools
| Tool Name | Description |
|-----------|-------------|
| `quote_subscribe` | Subscribe to real-time market feeds (quote/depth/broker/trade) |
| `get_realtime_quote` | Get real-time stock quotes |
| `get_static_info` | Get stock static information |
| `get_candlesticks` | Get historical candlestick data |

### Trading Tools
| Tool Name | Description |
|-----------|-------------|
| `submit_order` | Submit trading orders |
| `cancel_order` | Cancel orders |
| `get_today_orders` | Get today's order list |
| `get_history_orders` | Get historical orders |

### Account Tools
| Tool Name | Description |
|-----------|-------------|
| `get_account_balance` | Query account fund balance |
| `get_stock_positions` | Query position list |

## Order Type Description

| Type Code | Order Type | Description |
|-----------|------------|-------------|
| `LO` | Limit Order | Execute at specified price or better |
| `MO` | Market Order | Execute immediately at current market price |
| `ELO` | Enhanced Limit Order | Hong Kong stocks specific, can match at multiple price levels |
| `ALO` | At-auction Limit Order | Use during auction period |

## Order Time in Force

| Code | Time in Force | Description |
|------|---------------|-------------|
| `Day` | Day Order | Valid for the current trading day |
| `GTC` | Good Till Cancelled | Valid until filled or manually cancelled |
| `GTD` | Good Till Date | Valid until specified date |

## Security Precautions

### ⚠️ Risk Warnings
1. **Investment Risks**: Stock trading involves market risks, users are responsible for their own investment decisions
2. **For Learning Only**: This skill is for technical learning and research only, does not constitute investment advice
3. **Use with Caution**: Do not use directly in production environment without thorough testing

### 🔒 Security Recommendations
1. **Protect Keys**: Keep API keys secure, do not leak to others or commit to code repositories
2. **Test with Demo**: Recommend testing with Longbridge demo account first
3. **Order Confirmation**: All trading operations should be confirmed manually before execution
4. **Permission Control**: Recommend setting minimum necessary permissions for API keys
5. **Regular Rotation**: Regularly rotate API keys to improve security

## Technical Architecture

```
┌──────────────────┐
│    OpenClaw      │  ← User natural language interaction
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Longbridge Skill │  ← Skill layer (tool invocation)
│   (skill.py)     │
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Longbridge SDK   │  ← Python SDK (FFI)
│   (longbridge)   │
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Longbridge API   │  ← REST API / WebSocket
│ (HTTP/WebSocket) │
└──────────────────┘
```

## Dependencies

- **Python**: >= 3.7
- **longbridge**: >= 0.2.77

Dependencies will be installed automatically when installing the skill.

## Frequently Asked Questions

### Q1: How to obtain API keys?
Visit [Longbridge Open Platform](https://open.longportapp.com/), register an account, then create an application in "Application Management" to obtain the keys.

### Q2: Does it support demo account?
Yes, Longbridge provides demo accounts for testing. You can switch to the simulation environment on the open platform.

### Q3: What to do if order submission fails?
Please check:
- Are environment variables configured correctly?
- Are API keys valid?
- Is account balance sufficient?
- Is trading time within market hours?
- Are order parameters valid (price, quantity, etc.)?

### Q4: Which markets are supported?
Currently supports stocks, ETFs, warrants, and options trading in Hong Kong, US, and A-share markets.

### Q5: How to view API call logs?
The SDK outputs logs internally. You can configure Python's logging module to view detailed call information.

## Changelog

### v1.0.0 (2026-02-02)
- ✨ Initial release
- ✅ Support real-time market query and subscription
- ✅ Support order submission, cancellation, and modification
- ✅ Support account fund and position queries
- ✅ Support historical candlestick data retrieval
- ✅ Full coverage of Hong Kong, US, and A-share markets

## References

- 📖 [Longbridge OpenAPI Official Documentation](https://open.longbridge.com/docs)
- 🐍 [Python SDK Documentation](https://longbridge.readthedocs.io/en/latest/)
- 💻 [GitHub Source Repository](https://github.com/longportapp/openapi)
- 📦 [PyPI Package](https://pypi.org/project/longbridge/)
- 🌐 [Open Platform Homepage](https://open.longportapp.com/)

## License

MIT License

## Author

genkin

## Support

If you have questions or suggestions, please contact us through:
- Submit issues to GitHub
- Visit Longbridge developer community
- Refer to official documentation

---

**Disclaimer**: This skill is for learning and technical research only and does not constitute investment advice. Users should fully understand the risks of stock investment and be responsible for their own investment decisions.
