# Longbridge OpenAPI Skill

长桥证券 OpenAPI 技能包，支持港美股交易、实时行情订阅和账户管理。

## 功能特性

### 📊 行情数据
- ✅ 实时行情订阅（港股、美股、A股）
- ✅ 获取股票实时报价（最新价、成交量、涨跌幅等）
- ✅ 历史K线数据（支持分钟、日、周、月、年线）
- ✅ 股票静态信息查询（名称、交易所、货币等）

### 💰 交易功能
- ✅ 提交订单（限价单、市价单、增强限价单等）
- ✅ 撤销订单
- ✅ 查询当日订单
- ✅ 查询历史订单和成交记录

### 💼 账户管理
- ✅ 查询账户资金余额
- ✅ 查询持仓列表
- ✅ 多币种支持（港币、美元、人民币）

## 安装配置

### 1. 获取 API 密钥

访问 [Longbridge 开放平台](https://open.longportapp.com/) 注册并获取：
- `App Key`
- `App Secret`
- `Access Token`

### 2. 配置环境变量

在使用本 skill 之前，需要设置以下环境变量：

```bash
export LONGBRIDGE_APP_KEY="your_app_key"
export LONGBRIDGE_APP_SECRET="your_app_secret"
export LONGBRIDGE_ACCESS_TOKEN="your_access_token"
```

或者在 `~/.bashrc` / `~/.zshrc` 中添加：

```bash
# Longbridge API 配置
export LONGBRIDGE_APP_KEY="your_app_key"
export LONGBRIDGE_APP_SECRET="your_app_secret"
export LONGBRIDGE_ACCESS_TOKEN="your_access_token"
```

### 3. 安装依赖

本 skill 会自动安装 `longbridge` Python SDK (>=0.2.77)

## 使用方法

### 在 ClawHub 安装

1. 访问 ClawHub 网站
2. 搜索 "longbridge" skill
3. 点击安装
4. 配置环境变量（见上方）

### 在 OpenClaw 中使用

安装后，可以直接通过自然语言与 OpenClaw 交互：

```
# 查询行情
查询腾讯和阿里巴巴的最新股价

# 获取K线数据
获取苹果股票最近30天的日K线数据

# 查询账户
我的账户余额是多少？

# 查看持仓
我持有哪些股票？

# 下单交易
以320港元的价格买入100股腾讯
```

## 支持的市场

- 🇭🇰 **港股**: 使用后缀 `.HK`（如 `700.HK` - 腾讯）
- 🇺🇸 **美股**: 使用后缀 `.US`（如 `AAPL.US` - 苹果）
- 🇨🇳 **A股**: 使用后缀 `.SH` 或 `.SZ`（如 `000001.SZ` - 平安银行）

## API 工具列表

### 行情相关
- `quote_subscribe` - 订阅实时行情
- `get_realtime_quote` - 获取实时报价
- `get_static_info` - 获取股票静态信息
- `get_candlesticks` - 获取K线数据

### 交易相关
- `submit_order` - 提交订单
- `cancel_order` - 撤销订单
- `get_today_orders` - 获取当日订单
- `get_history_orders` - 获取历史订单

### 账户相关
- `get_account_balance` - 获取账户余额
- `get_stock_positions` - 获取持仓列表

## 使用示例

### 示例 1: 查询实时行情

```python
# 用户: 查询腾讯的最新股价

# OpenClaw 会调用:
get_realtime_quote(symbols=["700.HK"])

# 返回:
{
  "symbol": "700.HK",
  "last_done": 320.40,
  "open": 318.00,
  "high": 322.80,
  "low": 317.60,
  "volume": 1234567,
  "turnover": 395000000
}
```

### 示例 2: 提交买入订单

```python
# 用户: 以100美元的价格买入10股苹果股票

# OpenClaw 会调用:
submit_order(
    symbol="AAPL.US",
    order_type="LO",  # 限价单
    side="Buy",
    quantity=10,
    price=100.0,
    time_in_force="Day"
)

# 返回:
{
  "status": "success",
  "order_id": "123456789",
  "message": "订单已提交: AAPL.US Buy 10股"
}
```

### 示例 3: 获取K线数据

```python
# 用户: 获取特斯拉最近7天的日K线

# OpenClaw 会调用:
get_candlesticks(
    symbol="TSLA.US",
    period="day",
    count=7,
    adjust_type="NoAdjust"
)

# 返回K线数组
```

## 注意事项

### ⚠️ 风险提示
- 本 skill 仅供学习和技术交流使用
- 股票投资有风险，使用者需自行承担投资风险
- 请勿在生产环境中未经测试直接使用

### 🔒 安全建议
- 妥善保管 API 密钥，不要泄露给他人
- 建议使用模拟账户测试
- 所有交易操作应经过人工确认

### 📝 开发说明
- SDK 基于 Rust 实现，通过 FFI 提供 Python 接口
- 支持同步和异步调用
- 详细 API 文档请参考 [Longbridge 官方文档](https://open.longbridge.com/docs)

## 技术架构

```
┌─────────────────┐
│   OpenClaw      │
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│ Longbridge Skill│
│   (skill.py)    │
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│ Longbridge SDK  │
│   (Python FFI)  │
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│ Longbridge API  │
│  (REST/WebSocket)│
└─────────────────┘
```

## 参考资料

- [Longbridge OpenAPI 文档](https://open.longbridge.com/docs)
- [Python SDK 文档](https://longbridge.readthedocs.io/en/latest/)
- [GitHub 仓库](https://github.com/longportapp/openapi)
- [PyPI 包](https://pypi.org/project/longbridge/)

## 许可证

MIT License

## 作者

genkin

## 版本历史

- v1.0.0 (2026-02-02)
  - 初始版本
  - 支持行情查询、交易下单、账户管理等核心功能
