# Transport Guide — London

Practical transport guide for navigating London. Covers all modes, fares (as of March 2025), and decision-making shortcuts.

---

## System Overview

London has one of the world's most comprehensive public transport networks, run by Transport for London (TfL).

| Mode | Coverage | Best For |
|------|----------|----------|
| **Tube** (Underground) | 11 lines, 272 stations | Central London, cross-city |
| **Bus** | 675+ routes, 24hr coverage | Local trips, night travel |
| **Overground** | Orbital routes, outer zones | Zone 2-6 connections |
| **Elizabeth Line** | West-East corridor + Heathrow | Paddington↔Liverpool St, airports |
| **DLR** | East London, Docklands | Canary Wharf, City Airport, Greenwich |
| **National Rail** | Mainline stations, suburbs | Long distance, airport expresses |
| **River Bus** | Thames piers | Scenic travel, avoiding traffic |

**Key Insight:** The Tube is fastest for central London. Elizabeth Line is modern, spacious, and connects Heathrow to Liverpool Street without changing.

---

## Oyster vs Contactless — Which to Use

### Quick Decision

| Situation | Use |
|-----------|-----|
| **Visitor (1-14 days)** | Contactless (phone/card) |
| **Living in London** | Contactless or Oyster |
| **Want weekly cap** | Contactless (auto-caps Mon-Sun) |
| **Child discount needed** | Oyster with Zip photocard |
| **No contactless card** | Visitor Oyster Card |

### How Capping Works

Pay-as-you-go fares automatically cap at daily/weekly maximums:

| Cap Type | When | How |
|----------|------|-----|
| **Daily Cap** | Resets 04:30 daily | Pay per trip until cap reached, then free |
| **Weekly Cap** | Monday 04:30 → Sunday end | Cumulative across the week |

**Example:** Zone 1-2 daily cap = £8.90. If you take 4 tube trips × £2.90 = £11.60 theoretical cost → you pay only £8.90.

### Visitor Options

- **Visitor Oyster Card:** Pre-loaded, buy online before trip (£5 non-refundable card fee)
- **Oyster Card:** Buy at stations (£7 deposit, refundable)
- **Contactless:** Best option — no card to buy, same prices as Oyster

**Note:** Oyster cards NOT valid to Gatwick, Stansted, or Luton airports. Use contactless or buy National Rail tickets.

---

## Zone System

London is divided into **9 fare zones** as concentric rings from center.

| Zone | What's There |
|------|--------------|
| Zone 1 | Central: Westminster, City, West End, South Bank |
| Zone 2 | Inner: Camden, Brixton, Notting Hill, Greenwich |
| Zone 3 | Middle: Wimbledon, Stratford, Hampstead |
| Zone 4-6 | Outer: Heathrow (Zone 6), Wembley (4), Richmond (4) |
| Zone 7-9 | Far suburbs: Watford, Amersham |

**Pricing Logic:** More zones crossed = higher fare. Staying within one outer zone = cheap. Crossing Zone 1 = more expensive.

**Typical Journeys:**
- Tourist sightseeing day = Zone 1-2 (cap £8.90)
- Heathrow to central = Zone 1-6 (single £5.80 Oyster/contactless)
- Wimbledon to Camden = Zone 2-3 (single £2.30)

---

## Fares — Current Prices (March 2025)

### Single Fares (Oyster/Contactless)

| Journey | Peak | Off-Peak |
|---------|------|----------|
| Zone 1 only | £2.90 | £2.80 |
| Zone 1-2 | £3.50 | £2.90 |
| Zone 1-3 | £3.80 | £3.10 |
| Zone 1-4 | £4.60 | £3.40 |
| Zone 1-5 | £5.20 | £3.60 |
| Zone 1-6 | £5.80 | £3.80 |
| Single zone (2-6) | £2.10 | £2.00 |

**Bus:** £1.75 flat fare (any distance). Hopper fare = unlimited buses within 1 hour for £1.75.

### Daily Caps

| Zones | Daily Cap (Peak & Off-Peak same) |
|-------|----------------------------------|
| Zone 1-2 | £8.90 |
| Zone 1-3 | £10.50 |
| Zone 1-4 | £12.80 |
| Zone 1-5 | £15.30 |
| Zone 1-6 | £16.30 |
| Bus only | £5.25 |

### Weekly Caps

| Zones | Weekly Cap |
|-------|------------|
| Zone 1-2 | £44.70 |
| Zone 1-3 | £52.50 |
| Zone 1-4 | £64.20 |
| Zone 1-5 | £76.40 |
| Zone 1-6 | £81.60 |

**Peak Hours:** Mon-Fri 06:30-09:30 and 16:00-19:00. Weekends/holidays = always off-peak.

---

## Getting from Airports

### Heathrow (Zone 6, 15 miles west)

| Option | Time | Cost | Notes |
|--------|------|------|-------|
| **Elizabeth Line** | 30-40 min | £13.90 (flat) | Best value. Runs to Liverpool St via Paddington |
| **Tube (Piccadilly)** | 50-60 min | £5.80 peak / £3.80 off-peak | Cheapest. Slower, more stops |
| **Heathrow Express** | 15 min | £25 (walk-up) / £10+ advance | Fast but expensive |
| **Bus (National Express)** | 60-90 min | £6-12 | Budget option, to Victoria |

**Recommendation:** Elizabeth Line (best balance). Piccadilly Line if budget-conscious.

### Gatwick (30 miles south)

| Option | Time | Cost | Notes |
|--------|------|------|-------|
| **Gatwick Express** | 29 min | £19.90 (online) | Direct to Victoria |
| **Southern/Thameslink** | 30-45 min | £10-15 | Cheaper, more stops |
| **National Express** | 70-90 min | £8-15 | Budget option |

**Recommendation:** Southern trains (similar speed, lower price than Express). Oyster NOT valid.

### Stansted (40 miles northeast)

| Option | Time | Cost | Notes |
|--------|------|------|-------|
| **Stansted Express** | 47 min | £9.90+ advance / £21 walk-up | Direct to Liverpool Street |
| **National Express** | 60-90 min | £7-12 | Budget, to Victoria/Liverpool St |

**Recommendation:** Book Stansted Express in advance. Coach if budget matters more than time.

### Luton (32 miles north)

| Option | Time | Cost | Notes |
|--------|------|------|-------|
| **Train + DART shuttle** | 36-50 min | £12.30 off-peak contactless + £4.90 DART | To St Pancras |
| **National Express** | 65-85 min | £7-14 | Direct to Victoria |

**Note:** No direct train. Must take shuttle (DART) from Luton Parkway. Oyster NOT valid.

### London City (Zone 3, Docklands)

| Option | Time | Cost | Notes |
|--------|------|------|-------|
| **DLR** | 22 min to Bank | £2.90-3.50 | Easy, frequent |

**Recommendation:** DLR is the only sensible option. Connects to Tube at Bank/Stratford.

---

## Key Tube Lines — What They Connect

| Line | Useful For |
|------|------------|
| **Central** (red) | Oxford St, Notting Hill, Stratford, Liverpool St |
| **Victoria** (blue) | Victoria Station, King's Cross, Oxford Circus |
| **Piccadilly** (dark blue) | Heathrow, Covent Garden, King's Cross |
| **Northern** (black) | Camden, London Bridge, Bank, Waterloo |
| **Jubilee** (silver) | Westminster, Canary Wharf, Stratford, Waterloo |
| **District** (green) | Westminster, Kensington, Richmond, Wimbledon |
| **Circle/H&C** (yellow/pink) | All mainline stations loop |
| **Elizabeth** (purple) | Heathrow, Paddington, Liverpool St, Canary Wharf |

**Tourist Line:** Central + Jubilee cover most major attractions.

---

## Cycling — Santander Bikes

Public bike-share scheme covering central/inner London.

### Pricing

| Option | Cost | Notes |
|--------|------|-------|
| **Single ride** | £1.65 / 30 min | E-bikes: £3.00 / 30 min |
| **Day Pass** | £3.50 | Unlimited 60-min rides for 24hr |
| **Annual** | £120/year | Unlimited 60-min rides |

**How It Works:**
1. Find a docking station (800+ stations)
2. Use app or card to unlock bike
3. Dock at any station within time limit (or pay extra)
4. E-bikes available (1 in 6 bikes)

**Tips:**
- Dock every 55 min to reset timer
- Cycleways improving but traffic still dangerous
- Wear helmet (not required but advisable)
- Left-hand traffic — stay alert

---

## Driving — Why NOT to Drive

### The Costs

| Charge | Amount | When |
|--------|--------|------|
| **Congestion Charge** | £15/day | Mon-Fri 07:00-18:00, Sat-Sun 12:00-18:00 |
| **ULEZ** | £12.50/day | 24/7, all Greater London (non-compliant vehicles) |
| **Parking** | £2-8/hour | Central London average |

**Combined worst case:** £15 + £12.50 + £30 parking = £57.50/day just to access central London.

### ULEZ Compliance
- Most petrol cars from 2006+ are compliant
- Most diesel cars from 2015+ are compliant
- Check: tfl.gov.uk/modes/driving/check-your-vehicle

**Bottom Line:** Public transport is cheaper, faster, and less stressful. Only drive if going outside London.

---

## Late Night Transport

### Night Tube (Fri-Sat nights only)

24-hour service on 5 lines:
- **Central:** West Ruislip ↔ Epping (every 10 min)
- **Jubilee:** Stanmore ↔ Stratford (every 10 min)
- **Northern:** High Barnet/Edgware ↔ Morden (every 8-20 min)
- **Piccadilly:** Cockfosters ↔ Heathrow T5 (every 10 min)
- **Victoria:** Walthamstow ↔ Brixton (every 10 min)

**Standard off-peak fares apply.**

### Night Buses

- N-prefixed routes (e.g., N11, N26, N207)
- Run 23:00-05:00 when Tube closed
- Key hub: Trafalgar Square
- Cover most of Greater London
- Same fares as day buses (£1.75)

### Last Trains (Sun-Thu)

Most Tube lines stop around **00:00-00:30**. Plan accordingly or switch to Night Bus.

---

## Apps — What to Use

| App | Best For | Features |
|-----|----------|----------|
| **Citymapper** | Journey planning | Best routes, real-time, multimodal, works offline |
| **TfL Go** | Official TfL app | Live arrivals, service status, Oyster balance |
| **Google Maps** | Fallback | Works everywhere but less accurate timing |

### Recommendations

- **Install both** Citymapper + TfL Go
- **Citymapper** for routing (more accurate ETAs, shows walking shortcuts)
- **TfL Go** for live status alerts and checking your fare spending

**Contactless users:** Link card to TfL account online to see journey history and spending.

---

## Quick Decision Rules

| Situation | Do This |
|-----------|---------|
| Heathrow → Central | Elizabeth Line (£13.90, 35 min) |
| Gatwick → Central | Southern train (£12, 35 min) |
| Stansted → Central | Book Stansted Express advance (£9.90+) |
| Just moving around Zone 1-2 | Tube + contactless, cap at £8.90 |
| Late night (1-5am) | Night Bus or Uber |
| Short trip (&lt;2 miles) | Walk or Santander Bike |
| Rush hour + long journey | Check Elizabeth Line (less crowded) |
| Multiple people | Consider Uber/taxi (competitive when split) |

---

*Prices as of March 2025. Check tfl.gov.uk for latest fares.*
