# Student Guide — London

## Universities Overview

### Top Institutions

| University | Ranking (World) | Strengths | Location |
|------------|-----------------|-----------|----------|
| **Imperial College** | Top 10 | STEM, medicine, business | South Kensington |
| **UCL** | Top 20 | Everything, largest UK uni | Bloomsbury |
| **LSE** | Top 50 | Economics, politics, social sciences | Holborn |
| **King's College** | Top 50 | Medicine, law, humanities | Strand/London Bridge |
| **Queen Mary** | Top 150 | Medicine, law, sciences | Mile End |
| **City, University of London** | Top 350 | Business, journalism | Clerkenwell |
| **Goldsmiths** | Varies | Arts, media, culture | New Cross |
| **SOAS** | Specialist | Asian/African studies, languages | Bloomsbury |
| **Royal College of Art** | #1 art/design | Art, design | Kensington |
| **UAL (Central Saint Martins)** | Top art/design | Fashion, art, design | King's Cross |

### Tuition Fees (2025)

| Student Type | Annual Fee |
|--------------|------------|
| UK students | £9,250 |
| International (undergrad) | £20,000-45,000 |
| International (postgrad) | £18,000-50,000+ |
| MBA | £50,000-100,000 |

## Student Areas

### By University

| University | Best Areas | Why |
|------------|------------|-----|
| **UCL/SOAS** | Bloomsbury, King's Cross, Camden | Walking distance, student vibe |
| **LSE** | Waterloo, Southwark, Elephant & Castle | Close, Zone 1, cheaper than WC |
| **Imperial** | South Ken (expensive), Hammersmith, Acton | Tube access |
| **King's (Strand)** | Waterloo, Southwark, Bermondsey | Short commute, river views |
| **Queen Mary** | Mile End, Bow, Bethnal Green, Stratford | Walking distance, cheap |

### Student-Friendly Neighborhoods

| Area | Rent (room) | Vibe |
|------|-------------|------|
| **Mile End/Bow** | £700-900 | Student central, near Queen Mary |
| **Stratford** | £750-950 | Good transport, newer flats |
| **Peckham** | £700-900 | Arty, young, still affordable |
| **Lewisham** | £650-850 | Cheap, improving, DLR access |
| **Walthamstow** | £700-900 | Hip, affordable, Victoria line |
| **Camden** | £850-1,100 | Classic student, busy, connected |

## Housing Options

### University Halls vs Private

| Type | Cost/week | Pros | Cons |
|------|-----------|------|------|
| **Uni halls (catered)** | £250-400 | All-inclusive, social, safe | Expensive, less freedom |
| **Uni halls (self-catered)** | £180-300 | Social, no bills | Can be dated |
| **Private purpose-built** | £200-350 | Modern amenities, bills included | Expensive, less social |
| **Private flat share** | £150-250 | Cheapest, real London life | Finding good housemates |

### Finding Private Housing

| Platform | Best For |
|----------|----------|
| **SpareRoom** | Room shares, flat shares |
| **Rightmove/Zoopla** | Whole flats |
| **OpenRent** | Direct from landlords (no fees) |
| **Facebook groups** | Uni-specific housing groups |

**Warning:** Deposit scams exist. Never pay before viewing. Use official platforms.

### Deposit Rules

- Maximum 5 weeks rent (6 weeks if rent >£50K/year)
- Must be in government deposit scheme
- Get inventory signed at move-in

## Student Budget

### Monthly Breakdown (2025)

| Expense | Tight Budget | Comfortable |
|---------|--------------|-------------|
| **Rent (room share)** | £800 | £1,000 |
| **Bills (if not included)** | £80 | £100 |
| **Transport** | £90 | £150 |
| **Groceries** | £150 | £220 |
| **Phone** | £10 | £20 |
| **Books/supplies** | £20 | £50 |
| **Entertainment** | £100 | £200 |
| **Misc** | £50 | £100 |
| **TOTAL** | £1,300 | £1,840 |

**Reality check:** London is expensive. Budget £1,300-2,000/month minimum for living costs.

### Money-Saving Tips

| Area | Tip |
|------|-----|
| **Transport** | 18+ Student Oyster = 30% off |
| **Groceries** | Aldi, Lidl are cheapest. "Yellow sticker" reduced items |
| **Eating out** | Too Good To Go app (surplus food cheap) |
| **Clothes** | Charity shops in wealthy areas |
| **Entertainment** | Student discounts everywhere (UNiDAYS app) |
| **Books** | Library, Blackwell's used, Z-library |

## Part-Time Work

### Rules for International Students

| Visa Type | Work Allowed |
|-----------|--------------|
| **Student visa (term time)** | 20 hours/week |
| **Student visa (vacation)** | Full-time |
| **Post-study (Graduate visa)** | Full-time, any work |

### Typical Student Jobs

| Job | Pay (£/hr) | Notes |
|-----|------------|-------|
| Retail | £11.44+ | Minimum wage, flexible |
| Hospitality/bars | £11-14 | Evening/weekend shifts |
| Tutoring | £20-50 | Good for grad students |
| University jobs | £12-15 | Library, student ambassador |
| Internships | £11-20 | Often summer, career-relevant |

**UK minimum wage (21+):** £11.44/hour (2025)

## Student Discounts

### Transport

| Discount | Saving |
|----------|--------|
| **18+ Student Oyster** | 30% off travelcards, weekly caps |
| **16-25 Railcard** | 1/3 off national rail (£30/year, pays for itself fast) |
| **Santander Cycles** | Student rate £35/year |

### Shopping & Services

| Type | Discount |
|------|----------|
| **Amazon Prime** | 50% off (Student Prime) |
| **Apple** | 10-20% on devices |
| **ASOS, H&M, etc.** | 10-20% student discount |
| **Cinema** | Student tickets ~£8-10 |
| **Gyms** | Student rates at PureGym, The Gym (~£20/mo) |
| **Food (Nando's, etc.)** | Various with UNiDAYS/Student Beans |

**Essential apps:** UNiDAYS, Student Beans — unlock most student discounts

## Student Life

### Societies & Clubs

- Every interest imaginable — sports, cultural, professional, random
- Great way to meet people
- Many are free or minimal fees

### Nightlife

| Venue Type | Examples | Notes |
|------------|----------|-------|
| **Student nights** | Union bars, student-targeted clubs | Cheap drinks, ID required |
| **Shoreditch/Dalston** | Hipster clubs, bars | Trendy, 20s crowd |
| **Soho** | Mainstream clubs | Touristy, expensive |
| **Brixton/Peckham** | Live music, alternative | Better value |

**Tip:** Student union bars are cheapest. Monday-Wednesday nights are student night everywhere.

### Libraries & Study Spaces

| Type | Options |
|------|---------|
| **University libraries** | 24/7 during exams, great resources |
| **Public libraries** | British Library (free, must register), local branches |
| **Cafes** | Many with wifi, buy a coffee, stay hours |
| **Co-working** | Some offer student rates |

**British Library:** Free, iconic, amazing reading rooms. Register online first.

## Healthcare (NHS)

### Registration

1. Find GP near your address: nhs.uk/service-search
2. Register in person (bring: passport, proof of address, visa)
3. Wait ~2 weeks for NHS number
4. Book appointments via GP reception or NHS app

### What's Covered

| Service | Cost |
|---------|------|
| GP appointments | Free |
| Hospital (A&E, treatment) | Free |
| Mental health services | Free |
| Prescriptions | £9.90 each (free if low income certificate) |
| Dental (NHS) | Subsidized but limited availability |
| Eye tests | ~£25 (free if certain benefits) |

**Mental health:** Universities have counseling services. NHS also provides free mental health support (long waits, though).

## Student Visa

### Requirements

| Requirement | Detail |
|-------------|--------|
| **CAS** | Confirmation of Acceptance from university |
| **English proof** | IELTS or equivalent (varies by uni) |
| **Funds proof** | £1,334/month for 9 months (£12,006) + tuition |
| **Cost** | £490 visa + £776/year healthcare surcharge (IHS) |

### Graduate Route (Post-Study)

| Feature | Detail |
|---------|--------|
| **Eligibility** | Complete degree in UK on student visa |
| **Duration** | 2 years (3 for PhD) |
| **Work rights** | Any job, any hours, no sponsorship |
| **Path forward** | Find sponsored job → Skilled Worker visa |

## Summary for AI Agent

For student queries:

1. **Budget:** £1,300-2,000/month realistic for London
2. **Housing:** Private room share (£700-1,000) or halls (£180-400/week)
3. **Work:** 20 hours/week on student visa, minimum wage £11.44
4. **Discounts:** 18+ Student Oyster (30% off), UNiDAYS app for everything
5. **Healthcare:** Register with GP, NHS is free
6. **Post-study:** Graduate visa gives 2 years to find sponsored work

---

*Last updated: February 2026*
