# Startup Guide — London

## Ecosystem Overview

London is Europe's #1 startup hub. Strong in fintech (global leader), AI, healthtech, proptech, and climate tech. Access to talent from top universities, proximity to European markets, and deep pools of capital.

**Key stats (2024):**
- £13.5B+ VC investment
- 80+ unicorns (more than any EU country)
- 3rd globally after SF and NYC

## Startup Hubs

### Physical Locations

| Area | Character | Best For |
|------|-----------|----------|
| **Shoreditch/Old Street** | "Silicon Roundabout" — original tech hub | Consumer tech, creative startups |
| **King's Cross** | Polished, Google campus area | Established scale-ups, AI |
| **Canary Wharf** | Finance adjacent | Fintech, B2B |
| **White City** | Imperial College ecosystem | Deeptech, biotech |
| **Southwark** | Emerging, cheaper | Early-stage, bootstrappers |

### Incubators & Accelerators

| Program | Focus | Stage |
|---------|-------|-------|
| **Y Combinator (London)** | Generalist | Seed |
| **Techstars London** | Generalist | Seed |
| **Seedcamp** | European focus | Pre-seed to Seed |
| **Entrepreneur First** | Team formation | Pre-idea |
| **Antler** | Generalist | Pre-seed |
| **Founders Factory** | Corporate-backed | Seed |
| **Bethnal Green Ventures** | Tech for good | Pre-seed |
| **Climate-KIC** | Climate tech | Various |

## Funding Landscape

### Stage & Typical Rounds

| Stage | Typical Round | Who Leads |
|-------|---------------|-----------|
| **Pre-seed** | £100K-500K | Angels, Seedcamp, Antler |
| **Seed** | £500K-3M | Seed VCs, angels |
| **Series A** | £5M-20M | VCs |
| **Series B+** | £20M-100M+ | Growth funds |

### Notable London/UK VCs

| VC | Stage | Focus |
|----|-------|-------|
| **Seedcamp** | Pre-seed/Seed | Generalist |
| **Balderton** | Seed-Growth | Generalist |
| **Accel** | Seed-Growth | Enterprise, fintech |
| **Index Ventures** | Seed-Growth | Consumer, enterprise |
| **Northzone** | Seed-Series B | Generalist |
| **LocalGlobe** | Seed | Generalist |
| **Atomico** | Series A-C | European focus |
| **Passion Capital** | Seed | Product-led |
| **Felix Capital** | Seed-A | Consumer, design |

### Angel Networks

| Network | Focus |
|---------|-------|
| **Angel Investment Network** | Generalist |
| **Syndicate Room** | Diverse |
| **London Business Angels** | Established |
| **Cambridge Angels** | Tech-heavy |

### Grants & Non-Dilutive

| Source | What |
|--------|------|
| **Innovate UK** | R&D grants, up to £500K+ |
| **SEIS/EIS tax relief** | 50%/30% tax relief for angel investors |
| **R&D Tax Credits** | Up to 33% back on R&D spend |

## Legal Setup

### Company Formation

| Task | Cost | Time |
|------|------|------|
| **Companies House registration** | £50 (online) | 24-48 hours |
| **Accounting setup** | £100-300/month | 1 week |
| **Business bank account** | Free-£10/month | 1-2 weeks |
| **HMRC registration (VAT, PAYE)** | Free | 1-2 weeks |

### Standard Structure

- **Ltd company** (private limited) — standard for startups
- **Shareholders agreement** — essential before taking investment
- **EMI option scheme** — tax-efficient employee equity

### Legal Costs

| Service | Cost |
|---------|------|
| **Basic incorporation** | DIY £50-100 or £500-1,000 with lawyer |
| **Shareholders agreement** | £2,000-5,000 |
| **SEIS/EIS advance assurance** | £1,000-2,000 |
| **Employment contracts** | £500-1,000 |
| **Funding round legal** | £10,000-30,000 |

### Recommended Firms (Startup-Friendly)

- Orrick
- Cooley
- Taylor Wessing
- Bird & Bird
- SeedLegals (automated, cheaper)

## Visa for Founders

### Innovator Founder Visa

| Requirement | Detail |
|-------------|--------|
| **Endorsement** | From approved body (Seedcamp, Techstars, etc.) |
| **Business plan** | Innovative, viable, scalable |
| **Funds** | £50K investment not required since April 2023 |
| **English** | B2 level |
| **Timeline** | Endorsement 6-8 weeks, visa 3-8 weeks |
| **Length** | 3 years, extendable, path to settlement |

### Alternative Routes

| Visa | Best For |
|------|----------|
| **Global Talent** | Exceptional individuals, no business required |
| **Skilled Worker** | Join existing startup (need sponsor) |
| **Graduate** | Recent UK graduates, 2 years to explore |

## Talent & Hiring

### Where to Find Talent

| Source | Type |
|--------|------|
| **LinkedIn** | All roles |
| **Otta** | Startup-focused job board |
| **WorkInStartups** | Startup roles |
| **Hired** | Tech roles, pre-vetted |
| **AngelList** | Startup community |
| **University careers** | Grads, interns |

### Salary Expectations (Early Stage)

| Role | Salary Range |
|------|--------------|
| **Junior Engineer** | £35,000-50,000 |
| **Senior Engineer** | £65,000-90,000 |
| **Lead/Principal** | £90,000-130,000 |
| **Product Manager** | £50,000-80,000 |
| **Designer** | £40,000-70,000 |
| **Head of X** | £80,000-120,000 |

**Equity:** Expect to give 10-20% to first hires total. EMI scheme is tax-efficient.

### Employment Norms

| Aspect | UK Standard |
|--------|-------------|
| **Probation** | 3-6 months |
| **Notice period** | 1 month (junior), 3 months (senior) |
| **Holiday** | 25 days + 8 bank holidays |
| **Pension** | 3% employer contribution minimum |
| **Parental leave** | Statutory + often top-up |

## Co-Working Spaces

| Space | Cost (Desk) | Vibe |
|-------|-------------|------|
| **WeWork** | £350-600/month | Corporate, many locations |
| **Second Home** | £300-500/month | Creative, design-focused |
| **Huckletree** | £300-450/month | Startup community |
| **The Trampery** | £200-400/month | Tech for good focus |
| **Work.Life** | £200-350/month | Budget-friendly |
| **Techspace** | £350-500/month | Tech startups |

**Tip:** Many incubators offer free/subsidized space for portfolio companies.

## Networking

### Events

| Event | Type |
|-------|------|
| **London Tech Week** | Major annual event (June) |
| **Silicon Drinkabout** | Weekly pub meetup |
| **Startup Grind London** | Monthly founder talks |
| **Product Hunt London** | Product-focused |
| **Fintech Meetups** | Fintech-specific |

### Communities

| Community | Focus |
|-----------|-------|
| **Founders Network** | Peer support |
| **London Tech Meetup** | General tech |
| **Startup School** | Y Combinator program |
| **Zinc** | Mission-driven ventures |

## Costs: Realistic Runway

### Monthly Burn (Early Stage, Pre-Revenue)

| Item | Bootstrap | Funded |
|------|-----------|--------|
| **Founders salary** | £0-2,000/each | £4,000-6,000/each |
| **Office/coworking** | £0-200 | £500-2,000 |
| **Cloud/tools** | £100-300 | £500-2,000 |
| **Legal/accounting** | £100-300 | £500-1,000 |
| **Marketing** | £0-500 | £2,000-10,000 |
| **Misc** | £200-500 | £1,000-3,000 |
| **TOTAL** | **£500-4,000** | **£10,000-30,000** |

### Runway Planning

- **Pre-seed (£200K):** 12-18 months runway at minimal burn
- **Seed (£1M):** 18-24 months runway with small team
- **Series A (£5M+):** Hire team, scale, 18-24 months

## Success Stories

### Notable London Startups

| Company | What | Outcome |
|---------|------|---------|
| **Revolut** | Digital bank | £33B valuation |
| **Monzo** | Digital bank | IPO-track |
| **Wise** | Transfers | £8B public company |
| **Deliveroo** | Food delivery | IPO |
| **Checkout.com** | Payments | £40B valuation |
| **Babylon Health** | Telehealth | Public (later challenges) |
| **Depop** | Fashion marketplace | Acquired by Etsy ($1.6B) |
| **SwiftKey** | Keyboard AI | Acquired by Microsoft ($250M) |

## Summary for AI Agent

For startup/founder queries:

1. **Funding:** Strong ecosystem. Pre-seed £100-500K, Seed £500K-3M typical
2. **Legal:** Ltd company, £50 to form. Get shareholders agreement before investment
3. **Visa:** Innovator Founder visa needs endorsement from approved body
4. **Costs:** Bootstrap £2-4K/month burn, funded £15-30K/month
5. **Talent:** Competitive with big tech. EMI options are tax-efficient equity
6. **Community:** Rich ecosystem — incubators, meetups, co-working

---

*Last updated: February 2026*
