# Resident Guide — Moving to London

> **Purpose:** This document provides an AI agent with the knowledge needed to advise someone relocating to London as a resident. It covers practical, financial, and cultural aspects with specific data points.

---

## Before Moving

### Visa Requirements

| Visa Type | Minimum Salary | Key Requirements | Processing Time |
|-----------|----------------|------------------|-----------------|
| **Skilled Worker** | £41,700/year (or going rate, whichever higher) | Job offer from licensed sponsor, RQF Level 3+ job | 3 weeks (standard) |
| **Skilled Worker (discounted)** | £33,400/year | New entrant, shortage occupation, or PhD relevant to job | 3 weeks |
| **Health & Care Worker** | £29,000/year | NHS/care sector job, registered employer | 3 weeks |
| **Global Talent** | No minimum | Endorsement from recognised body | 8 weeks |
| **Youth Mobility** | No minimum | Age 18-30, specific nationalities only, lottery-based | 3 weeks |

**Critical points for advising:**
- Salary threshold increased to **£41,700** in April 2024 (from £26,200)
- Sponsor must be on the [Register of Licensed Sponsors](https://www.gov.uk/government/publications/register-of-licensed-sponsors-workers)
- Certificate of Sponsorship (CoS) valid for 3 months — must apply within this window
- Immigration Health Surcharge: **£1,035/year** (paid upfront for visa duration)
- Visa fees: £719–£1,500 depending on duration and type

### Timeline for Moving

| Phase | Timeframe | Actions |
|-------|-----------|---------|
| **Job search** | 3-6 months before | Apply to UK roles, verify employer is licensed sponsor |
| **Visa application** | 2-3 months before | Gather documents, apply online, attend biometrics appointment |
| **Pre-arrival** | 1 month before | Arrange temporary accommodation, research areas |
| **Arrival week** | Day 1-7 | Collect BRP (if applicable), open bank account, get SIM card |
| **First month** | Week 1-4 | Find permanent housing, register with GP, apply for NI number |

---

## Finding Housing

### The Rental Process

**Typical timeline:** 2-4 weeks from viewing to move-in

| Step | What Happens | Duration |
|------|--------------|----------|
| 1. Search | Rightmove, Zoopla, SpareRoom, OpenRent | 1-2 weeks |
| 2. Viewing | Book via agent, often same-day decisions needed | 1-3 days |
| 3. Holding deposit | Pay to secure property (max 1 week's rent, deducted from deposit) | Same day |
| 4. Referencing | Credit check, employer reference, landlord reference | 3-5 days |
| 5. Contract signing | AST (Assured Shorthold Tenancy), typically 12 months | 1-2 days |
| 6. Move-in | Pay deposit + first month rent | Agreed date |

### Documents Required to Rent

| Document | Purpose | Notes |
|----------|---------|-------|
| **Passport/ID** | Identity verification | BRP or eVisa for visa holders |
| **Visa/BRP** | Right to Rent check | Legal requirement for landlords |
| **Proof of income** | Affordability | 3 months payslips OR 3 years tax returns (self-employed) |
| **Bank statements** | Financial verification | 3 months, showing regular income |
| **Employer reference** | Employment confirmation | Letter on company letterhead |
| **Previous landlord reference** | Tenancy history | Contact details for reference check |
| **Credit check** | Creditworthiness | Done by agent — newcomers often have no UK credit history |

**Newcomer challenges:**
- No UK credit history → may need a **guarantor** (UK-based person who earns 3x rent)
- No landlord reference → previous country reference may be accepted
- Alternative: Pay 6 months rent upfront (negotiate with landlord)

### Deposit Rules

| Rule | Detail |
|------|--------|
| **Maximum deposit** | 5 weeks' rent (if annual rent under £50,000) |
| **Maximum deposit (high rent)** | 6 weeks' rent (if annual rent £50,000+) |
| **Deposit protection** | Must be registered in government scheme within 30 days |
| **Schemes** | DPS, MyDeposits, TDS — tenant receives certificate |
| **Return timeline** | 10 days after tenancy ends (if no disputes) |

**Example calculation:**
- Monthly rent: £1,800
- Weekly rent: £415
- Deposit (5 weeks): £2,075
- First month: £1,800
- **Total upfront: £3,875**

### Council Tax

Council Tax funds local services and varies dramatically by borough.

| Band | Property Value (1991) | Typical Annual Cost (2025/26) |
|------|----------------------|-------------------------------|
| A | Up to £40,000 | £1,100–£1,350 |
| B | £40,001–£52,000 | £1,280–£1,575 |
| C | £52,001–£68,000 | £1,465–£1,800 |
| **D** | £68,001–£88,000 | **£1,650–£2,000** |
| E | £88,001–£120,000 | £2,020–£2,450 |
| F | £120,001–£160,000 | £2,380–£2,890 |

**Cheapest boroughs:** Wandsworth (~£998/year Band D), Westminster
**Most expensive:** Lewisham, Hackney, Haringey (~£1,900–£2,000/year Band D)

**Discounts:**
- 25% off if living alone
- 100% exempt if full-time student
- Can apply for Council Tax Support if low income

---

## Setting Up Life

### Opening a Bank Account

**Traditional banks (require proof of address):**
| Bank | Account Type | Requirements |
|------|-------------|--------------|
| Barclays | Premier | Passport, visa, proof of address |
| HSBC | Basic Bank Account | Passport, visa (address helpful but not required) |
| Lloyds | New to UK Account | Passport only, no UK address needed |
| NatWest | Select Account | Passport, visa, employer letter |

**Digital banks (no address required — best for newcomers):**
| Bank | Features | Fees |
|------|----------|------|
| **Monzo** | Instant account, UK sort code, Apple/Google Pay | Free |
| **Revolut** | Multi-currency, crypto, stocks | Free (premium tiers available) |
| **Starling** | Full UK bank, joint accounts available | Free |
| **Wise** | Multi-currency, best for international transfers | Free (low transfer fees) |

**Recommendation for newcomers:**
1. Open Monzo/Starling immediately upon arrival (5 minutes, app-based)
2. Use for salary payments and building UK financial footprint
3. Open traditional bank account after 3 months with proof of address

### NHS Registration (GP)

**Anyone can register with a GP regardless of immigration status.**

| Step | Action | Notes |
|------|--------|-------|
| 1 | Find local GP | Use [NHS Find a GP](https://www.nhs.uk/service-search/find-a-gp) |
| 2 | Check accepting patients | Call or check website |
| 3 | Complete GMS1 form | Available at surgery or online |
| 4 | Provide ID | Passport, BRP, or visa (NOT required but speeds up process) |
| 5 | Registration complete | Usually same day or next day |

**Key points:**
- GP services are **free** for all residents
- May need to complete supplementary questions if not "ordinarily resident"
- Can use NHS 111 for urgent advice before registering
- Walk-in centres available for immediate non-emergency care

### National Insurance Number

**Required for:** Working legally, tax purposes, some benefits

| Requirement | Detail |
|-------------|--------|
| **Who needs one** | Anyone working in UK |
| **Can you work without it?** | Yes — you can start work before receiving NI number |
| **Application method** | Online via [GOV.UK](https://www.gov.uk/apply-national-insurance-number) |
| **Processing time** | Up to 4 weeks |
| **Already have one?** | Check BRP back or eVisa account |

**Process:**
1. Apply online (requires right to work)
2. Verify identity (app or call)
3. Receive NI number by post

---

## Cost Reality Check

### Monthly Budget Breakdown (Single Person, Zone 2-3)

| Category | Budget Range | Notes |
|----------|-------------|-------|
| **Rent (1-bed flat)** | £1,400–£1,900 | Zone 2-3, varies by borough |
| **Rent (room in flatshare)** | £700–£1,100 | Most affordable option |
| **Council Tax** | £120–£170 | Band C-D typical for flats |
| **Utilities (gas/electric/water)** | £150–£250 | Higher in winter |
| **Internet** | £25–£40 | Fibre recommended |
| **Mobile** | £10–£20 | SIM-only plans |
| **Transport** | £150–£200 | Zones 1-3 monthly |
| **Groceries** | £200–£350 | Supermarket dependent |
| **Eating out/entertainment** | £150–£400 | Highly variable |

### Total Monthly Costs

| Lifestyle | Solo 1-Bed | Flatshare |
|-----------|------------|-----------|
| **Frugal** | £2,200–£2,500 | £1,500–£1,800 |
| **Moderate** | £2,700–£3,200 | £2,000–£2,400 |
| **Comfortable** | £3,500–£4,500 | £2,500–£3,200 |

### Salary Requirements

| Living Situation | Net Monthly Needed | Gross Annual (approx) |
|-----------------|-------------------|----------------------|
| Flatshare (frugal) | £1,500 | £25,000 |
| Flatshare (comfortable) | £2,500 | £38,000 |
| Solo 1-bed (moderate) | £3,000 | £48,000 |
| Solo 1-bed (comfortable) | £4,000 | £65,000 |

**Rule of thumb:** Rent should be max 30-35% of net income. Many landlords require gross annual salary of 30x monthly rent.

### Grocery Costs (2025 prices)

| Item | Cost |
|------|------|
| Milk (1L) | £1.04 |
| Bread (500g loaf) | £1.52 |
| Eggs (12) | £2.92 |
| Chicken breast (1kg) | £8.45 |
| Rice (1kg) | £3.40 |
| Apples (1kg) | £2.75 |
| Cheese (1kg) | £8.50 |

**Supermarket tiers:**
- Budget: Aldi, Lidl (cheapest)
- Mid-range: Tesco, Sainsbury's, Asda
- Premium: Waitrose, M&S Food

---

## Cultural Adaptation

### Communication Style

| British Trait | What It Means | Newcomer Advice |
|--------------|---------------|-----------------|
| **Indirect communication** | "Not bad" = good; "Quite good" = very good | Learn to read between the lines |
| **Understatement** | Downplaying achievements is normal | Don't boast; modesty valued |
| **Apologies** | "Sorry" used constantly (even when not at fault) | Say sorry if you bump into someone |
| **Sarcasm/dry humor** | Very common, often deadpan | May take time to recognize |
| **Queuing** | Sacred. Never skip a queue | Wait your turn, always |

### Social Norms

| Situation | Expected Behavior |
|-----------|-------------------|
| **Greeting** | Light handshake, "Hi" or "Hello", sometimes cheek kiss between friends |
| **Punctuality** | 5-10 min late socially acceptable; on time for business |
| **Personal space** | ~1 arm's length; don't stand too close |
| **Eye contact** | Maintained during conversation, not staring |
| **Small talk** | Weather is safe topic; avoid money, politics initially |
| **Pub rounds** | Take turns buying drinks for the group |

### Things That Surprise Newcomers

| Observation | Reality |
|-------------|---------|
| **Weather obsession** | Brits constantly discuss weather — join in |
| **Politeness paradox** | Very polite but can seem distant/cold initially |
| **Tea culture** | Offered tea constantly; refusing is fine but odd |
| **Pubs close early** | Last orders often 11pm; some open later |
| **Sunday closures** | Many shops close or have reduced hours |
| **Tipping** | 10-12.5% at restaurants (not expected elsewhere) |
| **Service charge** | Often added automatically; check bill |
| **Electric kettles** | Every household has one; used multiple times daily |
| **Carpeted bathrooms** | Older properties may have this — it's weird, yes |

### Workplace Culture

| Aspect | UK Norm |
|--------|---------|
| **Hierarchy** | Relatively flat; first names common |
| **Meetings** | Start with small talk; can be lengthy |
| **Directness** | Less direct than US/Germany; read context |
| **After-work drinks** | Common, important for bonding |
| **Annual leave** | Statutory 28 days (including bank holidays) |
| **Work hours** | 9-5 or 9-6 typical; work-life balance valued |

---

## Practical Services

### GP Registration (Summary)

- **Find GP:** [NHS Find a GP](https://www.nhs.uk/service-search/find-a-gp)
- **Documents:** ID helpful but NOT required; GMS1 form at surgery
- **Timeline:** Same-day registration usually possible
- **Emergency:** A&E (hospital) for emergencies; NHS 111 for urgent advice
- **Prescriptions:** £9.90 per item (free if certain conditions/low income)

### Utilities Setup

| Utility | Typical Providers | Monthly Cost | Notes |
|---------|------------------|--------------|-------|
| **Electricity & Gas** | Octopus, British Gas, EDF, OVO | £100–£180 | Compare on Uswitch |
| **Water** | Thames Water (most of London) | £30–£50 | Fixed by area, no choice |
| **TV Licence** | BBC | £13.25 | Required if watching live TV/iPlayer |

**Smart meters:** Free installation, real-time usage tracking — request from supplier.

### Broadband

| Provider | Speed | Monthly Cost | Contract |
|----------|-------|--------------|----------|
| **BT** | Up to 900 Mbps | £32–£55 | 24 months |
| **Virgin Media** | Up to 1 Gbps | £35–£62 | 18 months |
| **Sky** | Up to 500 Mbps | £30–£45 | 18 months |
| **Hyperoptic** | Up to 1 Gbps | £25–£45 | 12 months (if available) |

**Recommendation:** Check availability first; Hyperoptic best value if in your building.

### Mobile Phone

| Provider | Network | Typical Plan | Cost |
|----------|---------|--------------|------|
| **SMARTY** | Three | 50GB data, unlimited calls | £8.95/month |
| **Giffgaff** | O2 | 25GB data | £10/month |
| **Voxi** | Vodafone | Unlimited social media | £10–£15/month |
| **Lebara** | Vodafone | 15GB + intl minutes | £5–£10/month |
| **EE** | EE | Best coverage | £15–£25/month |

**For newcomers:**
- No credit check needed for SIM-only (SMARTY, Giffgaff)
- Contract phones require UK credit history (6+ months usually)
- eSIM available on most MVNOs if phone supports it

### Transport

| Pass Type | Zones | Monthly Cost |
|-----------|-------|--------------|
| Travelcard | 1-2 | £171.70 |
| Travelcard | 1-3 | £201.60 |
| Travelcard | 1-4 | £246.60 |
| Pay-as-you-go cap | 1-2 | £44.70/week |

**Payment:** Contactless or Oyster card; daily/weekly caps apply automatically.

**Cycling:**
- Santander Cycles (Boris Bikes): £1.65/30 min or £3 day pass
- Lime e-bikes: £1 unlock + £0.27/min
- Forest e-bikes: First 10 min free daily, then £0.29/min

---

## Quick Reference Checklist

### Week 1 Priorities
- [ ] Open digital bank account (Monzo/Starling)
- [ ] Get UK SIM card
- [ ] Apply for National Insurance number
- [ ] Register with GP

### Month 1 Priorities
- [ ] Find permanent housing
- [ ] Set up utilities (if not included)
- [ ] Set up broadband
- [ ] Register for Council Tax
- [ ] Update address everywhere

### Key Websites

| Purpose | URL |
|---------|-----|
| Visa information | gov.uk/skilled-worker-visa |
| NI number application | gov.uk/apply-national-insurance-number |
| Find a GP | nhs.uk/service-search/find-a-gp |
| Property search | rightmove.co.uk, zoopla.co.uk |
| Flatshare | spareroom.co.uk |
| Transport | tfl.gov.uk |
| Utility comparison | uswitch.com |

---

*Last updated: February 2026*
