# Local Services Guide — London

## Healthcare (NHS)

### GP Registration

1. **Find a GP:** nhs.uk/service-search/find-a-gp
2. **What to bring:** Passport/ID, proof of address, visa (if applicable)
3. **Register in person** at the surgery
4. **Wait 1-2 weeks** for NHS number
5. **Book via:** Reception, NHS app, or online

**Tip:** Register ASAP when you arrive. Don't wait until you're sick.

### Using the NHS

| Service | How to Access | Wait Time |
|---------|---------------|-----------|
| **GP appointment** | Book via GP or NHS app | Same-day to 2 weeks |
| **NHS 111** | Call/online for advice | Immediate |
| **A&E (Emergency)** | Walk in, any hospital | Hours (varies) |
| **Walk-in/Urgent Care** | No appointment needed | 1-4 hours |
| **Prescriptions** | GP prescribes, collect at pharmacy | Same-day |
| **Specialist referral** | GP refers you | Weeks to months |

### NHS App

- Book/cancel GP appointments
- Order repeat prescriptions
- View medical records
- Access NHS 111 online

### Dental & Vision

| Service | NHS | Private |
|---------|-----|---------|
| **Dental checkup** | £26.80 (hard to find NHS dentist) | £50-100 |
| **Eye test** | £20-30 (free if certain conditions) | £25-40 |

**Reality:** Finding NHS dentist is difficult. Many people pay private.

## Banking

### Opening an Account

#### Digital Banks (Easiest for Newcomers)

| Bank | Account Opening | Features |
|------|-----------------|----------|
| **Monzo** | App, minutes, no UK address needed | Fee-free abroad, instant notifications |
| **Starling** | App, minutes, no UK address needed | Fee-free abroad, smart features |
| **Revolut** | App, instant | Multi-currency, trading |
| **Chase UK** | App, UK address needed | 1% cashback first year |

#### Traditional Banks

| Bank | What You Need |
|------|---------------|
| **Barclays/HSBC/Lloyds** | Proof of address, appointment, ID |
| **Timeline** | 1-2 weeks |

**Recommendation:** Open Monzo/Starling immediately (no proof of address needed), then traditional bank later if needed.

### Building Credit

1. Register to vote (if eligible) — boosts credit score
2. Get on electoral roll at your address
3. Use credit card, pay in full monthly
4. Keep consistent address on records

## Mobile/Phone

### Best Value SIMs (2025)

| Provider | Plan | Cost |
|----------|------|------|
| **SMARTY** | Unlimited everything | £16/month |
| **Voxi** | Unlimited social media + 45GB | £15/month |
| **giffgaff** | Unlimited everything | £18/month |
| **Three** | Unlimited everything | £20/month |
| **Lebara** | 15GB, intl calls | £10/month |

### Contract vs Pay-As-You-Go

| Type | Best For |
|------|----------|
| **PAYG/SIM-only** | Flexibility, no credit check, tourists |
| **Contract** | Financing phone, predictable bills |

**Tip:** UK doesn't need credit history for SIM-only. Get SMARTY or giffgaff on arrival.

## Broadband

### Providers

| Provider | Speed | Cost/month |
|----------|-------|------------|
| **Hyperoptic** | Up to 1Gbps | £25-40 (best if available) |
| **Community Fibre** | Up to 1Gbps | £25-35 |
| **BT** | Up to 900Mbps | £30-50 |
| **Virgin Media** | Up to 1Gbps | £30-55 |
| **Sky** | Up to 500Mbps | £30-45 |

### Tips

- Check what's available at your address first
- Hyperoptic/Community Fibre = best if your building has it
- Minimum contracts usually 12-24 months
- Negotiate at renewal — prices often drop if you threaten to leave

## Utilities

### Setting Up Gas & Electric

1. **Note meter readings** on move-in day
2. **Find current supplier:** Ask landlord or check meters
3. **Switch to better deal:** Use comparison sites (Uswitch, MoneySupermarket)
4. **Smart meter:** Free installation, real-time usage tracking

### Comparison Sites

- Uswitch.com
- MoneySupermarket.com
- Compare the Market

### Average Bills

| Utility | Monthly (1-Bed) |
|---------|-----------------|
| **Gas + Electric** | £80-150 |
| **Water** | £30-50 (often included) |

## Council Services

### Council Tax

- Pay monthly (10 payments, April-January)
- Set up Direct Debit for 2.5% discount (some councils)
- Students exempt — apply for exemption
- Single occupant: 25% discount

### Bin Collection

| Type | Frequency | Notes |
|------|-----------|-------|
| **General waste** | Weekly | Black bin/bags |
| **Recycling** | Weekly/fortnightly | Blue/green bins |
| **Food waste** | Weekly | Brown caddy |
| **Garden waste** | Optional subscription | Green bin |

**Check:** Council website for your collection schedule

### Reporting Issues

| Issue | Report To |
|-------|-----------|
| Potholes, street lights | Council website/app |
| Fly-tipping | Council or FixMyStreet app |
| Noise complaints | Council environmental health |
| Anti-social behavior | Police (101) or council |

## Post & Delivery

### Royal Mail

| Service | Delivery | Cost (letter) |
|---------|----------|---------------|
| 1st Class | Next day (aim) | £1.35 |
| 2nd Class | 2-3 days | £0.85 |
| Special Delivery | Guaranteed next day | £7+ |

### Receiving Packages

| Option | Best For |
|--------|----------|
| **Deliver to workplace** | If allowed |
| **Amazon Locker** | Secure, 24/7 pickup |
| **Click & Collect** | Argos, supermarkets |
| **Parcel locker services** | InPost, Evri lockers |
| **Neighbor delivery** | Standard option |

**Package theft:** Increasing problem. Use lockers or workplace if possible.

## Shopping

### Supermarket Tiers

| Tier | Stores | Notes |
|------|--------|-------|
| **Budget** | Aldi, Lidl | Best value, limited range |
| **Mid** | Tesco, Sainsbury's, Asda, Morrisons | Wide range, meal deals |
| **Convenience** | Tesco Express, Co-op, Sainsbury's Local | Expensive, use for emergencies |
| **Premium** | Waitrose, M&S | Quality focus, higher prices |

### Online Grocery

| Service | Minimum | Delivery |
|---------|---------|----------|
| **Tesco/Sainsbury's/Asda** | £25-40 | £2-7 |
| **Amazon Fresh** | Varies | Free with Prime |
| **Getir/Gorillas** | £10-15 | 15-30 min, £1.99+ |
| **Ocado** | £40 | Delivery slots |

### High Street Essentials

| Need | Where |
|------|-------|
| **Cheap homewares** | Primark, IKEA, TK Maxx |
| **Pharmacy** | Boots, Superdrug, Lloyds |
| **Electronics** | Currys, Argos, John Lewis |
| **DIY** | B&Q, Screwfix, Wickes |

## Laundry

### Options

| Type | Cost | Notes |
|------|------|-------|
| **In-flat washing machine** | Your bills | Best option, not always available |
| **Communal laundry (building)** | £2-4/wash | Common in newer builds |
| **Launderette** | £4-6/wash + dry | Declining, find via Google Maps |
| **Dry cleaning** | £8-15/item | Timpson, local shops |

**Reality:** Many older flats don't have washing machines. Check before renting.

## Community Resources

### Libraries

- **Free to join** with proof of address
- Books, audiobooks, ebooks (Libby app)
- Free wifi and computers
- Quiet study space
- Events and activities

**Best:** British Library (free, must register online first)

### Community Centers

- Classes (language, fitness, crafts)
- Meetup spaces
- Support services
- Often subsidized or free

### Local Facebook Groups

- Every neighborhood has one
- Good for: recommendations, selling items, local info, making friends
- Search: "[Neighborhood] Community" on Facebook

## Summary for AI Agent

For local services:

1. **NHS:** Register with GP immediately. Use NHS app. 111 for advice
2. **Banking:** Monzo/Starling for instant account, no address needed
3. **Mobile:** SMARTY or giffgaff, £15-18/month unlimited
4. **Broadband:** Check Hyperoptic/Community Fibre first, otherwise BT/Virgin
5. **Council tax:** Pay monthly, students exempt, single = 25% off
6. **Package delivery:** Use Amazon Lockers to avoid theft

---

*Last updated: February 2026*
