# Cost of Living Guide — London

## Overview

London is one of the world's most expensive cities. Housing takes the biggest chunk of income. However, many things (museums, NHS healthcare, parks) are free. The key is understanding where money goes and how to optimize.

**Global ranking:** #1 most expensive UK city, top 10-15 globally.

## Housing Costs

### Rent by Area and Type (Monthly, 2025)

| Area | Room Share | Studio | 1-Bed | 2-Bed |
|------|------------|--------|-------|-------|
| **Zone 1 (Central)** | £900-1,300 | £1,600-2,200 | £2,000-3,000 | £2,800-4,500 |
| **Zone 2** | £750-1,000 | £1,300-1,700 | £1,500-2,200 | £2,000-3,000 |
| **Zone 3** | £650-850 | £1,100-1,400 | £1,300-1,700 | £1,600-2,200 |
| **Zone 4-5** | £550-750 | £900-1,200 | £1,100-1,500 | £1,400-1,900 |

### Deposit & Upfront Costs

| Cost | Amount |
|------|--------|
| **Deposit** | Max 5 weeks rent (6 if rent >£50K/year) |
| **First month** | Due upfront |
| **Holding deposit** | Max 1 week rent (deducted from deposit) |
| **Agency fees** | Banned for tenants since 2019 |
| **Reference checks** | Free (paid by landlord) |

**Total upfront:** ~6 weeks rent minimum

## Bills & Utilities

### Council Tax

| Band | Annual (Westminster) | Annual (Outer Borough) |
|------|---------------------|----------------------|
| A | £600-800 | £1,000-1,200 |
| B | £700-950 | £1,150-1,400 |
| C | £850-1,100 | £1,300-1,600 |
| D | £950-1,250 | £1,500-1,850 |
| E+ | £1,100-2,500+ | £1,800-3,000+ |

**Note:** Students are exempt. Single occupants get 25% discount.

### Monthly Utilities (1-Bed Flat)

| Utility | Monthly Cost |
|---------|--------------|
| **Gas + Electric** | £80-150 (varies by season) |
| **Water** | £30-50 (often included in rent) |
| **Broadband** | £25-40 |
| **TV License** | £13.25/month (£159/year, required if watching live TV) |
| **Contents insurance** | £10-20 |

**Total utilities:** £150-250/month for 1-bed

## Transport Costs

### Oyster/Contactless (2025 Prices)

| Journey Type | Peak | Off-Peak |
|--------------|------|----------|
| **Single (Zones 1-2)** | £2.80 | £2.70 |
| **Single (Zones 1-3)** | £3.50 | £3.00 |
| **Single (Zones 1-6)** | £5.60 | £4.10 |
| **Bus single** | £1.75 | £1.75 |

### Daily & Weekly Caps

| Zones | Daily Cap | Weekly Cap |
|-------|-----------|------------|
| 1-2 | £8.60 | £44.70 |
| 1-3 | £10.00 | £52.30 |
| 1-4 | £12.30 | £63.90 |
| 1-6 | £15.20 | £78.80 |

### Monthly Pass Options

| Option | Cost | Best For |
|--------|------|----------|
| **Contactless capping** | Auto (daily/weekly) | Most people |
| **Monthly Travelcard** | £171.70 (Zones 1-2) | Heavy commuters |
| **Annual Travelcard** | £1,788 (Zones 1-2) | Maximum savings |
| **Cycle** | £0-50/month | Bike owners |

## Food & Groceries

### Supermarket Tiers

| Tier | Stores | Weekly Shop (1 person) |
|------|--------|----------------------|
| **Budget** | Aldi, Lidl | £30-45 |
| **Mid-range** | Tesco, Sainsbury's, Asda | £45-65 |
| **Premium** | Waitrose, M&S | £70-100+ |

### Eating Out

| Type | Cost Per Person |
|------|-----------------|
| **Street food/market** | £8-12 |
| **Casual lunch** | £12-18 |
| **Pub meal** | £14-20 |
| **Mid-range dinner** | £25-45 |
| **Nice restaurant** | £50-80 |
| **Fine dining** | £100-200+ |

### Drinks

| Item | Cost |
|------|------|
| **Pint of beer (pub)** | £6-8 |
| **Pint (Zone 1 tourist)** | £8-10 |
| **Glass of wine** | £7-12 |
| **Coffee (chain)** | £3-4.50 |
| **Coffee (specialty)** | £4-5.50 |

## Healthcare

### NHS (Free)

| Service | Cost |
|---------|------|
| GP appointments | Free |
| Hospital treatment | Free |
| A&E/Emergency | Free |
| Mental health | Free |
| Prescriptions | £9.90 each |
| Prescription prepay | £111.60/year (unlimited) |

### Private Healthcare

| Type | Cost |
|------|------|
| **Private GP visit** | £80-200 |
| **Private health insurance** | £50-150/month |
| **Dental checkup (NHS)** | £26.80 |
| **Dental checkup (private)** | £50-100 |
| **Dentist filling (NHS)** | £73.50 |
| **Optician eye test** | £20-30 |

## Entertainment & Lifestyle

| Activity | Cost |
|----------|------|
| **Cinema** | £14-20 |
| **Theatre (West End)** | £25-150 |
| **Gym (budget)** | £20-30/month |
| **Gym (premium)** | £60-150/month |
| **Museums (major)** | Free |
| **Club entry** | £10-25 |
| **Netflix** | £7-18/month |
| **Spotify** | £11/month |

## Childcare

| Type | Cost |
|------|------|
| **Nursery (full-time)** | £1,200-2,500/month |
| **Nanny** | £15-25/hour (£2,500-4,000/month) |
| **Au pair** | £400-500/month + board |
| **After-school club** | £10-20/session |

**Free childcare:** 15-30 hours/week for 3-4 year olds (means-tested)

## Sample Monthly Budgets

### Young Professional (Solo, Zone 2)

| Category | Tight | Comfortable | Premium |
|----------|-------|-------------|---------|
| Rent (1-bed) | £1,500 | £1,800 | £2,200 |
| Bills/utilities | £150 | £180 | £200 |
| Council tax | £130 | £130 | £130 |
| Transport | £90 | £170 | £200 |
| Groceries | £200 | £280 | £350 |
| Eating out | £100 | £250 | £450 |
| Entertainment | £80 | £150 | £300 |
| Phone/subscriptions | £40 | £60 | £80 |
| Savings | £100 | £300 | £600 |
| **TOTAL** | **£2,390** | **£3,318** | **£4,510** |

### Couple (Zone 2, 1-Bed)

| Category | Tight | Comfortable |
|----------|-------|-------------|
| Rent | £1,700 | £2,200 |
| Bills | £180 | £220 |
| Council tax | £130 | £150 |
| Transport (x2) | £180 | £340 |
| Groceries | £350 | £500 |
| Eating out | £200 | £400 |
| Entertainment | £150 | £300 |
| **TOTAL** | **£2,890** | **£4,110** |

### Family (2 Adults + 1 Child, Zone 3)

| Category | Amount |
|----------|--------|
| Rent (2-bed) | £1,800-2,200 |
| Bills | £200-250 |
| Council tax | £150-180 |
| Transport | £250-350 |
| Groceries | £500-650 |
| Childcare | £800-1,500 |
| Child expenses | £200-400 |
| **TOTAL** | **£3,900-5,530** |

## Required Salary

### To Live Comfortably (After Tax)

| Situation | Min Gross Salary |
|-----------|------------------|
| **Single, flat share** | £35,000-45,000 |
| **Single, solo flat** | £48,000-65,000 |
| **Couple (combined)** | £70,000-100,000 |
| **Family with childcare** | £100,000-150,000+ |

**Rule of thumb:** You need gross salary ~3x your annual rent to be comfortable.

## Money-Saving Tips

### Housing

| Tip | Savings |
|-----|---------|
| Live in Zone 3-4 | Save £300-600/month on rent |
| Flat share | Save £500-1,000/month vs solo |
| Negotiate rent at renewal | Often 5-10% possible |

### Transport

| Tip | Savings |
|-----|---------|
| Cycle | Save £100-200/month |
| Work from home | Save transport entirely |
| Walk if <30 min | Free + healthy |

### Food

| Tip | Savings |
|-----|---------|
| Cook most meals | Save £200-400/month |
| Shop at Aldi/Lidl | Save 30% vs Tesco |
| Meal prep | Reduces waste + temptation |
| Too Good To Go app | Cheap restaurant food |

### General

| Tip | Savings |
|-----|---------|
| Free museums | Huge (£15-30 per museum elsewhere) |
| Student/young person discounts | 10-30% on most things |
| 16-25 Railcard | 1/3 off trains |
| Library membership | Free books, wifi, coworking |

## Summary for AI Agent

For cost questions:

1. **Rent expectations:** £1,500-2,000/month for decent 1-bed in Zone 2
2. **Total monthly cost (single):** £2,500-3,500 comfortable
3. **Required salary:** £50K+ gross for solo flat, £35K+ for flat share
4. **Big savings:** Live further out, flat share, cycle, cook
5. **Free stuff:** Museums, NHS, parks — take advantage
6. **Council tax:** £100-180/month, exempt if student

---

*Last updated: February 2026*
