# Climate Guide — London

## Overview

London's weather is mild, changeable, and often grey. It's rarely extreme — not too hot, not too cold — but unpredictable. The stereotype of constant rain is overstated: London gets LESS annual rainfall than New York, Sydney, or Rome. The difference is that rain comes as drizzle spread across many days rather than heavy downpours.

**Key insight:** Layers and a waterproof jacket are more useful than an umbrella.

## Monthly Breakdown

| Month | Avg High | Avg Low | Rain (mm) | Rain Days | Daylight | Character |
|-------|----------|---------|-----------|-----------|----------|-----------|
| **January** | 8°C | 3°C | 55 | 11 | 8h | Cold, grey, short days |
| **February** | 9°C | 3°C | 40 | 9 | 10h | Cold, damp, days lengthening |
| **March** | 12°C | 4°C | 37 | 10 | 12h | Spring emerging, variable |
| **April** | 14°C | 6°C | 45 | 10 | 14h | Showers, blooming parks |
| **May** | 18°C | 9°C | 50 | 9 | 16h | Pleasant, occasionally warm |
| **June** | 21°C | 12°C | 45 | 8 | 17h | Warm, long days, occasional storms |
| **July** | 24°C | 14°C | 45 | 8 | 16h | Warmest, can be humid |
| **August** | 23°C | 14°C | 50 | 8 | 15h | Warm, humid spells |
| **September** | 20°C | 11°C | 50 | 8 | 13h | Mild, pleasant, autumn begins |
| **October** | 15°C | 8°C | 60 | 10 | 11h | Cool, autumn colors |
| **November** | 11°C | 5°C | 60 | 10 | 9h | Cold, grey, damp |
| **December** | 8°C | 3°C | 55 | 10 | 8h | Cold, festive, dark early |

## What to Pack

### Year-Round Essentials

| Item | Why |
|------|-----|
| **Waterproof jacket** | Essential. Light, packable. Better than umbrella on windy days |
| **Layers** | T-shirt + sweater + jacket. Temperatures vary day to day |
| **Comfortable walking shoes** | Waterproof preferred. You'll walk 10-15km/day easily |
| **Small umbrella** | For heavier rain. Compact, fits in bag |
| **Scarf** | Useful Oct-Apr for variable temperatures |

### By Season

| Season | Pack | Don't Need |
|--------|------|------------|
| **Winter (Dec-Feb)** | Warm coat, hat, gloves, scarf, thermal layer | Heavy snow boots (rarely needed) |
| **Spring (Mar-May)** | Light jacket, layers, umbrella | Heavy coat (most days) |
| **Summer (Jun-Aug)** | T-shirts, light trousers, sunglasses, sunscreen, cardigan for evenings | Heavy rain gear (but pack light jacket) |
| **Autumn (Sep-Nov)** | Layers, jacket, waterproof shoes | Summer-only clothes |

## Seasonal Differences

### Winter (December - February)

- **Feel:** Cold, grey, short daylight (dark by 4pm)
- **Temperature:** 3-9°C typical
- **Rain:** Frequent light drizzle
- **Good for:** Museums, theatre, pubs, Christmas markets (Dec)
- **Challenges:** Dark early, need indoor backup plans

### Spring (March - May)

- **Feel:** Variable, gradually warming, parks blooming
- **Temperature:** 8-18°C, can swing 10°C in a day
- **Rain:** April showers are real
- **Good for:** Parks, outdoor markets, walking
- **Best month:** May (most pleasant weather)

### Summer (June - August)

- **Feel:** Warm to hot, can be humid, occasional thunderstorms
- **Temperature:** 18-25°C typical, heatwaves can hit 30°C+
- **Rain:** Less frequent but sudden storms
- **Good for:** Everything outdoor, rooftop bars, parks, festivals
- **Challenges:** Peak tourist crowds, tube gets hot (no AC on most lines)

### Autumn (September - November)

- **Feel:** Cooling, beautiful park colors, cozy
- **Temperature:** 8-18°C, dropping through season
- **Rain:** Increasing, more grey days
- **Good for:** Museums, pubs, walks in fallen leaves
- **Best month:** September (still pleasant, fewer tourists)

## Common Misconceptions

| Myth | Reality |
|------|---------|
| "It always rains" | Annual rainfall less than NYC, Sydney, Rome. Just spread across more days as drizzle |
| "It's freezing in winter" | Rarely below 0°C. Mild compared to most of North America/Europe |
| "Summers are cold" | July often 24-27°C, heatwaves hit 30°C+. Summers are warm |
| "You need an umbrella always" | Waterproof jacket is more practical. Wind makes umbrellas useless |
| "Winter is snowy" | Snow maybe 2-3 days per year. Rarely sticks in central London |

## Best Weather Months

| Goal | Best Months | Why |
|------|-------------|-----|
| **Best overall** | May, September | Pleasant temps, manageable crowds |
| **Longest days** | June (17h daylight) | Sunset after 9pm, maximum outdoor time |
| **Warmest** | July-August | 23-25°C average, occasional 30°C+ |
| **Avoid** | January-February | Grey, cold, short days (unless seeking deals) |

## Indoor Backup Plans

When weather turns bad:

| Type | Options |
|------|---------|
| **Museums** | British Museum, V&A, Natural History (all free), Tate Modern |
| **Shopping** | Westfield, Regent Street, Liberty, covered markets |
| **Food halls** | Borough Market (mostly covered), Seven Dials Market, Mercato Mayfair |
| **Culture** | West End shows (matinees), cinemas, Royal Festival Hall |
| **Experiences** | Afternoon tea, cooking classes, escape rooms |
| **Pubs** | Perfect rainy day activity — cozy, warm, all-day food |

## Housing: Heating & Cooling

### What to Expect

| Feature | UK Reality |
|---------|------------|
| **Air conditioning** | Rare in homes/apartments. Few hotels have it |
| **Heating** | Gas central heating standard. Usually excellent |
| **Double glazing** | Common but not universal. Some older buildings drafty |
| **Summer heat** | Homes can get HOT in heatwaves. Fans help |

### Tips for Residents/Long Stays

- **Summer:** Buy a fan. Seriously. Heatwaves with no AC are brutal
- **Winter:** Heating is usually good but bills are expensive
- **Rental tip:** Ask about Energy Performance Certificate (EPC) rating

## Seasonal Affective Disorder (SAD)

### The Reality of Winter

- November-February: Grey skies, dark by 4pm
- Many residents affected by winter gloom
- London's latitude = fewer winter daylight hours than much of US

### How Londoners Cope

| Strategy | Details |
|----------|---------|
| **Light therapy** | SAD lamps popular (simulate daylight) |
| **Vitamin D** | Supplements common Oct-Mar (NHS recommends) |
| **Plan ahead** | Book theatre, restaurants, indoor activities for winter |
| **Escape** | Cheap flights to Spain/Portugal (2h away) |
| **Embrace it** | Cozy pubs, Christmas markets, indoor culture |

## Weather Apps

| App | Best For |
|-----|----------|
| **Met Office** | Official UK weather. Most accurate forecasts |
| **BBC Weather** | Good interface, reliable |
| **Citymapper** | Shows weather for your commute |
| **Dark Sky** | Minute-by-minute rain predictions (now Apple only) |

**Pro tip:** Check weather morning of — forecasts change frequently. Always have a jacket just in case.

## Summary for AI Agent

London weather guidance:

1. **Reassure:** It's mild, not extreme. Less rainy than reputation suggests
2. **Key advice:** Pack layers + waterproof jacket. Skip heavy umbrella
3. **Best months:** May and September (weather + crowds balance)
4. **Summer reality:** Actually warm (July avg 24°C), can be humid, tube gets hot
5. **Winter reality:** Cold but mild (rarely freezing), grey, dark early (4pm)
6. **Always:** Have indoor backup plans ready

---

*Last updated: February 2026*
