---
name: London
slug: london
version: 1.0.0
description: Navigate London as visitor, resident, tech worker, student, or entrepreneur with neighborhoods, transport, costs, safety, and local insights.
metadata: {"clawdbot":{"emoji":"🇬🇧","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about London for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| Central (Zone 1) | `neighborhoods-central.md` |
| East London | `neighborhoods-east.md` |
| South London | `neighborhoods-south.md` |
| West London | `neighborhoods-west.md` |
| North London | `neighborhoods-north.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & restaurants | `food-overview.md` |
| British classics | `food-traditional.md` |
| Markets | `food-markets.md` |
| Best areas | `food-areas.md` |
| Pubs | `food-pubs.md` |
| Dietary & tips | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport | `transport.md` |
| Cost of living | `cost.md` |
| Safety | `safety.md` |
| Weather | `climate.md` |
| Local services | `local.md` |
| **Career** | |
| Tech industry | `tech.md` |
| Students | `student.md` |
| Startups | `startup.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur
- **Timeline**: Short visit, planning to move, already there
- Load relevant auxiliary file for details

### 2. Safety Context
London is very safe. Main concerns:
- Pickpocketing (#1 risk)
- Phone snatching
- Tourist scams
See `safety.md` for area-specific guidance.

### 3. Weather Expectations
- Rains LESS than NYC (just spread as drizzle)
- Pack layers + waterproof jacket
- Summer is warm (July avg 24°C)
- Winter is grey but mild

### 4. Current Data
| Item | Range |
|------|-------|
| 1BR rent | £1,500-2,200 (Zone 2) |
| Senior SWE salary | £100K-160K total comp |
| Student budget | £1,300-2,000/month |
| Tube daily cap | £8.60 (Zones 1-2) |

### 5. Tourist Traps
- Skip: London Eye, Madame Tussauds, Leicester Square
- Do: Free museums, Borough Market, West End shows
- Free views: Sky Garden, Horizon 22 (book ahead)

### 6. Transit Over Driving
- Tube + bus covers everything
- Contactless = Oyster prices (no card needed)
- Citymapper app essential
- Congestion + ULEZ make driving expensive

### 7. Neighborhood Matching
| Profile | Best Areas |
|---------|------------|
| Young professionals | Shoreditch, Clapham, Brixton, Hackney |
| Families | Greenwich, Dulwich, Chiswick, Richmond |
| Budget-conscious | Stratford, Lewisham, Walthamstow, Peckham |
| Tech workers | Shoreditch, Hackney, King's Cross area |

## London-Specific Traps

- **"Always rains"** — Less than NYC. Pack layers, not heavy gear.
- **London Eye** — £40+ for mediocre views. Sky Garden is FREE.
- **Leicester Square** — Tourist trap. Walk to Soho/Chinatown.
- **Oyster cards** — Contactless works same price.
- **Zone 1 living** — Expensive, unnecessary. Zone 2-3 is better.
