# Logo Types

## Primary Categories

| Type | Description | Best For | Examples |
|------|-------------|----------|----------|
| **Wordmark** | Company name in stylized typography | Distinctive names, text-based brands | Google, Coca-Cola, FedEx |
| **Lettermark** | Initials or abbreviation | Long company names, corporate feel | IBM, HBO, CNN |
| **Symbol/Icon** | Abstract or pictorial mark only | Established brands, global reach | Apple, Nike, Twitter |
| **Combination** | Symbol + wordmark together | New brands needing flexibility | Adidas, Burger King, Lacoste |
| **Emblem** | Text inside a symbol/badge | Traditional, institutional feel | Starbucks, Harley-Davidson, NFL |

---

## Selection Guide

**Choose Wordmark when:**
- Your name is short and distinctive
- Typography IS your brand identity
- You're building initial name recognition

**Choose Lettermark when:**
- Full name is long or awkward
- Operating in formal/corporate contexts
- Initials are memorable (avoid generic combos)

**Choose Symbol when:**
- You have (or will have) massive brand recognition
- Operating across languages/cultures
- Need extreme scalability

**Choose Combination when:**
- Starting from zero recognition
- Need flexibility (sometimes icon-only, sometimes full)
- Most versatile option for new brands

**Choose Emblem when:**
- Tradition, heritage, authority matter
- Industry expects it (law, education, government)
- Warning: scales poorly, complex at small sizes

---

## The Flexibility Test

Good logos work in multiple configurations:

```
Full lockup:      [ICON] Company Name
Horizontal:       [ICON] Company Name
Stacked:          [ICON]
                  Company Name
Icon only:        [ICON]
```

If your logo only works as one lockup, you'll hit problems when:
- Favicon needed (icon-only required)
- Social media avatars (square crop)
- Narrow spaces (horizontal only)
- Video/animation (separate elements)

---

## Typography Considerations

**For wordmarks and combination marks:**

| Font Category | Personality | Watch Out For |
|---------------|-------------|---------------|
| Sans-serif | Modern, clean, tech | Generic if not customized |
| Serif | Traditional, trustworthy, luxury | Can feel dated |
| Script | Personal, creative, elegant | Legibility at small sizes |
| Display | Distinctive, bold, memorable | Trends date quickly |

**Modifications that make generic fonts unique:**
- Custom letter connections
- Modified terminals or curves
- Integrated symbols (FedEx arrow)
- Unique letter spacing

---

## Industry Patterns

Not rules, but common conventions:

| Industry | Common Approach |
|----------|-----------------|
| Tech/Startup | Sans-serif wordmark or abstract symbol |
| Finance | Serif wordmark or lettermark |
| Food/Restaurant | Emblem or illustrated symbol |
| Fashion/Luxury | Clean wordmark, often serif |
| Sports | Bold symbol, dynamic shapes |
| Healthcare | Abstract symbol, blue/green, trustworthy |

Breaking patterns can differentiate, but understand why they exist first.
