# Logo Design Process

## Phase Overview

| Phase | Duration | Output |
|-------|----------|--------|
| 1. Brief | 1-2 days | Written brief document |
| 2. Research | 2-3 days | Competitor analysis, moodboard |
| 3. Concepts | 3-5 days | 3-5 distinct directions |
| 4. Refinement | 3-5 days | 2-3 polished options |
| 5. Finalization | 2-3 days | Selected logo, minor tweaks |
| 6. Delivery | 1-2 days | Full file package |

Total: 2-4 weeks for professional process. Faster is possible but usually means shortcuts.

---

## Phase 1: Brief

**Essential questions to answer:**

About the company:
- What do you do in one sentence?
- Who are your customers?
- What makes you different from competitors?
- Where will the logo appear most often?

About the logo:
- Any existing brand elements to incorporate?
- Colors you love or hate?
- Logos you admire (even from other industries)?
- Logos of competitors to avoid resembling?
- Any required elements (icon, full name, tagline)?

**Red flags in briefs:**
- "Make it pop" (meaningless)
- "I'll know it when I see it" (no direction)
- "Like Apple/Nike but for us" (impossible standard)
- No clarity on decision makers (design by committee incoming)

---

## Phase 2: Research

**Competitor audit:**
- Screenshot top 5-10 competitor logos
- Note common patterns (colors, shapes, typography)
- Identify differentiation opportunities
- Flag what to avoid (looking like others)

**Visual research:**
- Collect 20-30 images that feel right for the brand
- Include non-logo images (photography, texture, objects)
- Note recurring themes (colors, shapes, moods)
- Create moodboard for alignment check

**Before moving on:** Stakeholder approval on research direction. Disagreement here means disaster later.

---

## Phase 3: Concepts

**How many concepts:**
- Minimum 3, maximum 6
- Each should be genuinely different (not variations)
- Cover different logo types if appropriate

**Presentation tips:**
- Show in context (business card, website, app icon)
- Present in black and white first (test without color crutch)
- Explain thinking behind each direction
- Present to one decision maker if possible

**Feedback questions:**
- Which direction feels closest to the brand?
- What specific elements do you like from each?
- What's missing or feels wrong?

---

## Phase 4: Refinement

**Based on concept feedback:**
- Narrow to 2-3 directions
- Create variations within chosen directions
- Test at multiple sizes
- Try different color options
- Develop secondary elements (icon-only, stacked, horizontal)

**Internal testing:**
- Squint test (recognizable when blurred?)
- Thumbnail test (works at 16px?)
- Context test (looks right on actual materials?)
- Memory test (can someone sketch it after seeing once?)

---

## Phase 5: Finalization

**Final selection process:**
- Present polished options with full context
- Allow 24-48 hours for decision (avoid snap judgments)
- Minor tweaks only at this stage (no new directions)

**What "minor tweaks" means:**
- Adjusting spacing
- Shifting color values slightly
- Refining curves or angles
- NOT changing the entire concept

**Sign-off requirements:**
- Written approval from decision maker
- Confirmation of exact color values
- Agreement on final lockup configurations

---

## Phase 6: Delivery

**Standard deliverables:**

| Format | Use Case |
|--------|----------|
| SVG | Web, scalable, editable |
| PNG (transparent) | Digital use with backgrounds |
| PNG (on white) | Documents, quick use |
| PNG (on dark) | Dark mode, dark backgrounds |
| PDF | Print, presentations |
| EPS/AI | Print vendors, large format |
| Favicon pack | Website (16, 32, 180, 192px) |

**Color versions needed:**
- Full color (primary)
- Single color (black)
- Single color (white/reversed)
- Grayscale

**Documentation:**
- Color specifications (HEX, RGB, CMYK, Pantone)
- Clear space requirements
- Minimum size specifications
- Usage dos and don'ts

See `formats.md` for detailed file specifications.
