# Hiring Logo Designers

## Options Overview

| Option | Price Range | Timeline | Quality |
|--------|-------------|----------|---------|
| **Fiverr/Upwork freelancers** | $50-500 | 3-7 days | Variable |
| **99designs/DesignCrowd** | $300-1500 | 7-14 days | Variable |
| **Independent designer** | $1000-5000 | 2-4 weeks | Generally good |
| **Small agency** | $5000-20000 | 4-8 weeks | High |
| **Brand agency** | $20000-100000+ | 8-16 weeks | Premium |

---

## Marketplace Platforms

**Fiverr/Upwork:**
- ✅ Fast, cheap, good for testing
- ❌ Quality varies wildly
- ❌ Limited revisions, rushed process
- Best for: Placeholder logos, testing concepts

**Crowdsourcing (99designs, DesignCrowd):**
- ✅ Multiple concepts from different designers
- ✅ Money-back guarantee
- ❌ Spec work concerns (designers work for free unless chosen)
- ❌ Designers spread thin, limited attention
- Best for: When you don't know what you want

---

## Finding Good Freelancers

**Where to look:**
- Dribbble (search "logo design")
- Behance portfolios
- Designer Twitter/X
- Agency designer side projects

**Portfolio red flags:**
- All logos look the same
- Only personal projects, no client work
- Heavy effects (shadows, gradients, 3D)
- No process shots or case studies

**Portfolio green flags:**
- Diverse styles adapted to different brands
- Simple, clean execution
- Shows work in context (mockups, applications)
- Explains thinking behind decisions

---

## The Hiring Conversation

**What to share upfront:**
- Budget range (saves everyone's time)
- Timeline and deadlines
- Company/product one-liner
- Examples of logos you like
- Where logo will primarily appear

**Questions to ask:**
1. What's your typical process?
2. How many concepts in first round?
3. What's included in revisions?
4. What file formats do you deliver?
5. Who owns the final work? (should be you)
6. What happens if we're not aligned after round 1?

**Red flag responses:**
- Won't share process details
- Unlimited revisions (means no structure)
- Pushback on ownership transfer
- Can't explain their pricing

---

## Contracts and Rights

**Must-have contract terms:**
- Full ownership transfer upon final payment
- Work-for-hire language (you own everything)
- Kill fee structure (if project ends early)
- Revision limits and additional revision costs
- Timeline with milestones
- Confidentiality

**Ownership types:**
- **Exclusive rights (what you want):** You own it, designer can't reuse
- **Non-exclusive:** Designer can resell (avoid for logos)
- **Licensed:** You can use but don't own (avoid for logos)

---

## Working with Designers

**Giving good feedback:**
- Specific: "The typography feels too playful for our B2B audience"
- Not vague: "Make it pop" / "I'll know it when I see it"
- Reference examples when possible
- Separate subjective preference from strategic concern

**Bad feedback patterns:**
- "I don't like it" without explanation
- Design by committee (10 stakeholders with opinions)
- Contradicting previous feedback
- Requesting competitor copies

**Iteration approach:**
- Round 1: Direction selection (which concept to develop)
- Round 2: Refinement (within chosen direction)
- Round 3: Polish (minor adjustments only)
- More than 3 rounds = problem with brief or alignment

---

## Budget Reality Check

**What different budgets get:**

| Budget | Expectation |
|--------|-------------|
| $100-300 | Basic logo, limited revisions, possibly templated |
| $500-1000 | Decent custom logo, proper files, some process |
| $1000-3000 | Full process, multiple concepts, brand guidelines |
| $3000-10000 | Complete brand identity, collateral, strategy |
| $10000+ | Agency-level brand strategy and system |

**The hidden cost of cheap logos:**
- Unlimited cheap revisions waste time
- Poor files mean paying again for proper versions
- Generic work needs replacement sooner
- Professional contacts may judge quality

---

## After Handoff

**Verify delivery includes:**
- [ ] All vector formats (SVG, PDF, EPS, AI)
- [ ] PNG versions in multiple sizes
- [ ] Color versions (full, black, white, grayscale)
- [ ] All lockup variations
- [ ] Favicon set
- [ ] Color specifications
- [ ] Basic usage guidelines
- [ ] Source/editable files

**If something's missing:** Ask immediately. Harder to get files months later.
