# Feedback Loop

## What to Track

### Successful Patterns
- Logo directions that clients loved instantly
- Fonts that consistently work well
- Color combinations that feel right
- Briefing questions that revealed key insights
- Tools that saved time

### Failed Patterns
- Concepts that missed the mark
- Feedback loops that went too long
- Miscommunication points in process
- Deliverables that needed rework

---

## Questions to Answer After Each Project

1. What made the final direction work?
2. Where did the process slow down?
3. What would you do differently?
4. What client feedback was most useful?
5. What tools helped/hindered?

---

## Patterns Worth Recording

### Client Types
- Startup founders: want modern, care about tech perception
- Small business: want trustworthy, care about local credibility  
- Enterprise: want safe, care about stakeholder approval
- Creative industry: want distinctive, care about peer perception

### Effective Shortcuts
- Starting with wordmark-only saves time for 60% of projects
- Showing context mockups prevents revision loops
- Getting one decision maker avoids committee problems
- Black/white first reduces color debates

### Time Sinks to Avoid
- Presenting more than 5 initial concepts
- Taking feedback from more than 2 people
- Color selection before direction is locked
- Discussing fonts before overall shape is agreed
