---
name: lofy-career
description: Job search automation for the Lofy AI assistant — application tracking, resume tailoring to job descriptions, interview prep with company research, follow-up management with draft emails, and pipeline analytics. Use when tracking job applications, tailoring resumes, preparing for interviews, managing follow-ups, or analyzing job search strategy.
---

# Career Manager — Job Pipeline

Automates job search: finds roles, tracks applications, tailors resumes, preps for interviews, and manages follow-ups.

## Data File: `data/applications.json`

```json
{
  "applications": [
    {
      "id": "app_001",
      "company": "Example Corp",
      "role": "Software Engineer",
      "url": "",
      "status": "applied",
      "applied_date": "2026-02-01",
      "source": "linkedin",
      "contact": null,
      "notes": "",
      "follow_up_date": "2026-02-08",
      "interviews": [],
      "outcome": null
    }
  ],
  "stats": { "total_applied": 0, "responses": 0, "interviews": 0, "offers": 0, "response_rate": 0 },
  "saved_roles": []
}
```

## Resume Tailoring

When user shares a job description:
1. Parse key requirements (must-have vs nice-to-have)
2. Map each requirement to user's experience (read `profile/career.md`)
3. Suggest bullet point rewrites emphasizing relevant experience
4. Flag gaps and suggest how to address in cover letter
5. Rate overall match: "You match X/Y requirements strongly, Z partially, N gaps"

## Interview Prep

When interview is scheduled:
1. Web search: recent company news, product launches, tech blog
2. Research interviewer if name provided
3. Generate likely questions (technical, behavioral STAR format, system design)
4. Prepare talking points per project
5. Suggest questions user should ask
6. Send prep package 24h before

## Follow-Up Management

- 5 business days after apply, no response → draft follow-up email
- After phone screen → draft thank-you within 24h
- After technical → detailed thank-you referencing discussion
- After onsite → personalized thank-you per interviewer
- Track ghosting patterns

## Application Updates via Natural Language

- "heard back from [company]" → prompt for details, update status
- "got rejected from [company]" → update to rejected, log reason
- "have a phone screen with [company] next Tuesday" → update status, schedule prep
- "got an offer!" → celebrate, then help evaluate

## Instructions

1. Always check `data/applications.json` before suggesting roles (avoid duplicates)
2. Update JSON immediately after any career conversation
3. Be strategic — quality > quantity
4. Help spot patterns: what types of roles respond? What keywords work?
5. If <10% response rate after 20 apps, reassess approach
6. For interviews, always research first — never send generic prep
