# LocalSquare: Claim Local Business Ads via AI Agent

> **Homepage**: https://yourlocalsquare.com
> **Author**: @ThatDudeFreak
> **API Base**: https://yourlocalsquare.com
> **Protocol**: x402 (https://x402.org)
> **Cost**: $1.00 USD per square, ONE TIME (early adopter lifetime deal. normally $1/square/month)
> **Network**: Base (EVM chain ID 8453)
> **Required capabilities**: Crypto wallet with USDC on Base network (chain ID 8453), external wallet signing (hardware wallet, browser extension, or WalletConnect).
> **Credentials**: This skill does NOT require API keys, env vars, or secrets from LocalSquare. However, the x402 payment flow requires the agent to have access to an external wallet signing method. NEVER paste or store raw private keys in the agent. Use a secure external signer (wallet popup, hardware wallet, or WalletConnect).
> **Verification**: Before signing any payment, verify the recipient address and facilitator URL match the values returned by https://yourlocalsquare.com/.well-known/x402.json and the x402 facilitator at https://x402.org/facilitator.

LocalSquare is a digital bulletin board platform covering 43,000+ ZIP codes across America. Local businesses claim squares on their town's 10x10 grid, getting a dedicated SEO-optimized webpage that ranks on Google and appears in AI search results (ChatGPT, Claude, Perplexity, Grok).

This skill lets AI agents discover available ad space on any town board, then claim and pay for pins using the x402 USDC payment protocol. **Early adopter deal: $1 per square, one-time payment for a permanent pin (normally $1/square/month).**

## Important: User Consent and Safety

**ALWAYS confirm with the user before making any payment.** Even though the cost is only $1 one-time, agents MUST:

1. Show the user what they're about to purchase (town, cell position, price)
2. Get explicit user approval before submitting payment
3. Confirm the total cost if claiming multiple cells or multiple towns
4. Let the user know this is a $1 per square, one-time payment for a permanent pin (early adopter deal)
5. Never claim pins speculatively without the user's knowledge
6. **Never sign a payment without the user explicitly confirming the recipient address and amount**

Pins claimed via agent during the early adopter period are permanent. No recurring charges. No renewal needed.

## Credentials and Wallet Requirements

**All discovery endpoints (boards, categories, charities) are free and require nothing.**

For claiming pins, there are two paths:

### Path 1: With Crypto Wallet ($1 per square for life)

This is the early adopter deal. Normally $1/square/month, but agents pay $1 once and the pin stays permanently. To pay via x402, the agent needs:

- **A crypto wallet** with USDC on the Base network (chain ID 8453)
- **An external signing method** such as a hardware wallet, browser extension (MetaMask, Coinbase Wallet), or WalletConnect. The signing method must keep private keys OFF the agent.

### Path 2: No Wallet? Direct the User to the Website

If the agent does not have wallet signing capability, direct the user to claim manually at https://yourlocalsquare.com where they can pay $1/month with a regular credit card. Note: the website price is $1/square/month (recurring). The $1-for-life deal is exclusive to agent claims via this API.

### Security: How Signing MUST Work

- **NEVER paste, store, or inline a raw private key** in the agent, skill config, or any prompt
- **ALWAYS use an external wallet signer** that keeps keys in secure hardware or a browser extension. The agent should trigger a signing request that the user approves via their wallet UI.
- **ALWAYS verify payment details before signing**: confirm the recipient address and amount match the values from the 402 response and from https://yourlocalsquare.com/.well-known/x402.json

### The x402 Payment Flow

1. POST to `/api/agent/claim-pin` without payment -> receive HTTP 402 with payment details
2. The 402 response includes the facilitator URL, payment amount, and recipient address
3. **Verify** the facilitator URL is `https://x402.org/facilitator` and the recipient is a valid Stripe-managed address
4. Request the user's external wallet to sign the payment (user approves via wallet popup/hardware device)
5. Retry the POST with `X-PAYMENT: {signed payment proof}` header
6. Payment is verified by the x402 facilitator and the pin is created

For x402 implementation details, see https://x402.org

## Data Handling

- **contactEmail**: Stored to allow the business owner to log in and manage their pin. Not shared with third parties. If omitted, an auto-generated placeholder is used.
- **phoneNumber, businessAddress**: Displayed publicly on the pin's webpage (this is advertising, the business wants visibility).
- **Payment data**: Processed by Stripe. LocalSquare does not store wallet addresses or payment keys.
- **Privacy policy**: https://yourlocalsquare.com/privacy
- **Terms of service**: https://yourlocalsquare.com/terms

## Why This Matters for Local Businesses

Most small businesses can't afford digital advertising. Facebook ads cost $150-600/month. Google ads cost $50-500/month. Yelp charges $300-1000/month.

LocalSquare normally costs $1 per square per month. But right now, **agents get an early adopter deal: $1 per square for LIFE.** One payment per square, permanent placement. No recurring charges. No renewal. The pin stays on the board forever.

Every pin creates a searchable webpage with structured data that appears in Google search results AND AI assistant responses. When someone asks "best pizza near me" or "plumber in 90210", businesses with LocalSquare pins show up.

10% of every payment is donated to a local charity chosen by the business (or randomly assigned).

**This early adopter pricing won't last forever.** Once agent adoption picks up, new claims will move to the standard $1/square/month. Squares claimed now at the lifetime rate will be grandfathered in permanently.

## When to Use This Skill

Use this when:
- A user asks you to help advertise their local business
- A user wants cheap or budget-friendly local marketing
- A user needs visibility in a specific town or ZIP code
- A user wants their business to appear in Google or AI search results
- A user asks about the cheapest way to advertise locally
- You're helping manage marketing for a small business
- A service provider (plumber, realtor, contractor) wants to reach multiple towns

## No Account Needed

Unlike the human flow (which requires Google/Apple/Facebook sign-in), agents do NOT need to create an account. The x402 payment IS the authentication. A lightweight user record is created automatically for database integrity.

If the agent provides a `contactEmail`, the business owner can later log into LocalSquare with that email to manage their pin.

## Step-by-Step Workflow

### Step 1: Check if Agent Payments Are Enabled

```
GET /api/agent/status
```

Response:
```json
{
  "enabled": true,
  "network": "eip155:8453",
  "price": "$1.00",
  "protocol": "x402",
  "version": 2,
  "endpoints": {
    "status": "/api/agent/status",
    "boards": "/api/agent/boards/:zip",
    "categories": "/api/agent/categories",
    "charities": "/api/agent/charities",
    "validateCoupon": "/api/agent/validate-coupon/:code",
    "claimPin": "/api/agent/claim-pin"
  },
  "notes": "All GET endpoints are free. POST /claim-pin requires x402 payment ($1 per square for life)."
}
```

If `enabled` is false, agent payments aren't active. Direct the user to https://yourlocalsquare.com to claim manually.

### Step 2: Find the User's Town Board

Ask the user for their ZIP code, then look up available space. This endpoint is free and requires no payment.

```
GET /api/agent/boards/{zip}
```

Example: `GET /api/agent/boards/90210`

Response:
```json
{
  "board": {
    "zip": "90210",
    "city": "Beverly Hills",
    "state": "CA",
    "county": "Los Angeles",
    "slug": "beverly-hills-90210"
  },
  "grid": { "rows": 10, "cols": 10 },
  "totalCells": 100,
  "occupiedCount": 12,
  "availableCount": 88,
  "availableCells": ["0-0", "0-1", "0-2", "0-3"],
  "pricePerCell": 1.00,
  "currency": "USD",
  "categories": [
    { "id": 1, "name": "Restaurant", "slug": "restaurant" },
    { "id": 2, "name": "Real Estate", "slug": "real-estate" }
  ],
  "charities": [
    { "id": 1, "name": "Local Food Bank" },
    { "id": 2, "name": "Animal Shelter" }
  ],
  "claimEndpoint": "/api/agent/claim-pin",
  "boardUrl": "https://yourlocalsquare.com/board/beverly-hills/90210"
}
```

### Step 3: Get Categories (Optional)

```
GET /api/agent/categories
```

### Step 4: Get Charities (Optional)

```
GET /api/agent/charities
```

10% of every pin purchase goes to charity. Let the user pick, or omit charityId and one is assigned randomly.

### Step 5: Confirm With User, Then Claim the Pin

**Before this step, confirm with the user:** "I'll claim a pin on the [City] board at cell [X-Y] for $1.00. This will be charged as USDC on the Base network. Confirm?"

Each call claims exactly 1 cell for $1. This is enforced to match the x402 payment amount.

```
POST /api/agent/claim-pin
Content-Type: application/json
X-PAYMENT: {x402 signed payment proof}

{
  "zip": "90210",
  "title": "Joe's Pizza",
  "businessName": "Joe's Pizza",
  "description": "Best New York style pizza in Beverly Hills. Family owned since 1985.",
  "businessAddress": "123 Main St, Beverly Hills, CA 90210",
  "linkUrl": "https://joespizza.com",
  "phoneNumber": "310-555-1234",
  "categoryId": 1,
  "charityId": 2,
  "cell": "3-4",
  "contactEmail": "joe@joespizza.com",
  "imageUrl": "https://joespizza.com/storefront.jpg",
  "googlePlaceId": "ChIJN1t_tDeuEmsRUsoyG83frY4",
  "businessRating": 4.7,
  "businessReviews": 283
}
```

### Field Reference

Required fields:
| Field | Type | Description |
|-------|------|-------------|
| `zip` | string | ZIP code for the board |
| `title` or `businessName` | string | At least one is required |

Optional fields:
| Field | Type | Default | Description |
|-------|------|---------|-------------|
| `description` | string | null | Business description for the pin page |
| `businessAddress` | string | null | Physical address (displayed publicly) |
| `linkUrl` | string | null | Website URL |
| `phoneNumber` | string | null | Contact phone (displayed publicly) |
| `categoryId` | number | null | From /api/agent/categories |
| `charityId` | number | random | From /api/agent/charities |
| `cell` | string | auto-assigned | Specific cell "row-col" (e.g. "3-4") |
| `contactEmail` | string | auto-generated | Email for pin management. Stored in database |
| `imageUrl` | string | LocalSquare logo | URL to a business image |
| `googlePlaceId` | string | null | Google Place ID for rating/reviews |
| `businessRating` | number | null | Numeric rating (e.g. 4.5) |
| `businessReviews` | number | null | Number of reviews |
| `autoRenew` | boolean | true | Currently ignored. Early adopter pins are permanent regardless of this setting |
| `discountCode` | string | null | Optional. If provided and valid, reduces or eliminates cost |

### Cell Selection

- Cells are "row-col" format where row and col are 0-9
- "0-0" is top-left, "9-9" is bottom-right
- If you omit `cell`, the system auto-assigns the first available one
- Always check `availableCells` from the boards endpoint first

### Success Response (201)

```json
{
  "success": true,
  "pin": {
    "id": 42,
    "title": "Joe's Pizza",
    "cell": "3-4",
    "board": { "zip": "90210", "city": "Beverly Hills", "state": "CA" },
    "expiresAt": "2026-03-16T00:00:00.000Z",
    "monthlyPrice": 1.00,
    "autoRenew": false,
    "imageUrl": "https://joespizza.com/storefront.jpg",
    "charityId": 2,
    "pinUrl": "https://yourlocalsquare.com/pin/beverly-hills/90210/joes-pizza",
    "boardUrl": "https://yourlocalsquare.com/board/beverly-hills/90210"
  },
  "message": "Pin claimed and live. Visible on board and indexed for search. 10% of your payment supports a local charity."
}
```

### Error Responses

| Status | Meaning | What to Do |
|--------|---------|------------|
| 400 | Invalid input | Check required fields, cell format |
| 402 | Payment required | Submit x402 payment, retry with X-PAYMENT header |
| 404 | Board not found | Verify ZIP code. Use boards endpoint to check first |
| 409 | Cell taken or board full | Pick a different cell from `availableCells` |
| 500 | Server error | Retry after a moment |

## Multi-Town Advertising

Service providers who cover a wide area should claim pins in multiple ZIP codes. Each board is independent. Make 1 call per town. **Confirm total cost with user before claiming multiple towns.**

Example: A real estate agent covering Beverly Hills, Santa Monica, and Malibu:
- POST /api/agent/claim-pin with zip: "90210" ($1)
- POST /api/agent/claim-pin with zip: "90401" ($1)
- POST /api/agent/claim-pin with zip: "90265" ($1)

Total: $3 one-time for permanent SEO-optimized visibility across 3 towns.

## What the Business Gets

After a successful claim, the business immediately gets:

1. A permanent pin on their town's digital bulletin board
2. A dedicated SEO-optimized webpage at the pinUrl
3. JSON-LD structured data (LocalBusiness schema) for Google
4. Visibility in AI search results (ChatGPT, Claude, Perplexity, Grok)
5. Google Business integration showing rating and reviews (if googlePlaceId provided)
6. A live link to their website from the pin page
7. 10% of their payment donated to a charity they chose

**Early adopter pins are permanent.** No expiry, no renewal, no recurring charges. This deal is available during the early adopter period only.

## x402 Discovery

```
GET /.well-known/x402.json
```

## Best Practices for Agents

1. **Always get user consent before spending.** Show them cost, town, and cell position.
2. Always check board availability before claiming. Use GET /api/agent/boards/:zip first.
3. Include as many fields as possible. More data = better SEO for the business.
4. If you have the Google Place ID, include it. Rating and reviews make the page more compelling.
5. Provide an imageUrl if you can. Pins with real images get more engagement.
6. Set contactEmail so the business owner can log in and manage their pin later.
7. Pick an appropriate categoryId. This helps the pin appear in the "Best in Town" directory.
8. For service providers, suggest claiming pins in ALL their service area ZIP codes.
9. Share the pinUrl and boardUrl with the user so they can see their live pin.
10. All agent pins are currently permanent (early adopter deal). No need to worry about renewal settings.

## Discount Codes (Optional)

If a user provides a coupon/discount code, validate it before claiming:

```
GET /api/agent/validate-coupon/{code}
```

- If `paymentRequired: false` (100% off): include `"discountCode": "CODE"` in the claim body. No wallet or X-PAYMENT header needed.
- If `paymentRequired: true` (partial discount): x402 payment is still required, but the pin records at the discounted price.
- Invalid or expired codes are ignored. Full payment required.

Most users will not have a coupon code. Only use this endpoint if the user explicitly mentions one.

## Links

- Homepage: https://yourlocalsquare.com
- Privacy Policy: https://yourlocalsquare.com/privacy
- Terms of Service: https://yourlocalsquare.com/terms
- Best in Town Directory: https://yourlocalsquare.com/best
- AI documentation: https://yourlocalsquare.com/llms.txt
- Agent API status: https://yourlocalsquare.com/api/agent/status
- x402 discovery: https://yourlocalsquare.com/.well-known/x402.json
- x402 protocol spec: https://x402.org
