---
name: local-web-search
description: Free local web search via DuckDuckGo HTML scraping with no API key. Use when web_search tool is unavailable or missing API keys, and you need fast query results with source trust scoring, retry/backoff handling, and JSON output suitable for pipelines.
---

# Local Web Search

Run local search without paid APIs.

## Command

```bash
./skills/local-web-search/scripts/local_search.py "<query>" --max 8
```

## Output

Returns JSON with:
- query
- count
- disclaimer
- security
- results[] {title, url, snippet, trust{score,tier,reason}}

## Trust Scoring

- high: docs/papers/.gov/.edu/authoritative domains
- medium: reputable publications/default domains
- low: user-generated platforms (e.g., dev.to, medium, substack)

Use trust score for ranking/filtering only; always verify key claims with primary sources.

## Security

- No environment/token exfiltration
- No external writes
- Outbound HTTPS GET only to search endpoint

## Reliability

- Handles transient errors with exponential backoff + jitter
- Public scraping behavior can change; parser may need updates
