# Prompt Templates for Local Falcon Analysis

Copy and customize these prompts to get expert-level local SEO and AI visibility analysis.

---

## AI Visibility Prompts

### AI Visibility Assessment
```
Assess my business's AI visibility across ChatGPT, Google AI Mode, Gemini, and Grok.

Business: [BUSINESS NAME]
Location: [CITY, STATE]
Primary Services: [SERVICES]

I want to understand:
1. Current SAIV (Share of AI Visibility) estimate
2. Which authoritative sources AI platforms cite for my industry
3. Gaps in my online presence that limit AI mentions
4. Content and citation strategy to improve AI visibility
5. How to measure progress over time
```

### Platform-Specific Optimization
```
Help me optimize specifically for [PLATFORM: ChatGPT / AI Mode / Gemini / Grok].

My business: [BUSINESS NAME]
Industry: [INDUSTRY]
Current online presence: [LIST KEY PROFILES - Yelp, Foursquare, etc.]

What specific actions should I take to increase my visibility on this platform?
Focus on the unique data sources and ranking factors for this specific AI.
```

### AI vs Maps Strategy
```
My business has strong Google Maps visibility (SoLV: [X]%) but weak AI visibility (SAIV: [X]%).

Business: [BUSINESS NAME]
Industry: [INDUSTRY]

Help me understand:
1. Why these metrics might diverge
2. What AI platforms look for that Maps doesn't
3. Priority actions to improve AI visibility without hurting Maps performance
4. Which platforms to prioritize based on my industry
```

---

## Local SEO Audit Prompts

### Comprehensive Local Audit
```
Analyze my local SEO presence for [BUSINESS NAME] at [ADDRESS].

I need:
1. Current visibility assessment across my service area
2. Competitive landscape analysis - who's dominating the local pack?
3. GBP optimization opportunities
4. Review strategy recommendations
5. Priority actions ranked by expected impact

My primary keyword is [KEYWORD] and I serve [SERVICE AREA DESCRIPTION].
```

### GBP Health Check
```
Audit my Google Business Profile for optimization opportunities.

Business: [BUSINESS NAME]
GBP URL or Place ID: [LINK OR ID]
Primary Category: [CATEGORY]
Service Area: [AREA]

Check for:
1. Category optimization (primary and secondary)
2. Attribute completeness
3. Photo optimization
4. Post strategy opportunities
5. Q&A management
6. Any red flags or compliance issues
```

### Service Area Business Analysis
```
I'm a Service Area Business (SAB) - [BUSINESS TYPE].

I operate from [OFFICE ADDRESS] but serve customers in [SERVICE AREA].

Questions:
1. Where should I center my Local Falcon scans?
2. How should I think about "proximity" differently than storefronts?
3. What's the optimal scan configuration for my coverage area?
4. How do I interpret results when I'm strong far from my office but weak nearby?
```

---

## Competitive Analysis Prompts

### Direct Competitor Comparison
```
Compare my local rankings against [COMPETITOR NAME].

My business: [YOUR BUSINESS NAME]
Competitor: [COMPETITOR NAME]
Target keyword: [KEYWORD]
Location: [CITY/AREA]

Analyze:
1. SoLV comparison - who dominates the local pack?
2. Review profile comparison (count, rating, velocity, freshness)
3. GBP optimization gaps
4. Geographic areas where I win vs. lose
5. Specific actions to close the largest gaps
```

### Market Landscape Analysis
```
Analyze the competitive landscape for [KEYWORD] in [CITY/AREA].

I want to understand:
1. How many competitors have meaningful SoLV?
2. What's the Max SoLV in this market (ceiling potential)?
3. Are there geographic opportunity corridors with weak competition?
4. What do top performers have in common?
5. What's a realistic SoLV target for my business?
```

### Competitor Intelligence
```
What can I learn from my top-ranking competitor?

Competitor: [COMPETITOR NAME]
They rank #1 for: [KEYWORD]
In: [AREA]

Analyze:
1. What are they doing right (GBP, reviews, citations)?
2. What weaknesses can I exploit?
3. What would it take to overtake them?
4. How long might it realistically take?
```

---

## Trend Analysis Prompts

### Performance Trend Review
```
Analyze my Local Falcon trend data for [KEYWORD] over the past [TIME PERIOD].

I want to understand:
1. Is my visibility improving, declining, or stable?
2. What events or changes correlate with ranking shifts?
3. How does my trajectory compare to market leaders?
4. Seasonal patterns I should plan for
5. Leading indicators that predict future performance
```

### Ranking Drop Diagnosis
```
My rankings dropped significantly in the last [TIME PERIOD].

Before: SoLV [X]%, ATRP [Y]
After: SoLV [X]%, ATRP [Y]

Help me diagnose:
1. What are the most likely causes?
2. What should I check first (GBP, reviews, competition)?
3. Was this a market-wide shift or specific to my business?
4. What recovery actions should I prioritize?
5. How long might recovery take?
```

---

## Review Strategy Prompts

### Review Generation Strategy
```
Create a review generation strategy for [BUSINESS NAME].

Current state:
- Total reviews: [NUMBER]
- Average rating: [RATING]
- Review velocity (last 90 days): [REVIEWS/MONTH]

I need:
1. Benchmark comparison to top local competitors
2. Target review velocity to reach competitive parity
3. Tactics to increase review volume ethically
4. Review response strategy for positive/negative/fake reviews
5. How to encourage photo reviews for maximum impact
```

### Review Analysis
```
Analyze my review profile compared to competitors.

My reviews: [COUNT] at [RATING] stars
Competitor A: [COUNT] at [RATING] stars
Competitor B: [COUNT] at [RATING] stars

Questions:
1. Am I competitive on review count and rating?
2. What themes appear in my negative reviews that I should address?
3. What keywords in competitor reviews might explain their rankings?
4. What's my review freshness situation?
5. Review response strategy recommendations?
```

---

## Scan Configuration Prompts

### Optimal Scan Setup
```
What's the optimal scan configuration for my business?

Business type: [STOREFRONT_SINGLE / STOREFRONT_MULTI / SERVICE_AREA_BUSINESS]
Industry: [INDUSTRY]
Location density: [URBAN / SUBURBAN / RURAL]
Primary service radius: [MILES]

I need recommendations for:
1. Optimal grid size (3x3 to 21x21)
2. Recommended radius
3. Scan frequency for tracking
4. Credit-efficient configuration
5. Keywords to prioritize
```

### Multi-Location Scan Strategy
```
I manage [NUMBER] locations for [BRAND NAME].

Location distribution: [DESCRIBE - clustered, spread out, different markets]
Primary keywords: [LIST 3-5 KEYWORDS]
Budget constraint: [CREDITS PER MONTH or UNLIMITED]

Help me design:
1. Scan configuration for each location type
2. Campaign structure (grouped by region? keyword? both?)
3. Frequency recommendations
4. How to identify underperformers quickly
5. Reporting roll-up strategy
```

---

## Multi-Location / Franchise Prompts

### Portfolio Analysis
```
Analyze my multi-location performance across [NUMBER] locations.

Brand: [BRAND NAME]
Location types: [e.g., "mix of urban and suburban"]
Primary keyword: [KEYWORD]

I need:
1. Top 5 performing locations and why they succeed
2. Bottom 5 underperformers and common issues
3. Are there systemic problems across all locations?
4. Location-specific vs. brand-wide recommendations
5. Resource allocation priorities
```

### Franchise Consistency Check
```
I'm the franchisor for [BRAND] with [NUMBER] franchise locations.

Concerns:
1. How consistent is GBP optimization across locations?
2. Are franchisees maintaining brand standards?
3. Which locations are hurting the brand?
4. What central resources/training would help most?
5. How do I benchmark franchise performance fairly?
```

---

## Report Interpretation Prompts

### Scan Report Analysis
```
Help me interpret this Local Falcon scan report:

Location: [BUSINESS NAME]
Keyword: [KEYWORD]
Grid: [SIZE] at [RADIUS]
Platform: [GOOGLE MAPS / APPLE / AI PLATFORM]

Results:
- ATRP: [VALUE]
- ARP: [VALUE]
- SoLV: [VALUE]%
- Found In: [VALUE] of [TOTAL] points

What does this tell me and what should I do?
```

### Contradictory Metrics
```
My scan shows contradictory metrics:

- ARP: [GOOD VALUE like 4.2]
- SoLV: [LOW VALUE like 8%]

Or alternatively:
- ATRP: [POOR VALUE like 12]
- Found In: [HIGH VALUE like 45/49]

Help me understand what this pattern means and what it tells me about my optimization priorities.
```

---

## Quick Reference Prompts

### Metric Definition
```
Explain [METRIC NAME: SoLV / SAIV / ATRP / ARP / RVS / RQS] in simple terms.

What does it measure, when should I care about it, and what's a good benchmark?
```

### Platform Comparison
```
How do [PLATFORM A] and [PLATFORM B] differ for local business visibility?

Specifically:
1. What data sources does each use?
2. How do they display local results differently?
3. Should I optimize differently for each?
4. Which matters more for my industry: [INDUSTRY]?
```

### Quick Diagnosis
```
Quick diagnosis: My [METRIC] is [VALUE]. Is this good or bad for [INDUSTRY] in [CITY SIZE] market?

What's the most likely cause if it's underperforming?
```

---

## Tips for Better Prompts

### Include Context
- Business type (storefront, SAB, multi-location)
- Industry/category
- Market (city, urban/suburban/rural)
- Current metrics if available

### Be Specific About Goals
- "Improve rankings" is vague
- "Increase SoLV from 15% to 30% within 90 days" is actionable

### Ask for Priorities
- Always ask for prioritized recommendations
- Request "impact vs. effort" assessment
- Ask for timeline expectations

### Request Validation
- Ask what metrics to track
- Ask when to re-scan
- Ask what success looks like

---

*For live data analysis using these prompts, connect the Local Falcon MCP server or use Falcon Agent.*
