# Loading State Patterns

Patterns for skeleton loaders, shimmer effects, and loading states that match design system aesthetics. Build loading experiences that feel intentional and polished.

## What's Inside

- Skeleton base component with shimmer animation
- Content skeleton layouts (card, table row, metric)
- Design-system-matched skeletons (e.g., cyber/retro-futuristic theme)
- Progressive loading with fade-in transitions
- Streaming content indicator (AI/LLM dot animation)
- Loading progress bar (determinate and indeterminate)
- Skeleton grid layout component

## When to Use

- Building skeleton loaders for content areas
- Need shimmer effects for streaming content
- Want progressive loading experiences
- Building premium loading UX

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/design-systems/loading-state-patterns
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/design-systems/loading-state-patterns .cursor/skills/loading-state-patterns
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/design-systems/loading-state-patterns ~/.cursor/skills/loading-state-patterns
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/design-systems/loading-state-patterns .claude/skills/loading-state-patterns
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/design-systems/loading-state-patterns ~/.claude/skills/loading-state-patterns
```

## Related Skills

- [distinctive-design-systems](../distinctive-design-systems/) — Aesthetic matching for themed skeletons
- [design-system-creation](../../meta/design-system-creation/) — Complete design system workflow

---

Part of the [Design Systems](..) skill category.
