import { SkillContext } from "@openclaw/sdk";

import { onLLMError } from "./hooks/onLLMError";
import { onAgentStart } from "./hooks/onAgentStart";
import { beforeTaskExecute } from "./hooks/beforeTaskExecute";
import { llmCommand } from "./commands/llm";

export default function register(ctx: SkillContext) {
  // Hooks
  ctx.hooks.onLLMError(onLLMError);
  ctx.hooks.onAgentStart(onAgentStart);
  ctx.hooks.beforeTaskExecute(beforeTaskExecute);

  // Commands
  ctx.commands.register("llm", llmCommand);

  ctx.log.info("[llm-supervisor] Skill loaded");
}

