import { SkillContext, LLMErrorEvent } from "@openclaw/sdk";
import { getState, setState } from "../state";

export async function onLLMError(
  ctx: SkillContext,
  event: LLMErrorEvent
) {
  const cfg = ctx.config;
  const state = getState(ctx);

  // Only react if we're currently on cloud
  if (state.mode !== "cloud") return;

  // Detect rate limit / quota style errors
  const msg = (event.error?.message || "").toLowerCase();
  const isRateLimit =
    msg.includes("rate limit") ||
    msg.includes("quota") ||
    msg.includes("429");

  if (!isRateLimit) return;

  ctx.log.warn("[llm-supervisor] Cloud LLM rate limit detected");

  // Switch to local
  setState(ctx, {
    mode: "local",
    since: Date.now(),
    lastError: event.error?.message
  });

  // Notify users
  await ctx.notify.all(
    `⚠️ Cloud LLM rate limit detected.\n` +
    `Switched main agent to **local model (${cfg.localModel})**.\n` +
    `Chat is unaffected. Code actions will require confirmation.`
  );

  ctx.log.info("[llm-supervisor] Switched to local LLM");
}

