import { SkillContext, CommandContext } from "@openclaw/sdk";
import { getState, setState } from "../state";

export async function llmCommand(
  ctx: SkillContext,
  cmd: CommandContext
) {
  const args = cmd.args || [];
  const sub = args[0];

  const state = getState(ctx);

  // /llm status
  if (!sub || sub === "status") {
    await cmd.reply(
      `🧠 **LLM Status**\n\n` +
      `Mode: **${state.mode.toUpperCase()}**\n` +
      `Since: ${new Date(state.since).toLocaleString()}\n` +
      (state.lastError
        ? `Last error: ${state.lastError}\n`
        : "")
    );
    return;
  }

  // /llm switch local
  if (sub === "switch" && args[1] === "local") {
    if (state.mode === "local") {
      await cmd.reply("Already running in **local** mode.");
      return;
    }

    setState(ctx, {
      mode: "local",
      since: Date.now()
    });

    await ctx.notify.all(
      `⚠️ LLM manually switched to **local model (${ctx.config.localModel})**.\n` +
      `Code actions will require confirmation.`
    );

    await cmd.reply("Switched to **local** LLM mode.");
    return;
  }

  // /llm switch cloud
  if (sub === "switch" && args[1] === "cloud") {
    if (state.mode === "cloud") {
      await cmd.reply("Already running in **cloud** mode.");
      return;
    }

    setState(ctx, {
      mode: "cloud",
      since: Date.now()
    });

    await ctx.notify.all("✅ Switched back to **cloud LLM**.");

    await cmd.reply("Switched to **cloud** LLM mode.");
    return;
  }

  await cmd.reply(
    "Unknown command.\n\n" +
    "Usage:\n" +
    "- `/llm status`\n" +
    "- `/llm switch local`\n" +
    "- `/llm switch cloud`"
  );
}

