declare module "@openclaw/sdk" {
  /* ======================
     Core Skill Context
     ====================== */

  export interface SkillContext {
    log: {
      info(message: string): void;
      warn(message: string): void;
      error(message: string): void;
    };

    config: any;

    state: {
      get<T>(key: string): T | undefined;
      set<T>(key: string, value: T): void;
    };

    notify: {
      all(message: string): Promise<void>;
    };

    hooks: {
      onLLMError(
        handler: (ctx: SkillContext, event: LLMErrorEvent) => Promise<void> | void
      ): void;

      onAgentStart(
        handler: (ctx: SkillContext, event: AgentStartEvent) => Promise<void> | void
      ): void;

      beforeTaskExecute(
        handler: (ctx: SkillContext, event: BeforeTaskExecuteEvent) => Promise<void> | void
      ): void;
    };

    commands: {
      register(
        name: string,
        handler: (ctx: SkillContext, cmd: CommandContext) => Promise<void> | void
      ): void;
    };
  }

  /* ======================
     Commands
     ====================== */

  export interface CommandContext {
    args?: string[];
    reply(message: string): Promise<void>;
  }

  /* ======================
     Agents
     ====================== */

  export interface Agent {
    setLLMProfile(profile: any): void;
  }

  export interface AgentStartEvent {
    agent: Agent;
  }

  /* ======================
     Tasks
     ====================== */

  export interface BeforeTaskExecuteEvent {
    task?: {
      kind?: string;
      intent?: string;
    };

    context?: {
      lastUserMessage?: string;
    };

    block(reason: string): Promise<void>;
  }

  /* ======================
     LLM Errors
     ====================== */

  export interface LLMErrorEvent {
    error?: {
      code?: string;
      message?: string;
    };
  }
}

