import { SkillContext } from "@openclaw/sdk";

export type LLMMode = "cloud" | "local";

export interface LLMState {
  mode: LLMMode;
  since: number;
  lastError?: string;
}

const DEFAULT_STATE: LLMState = {
  mode: "cloud",
  since: Date.now()
};

export function getState(ctx: SkillContext): LLMState {
  return ctx.state.get<LLMState>("llm-supervisor:state") ?? DEFAULT_STATE;
}

export function setState(ctx: SkillContext, state: LLMState) {
  ctx.state.set("llm-supervisor:state", state);
}

export function isCooldownOver(
  state: LLMState,
  cooldownMinutes: number
): boolean {
  const elapsedMs = Date.now() - state.since;
  return elapsedMs > cooldownMinutes * 60 * 1000;
}

