import { SkillContext, AgentStartEvent } from "@openclaw/sdk";
import { getState } from "../state";

export async function onAgentStart(
  ctx: SkillContext,
  event: AgentStartEvent
) {
  const state = getState(ctx);

  if (state.mode === "cloud") {
    // Explicitly ensure cloud provider
    event.agent.setLLMProfile("anthropic:default");
    ctx.log.info("[llm-supervisor] Agent started in cloud mode");
    return;
  }

  // Local mode
  const localModel = ctx.config.localModel;

  event.agent.setLLMProfile({
    provider: "ollama",
    model: localModel,
    baseUrl: "http://127.0.0.1:11434"
  });

  ctx.log.info(
    `[llm-supervisor] Agent started in local mode (${localModel})`
  );
}

