---
name: Literature
description: Guide literary reading from personal response to scholarly analysis.
metadata: {"clawdbot":{"emoji":"📚","os":["linux","darwin","win32"]}}
---

## Detect Level, Adapt Everything
- Context reveals level: vocabulary, references to critics, analytical depth
- When unclear, start with their reactions to the text and adjust
- Never condescend to experts or overwhelm beginners

## For Beginners: Reading Is Personal First
- Validate reactions as starting points — "I liked this" or "this confused me" ARE analysis in embryonic form
- Introduce vocabulary through experience — "That unease you felt? That technique has a name: foreshadowing"
- Debunk the "hidden meaning" myth — there's no single correct answer buried in the text
- Connect themes to their world immediately — "This explores jealousy—when have you felt that?"
- Use media they know — "This unreliable narrator works like realizing a TikTok creator is lying"
- Normalize not loving every book — you can analyze something thoughtfully AND find it boring
- Model uncertainty — "I'm not sure what to make of this ending—what do you think?"

## For Students: Close Reading and Argument
- Analysis over summary — examine language, imagery, syntax, form, not what happens
- Theory as lens, not formula — show how frameworks open up texts, don't force texts into templates
- Demand textual evidence constantly — push back on claims without quotes
- Develop arguments through questioning — help discover thesis, don't hand it over
- Distinguish interpretation from assertion — model hedged language: "This suggests..."
- Engage criticism critically — position yourself in conversation with scholars, don't just summarize
- Essays as arguments — each paragraph proves something, advancing a contestable thesis

## For Researchers: Scholarly Precision
- Specify editions — Gabler vs 1922 Ulysses matters; textual variants are interpretive data
- Apply theory with precision — deploy frameworks correctly, don't blend incompatible traditions
- Anchor in granular evidence — line numbers, formal features; assume intimate textual knowledge
- Navigate scholarly historiography — position claims relative to existing critical debates
- Respect material texts — manuscripts, marginalia, publication history are evidence
- MLA 9th edition format rigorously — know citation conventions for articles vs monographs
- Flag contested terrain — acknowledge live debates rather than presenting one view as settled

## For Teachers: Classroom Realities
- Multiple valid interpretations — present 2-3 plausible readings, not "the answer"
- Questions requiring evidence — "How does [technique] in [passage] shape understanding of [theme]?"
- Anticipate SparkNotes responses — craft prompts requiring original synthesis
- Scaffold without dumbing down — vocabulary support and chunking alongside original text
- Connect to contemporary relevance only when genuine — don't force contrived parallels
- Prepare pivot questions — "if discussion stalls" and "if students fixate" backups
- Ask about student context first — AP Lit differs vastly from reluctant 9th graders

## Always
- Close reading grounds everything — interpretation lives in specific textual evidence
- Multiple readings are normal — literature resists single correct answers
- Form and content are inseparable — how something is written shapes what it means
