---
name: listonic
version: 1.0.0
description: "Access Listonic shopping lists: list lists/items, add/check/delete items, and manage lists."
metadata: {"clawdbot":{"emoji":"🛒","requires":{"bins":["python3"]}}}
---

# Listonic

Manage Listonic shopping lists via the unofficial web API.

## Setup

Create `~/.openclaw/credentials/listonic/config.json` using **one** auth mode.

### Recommended: token mode (works with Google sign-in)

```json
{
  "refreshToken": "your-refresh-token"
}
```

Optional (advanced):

```json
{
  "accessToken": "short-lived-access-token",
  "clientId": "listonicv2",
  "clientSecret": "fjdfsoj9874jdfhjkh34jkhffdfff",
  "redirectUri": "https://listonicv2api.jestemkucharzem.pl"
}
```

### Fallback: email/password mode

```json
{
  "email": "you@example.com",
  "password": "your-listonic-password"
}
```

## Workflow

1. `lists` to show available shopping lists
2. `items <list>` to inspect current items
3. `add-item <list> "Name"` to add items
4. `check-item` / `uncheck-item` to toggle completion
5. `delete-item` only when user explicitly wants removal

## Important

- This uses an **unofficial reverse-engineered API** and may break if Listonic changes it.
- For destructive operations (`delete-item`, `delete-list`), **confirm with the user first**.
- `list` arguments can be list ID or a list name (exact/partial match).

## Commands

### Show all lists
```bash
bash scripts/listonic.sh lists
```

### Show items in a list
```bash
bash scripts/listonic.sh items 12345
bash scripts/listonic.sh items "Groceries"
```

### Add item
```bash
bash scripts/listonic.sh add-item "Groceries" "Milk"
bash scripts/listonic.sh add-item "Groceries" "Flour" --amount 2 --unit kg
```

### Check / uncheck item
```bash
bash scripts/listonic.sh check-item "Groceries" 987654
bash scripts/listonic.sh uncheck-item "Groceries" 987654
```

### Delete item
```bash
bash scripts/listonic.sh delete-item "Groceries" 987654
```

### Create / rename / delete list
```bash
bash scripts/listonic.sh add-list "BBQ Party"
bash scripts/listonic.sh rename-list "BBQ Party" "BBQ"
bash scripts/listonic.sh delete-list "BBQ"
```

### Raw JSON output
```bash
bash scripts/listonic.sh --json lists
bash scripts/listonic.sh --json items "Groceries"
```
