# Lisbon Visitor Tips & Day Trips

## Arrival Essentials

### Lisbon Airport (LIS)
- Single terminal, 7km from city center
- Clear signage, modern facilities
- Expect 20-40 min to baggage claim (long walks)

**Getting to center**:

| Method | Time | Cost | Best For |
|--------|------|------|----------|
| Metro (red line) | 25-35 min | €1.72 | Budget, central hotels |
| Aerobus (91) | 30-45 min | €4 | If near Rossio/Cais do Sodré |
| Taxi | 15-25 min | €15-20 | Fixed fare to center |
| Uber/Bolt | 15-25 min | €8-15 | Cheaper than taxi |

**Metro tip**: Buy a Navegante card (€0.50) at the airport station and load €5-10 Zapping credit. You'll use it all trip.

**Taxi warning**: Use the official taxi rank. Fixed fares to city center posted. Don't accept "offers" from people inside terminal.

### Porto to Lisbon
- **Train**: Alfa Pendular, 2h40, €35-45 (book at cp.pt)
- **Bus**: Rede Expressos, 3h30, €20
- Best: Book train in advance for good prices

### Spain Connections
- **Madrid**: Train 10h, Flight 1h, Bus 6h (bus often best value)
- **Seville**: Bus 4h, €20-35, Rede Expressos
- **Flight tip**: Ryanair/TAP frequent to Spanish cities

## Money Matters

### Cash & Cards
- Cards accepted almost everywhere
- Contactless payments very common
- Some traditional tascas cash-only
- ATMs (Multibanco): Use bank ATMs, not tourist-trap ones

**ATM tip**: Portuguese ATMs ask if you want conversion. ALWAYS choose "without conversion" and let your bank handle the rate.

### Tipping Culture
- **Not expected** like US/Canada
- **Restaurants**: Round up or 5-10% for good service
- **Cafés**: Leave coins from change
- **Taxis**: Round up to nearest €
- **Hotels**: €1-2 for baggage handling if you want

### Budget Expectations (Feb 2026)

| Category | Budget | Mid-Range | Comfort |
|----------|--------|-----------|---------|
| Accommodation | €30-60 | €80-150 | €150-300 |
| Meals | €20-30 | €40-60 | €80+ |
| Transport | €10-15 | €15-20 | €20-40 |
| Attractions | €15-25 | €30-50 | €50+ |
| **Daily Total** | **€75-130** | **€165-280** | **€300+** |

## Communication

### SIM Cards
- **NOS, Vodafone, MEO**: All have prepaid tourist options
- Buy at: Airport arrivals, any NOS/Vodafone/MEO store
- Typical tourist SIM: €15-20 for 10GB data, 30 days
- eSIM: Airalo, Holafly work well

**Recommendation**: €15 NOS prepaid (airport kiosk). 5GB data, calls included, enough for a week.

### WiFi
- Hotels: Generally good
- Cafés: Excellent (Copenhagen, Fabrica, etc.)
- Public: Free WiFi in many plazas (slow)
- Coworking: Numerous options (see `tech.md`)

### Language Basics
Most Portuguese in tourism speak English, but basics appreciated:

| English | Portuguese | Pronunciation |
|---------|------------|---------------|
| Hello | Olá | oh-LAH |
| Thank you | Obrigado/a | oh-bree-GAH-doo/dah |
| Please | Por favor | por fa-VOR |
| Excuse me | Com licença | kom lee-SEN-sa |
| The bill please | A conta, por favor | ah KON-ta |
| One coffee | Um café | oom ka-FEH |
| One beer | Uma cerveja | oo-ma ser-VAY-zha |
| I don't speak Portuguese | Não falo português | now FAH-loo |

**Tip**: "Obrigado" is for men, "Obrigada" for women (speaker's gender, not person you're thanking).

## Safety & Scams

### Generally Very Safe
Lisbon is one of Europe's safest capitals. Violent crime rare for tourists.

### Common Issues

**Pickpockets** (main concern):
- Tram 28 is notorious
- Crowded elevators and funiculars
- Alfama narrow streets
- Night areas of Bairro Alto

**Prevention**:
- Crossbody bags, zipped
- Phone in front pocket
- Don't flash expensive items
- Be alert in crowds

**Restaurant/Bar Scams**:
- "Cover charges" (bread, olives, etc.) — sent back what you don't want
- Menu without prices — always ask
- Wrong change — count it

**Street Scams**:
- Friendship bracelets (Rossio) — just say no and walk
- Fake petitions — decline firmly
- "Found" gold rings — it's fake
- Drugs in Bairro Alto/Rossio — dealers persistent but harmless, just ignore

### Police
- PSP (general police): 112 for emergencies
- Tourist police: Praça dos Restauradores
- Police presence: Good in tourist areas

## Practical Tips

### Hours & Closures
- **Shops**: 10:00-19:00, some close 13:00-15:00
- **Restaurants**: Lunch 12:30-15:00, Dinner 19:30-23:00
- **Museums**: Usually 10:00-18:00, closed Mondays
- **Banks**: 08:30-15:00, Monday-Friday

**Sunday closures**: Many shops closed, restaurants open but some closed for lunch.

**August**: Many small businesses closed. Not best month.

### Dress Code
- Generally casual
- Comfortable walking shoes essential (cobblestones!)
- Layers recommended (weather changes, AC cold)
- Churches: Cover shoulders and knees
- No flip-flops on hills (dangerous)

### Weather Prep
- **Summer**: Sunscreen, hat, water bottle, light clothes
- **Winter**: Rain jacket, layers, umbrella
- **Year-round**: Comfortable walking shoes

### Electrical
- Type F plugs (European standard, 2 round pins)
- 230V, 50Hz
- US/UK travelers need adapters

### Water
- Tap water safe and excellent quality
- Free water at restaurants if you ask (usually)
- Many public fountains drinkable

## Day Trips from Lisbon

### Sintra (Essential)
- **Distance**: 30km
- **Getting there**: Train from Rossio, every 20 min, €2.35
- **Time needed**: Full day
- **Key sites**: Pena Palace, Quinta da Regaleira, Moorish Castle
- **Details**: See `visitor-attractions.md`

### Cascais & Estoril
- **Distance**: 30km west along coast
- **Getting there**: Train from Cais do Sodré, 40 min, €2.35
- **Time needed**: Half to full day
- **What to do**: Beach, old town, cycling to Guincho, seafood
- **Best for**: Beach escape, relaxed atmosphere, families
- **Tip**: Combine with Estoril (casino, gardens) between

### Óbidos
- **Distance**: 80km north
- **Getting there**: Bus from Sete Rios, 1h15, €10
- **Time needed**: Half to full day
- **What to do**: Walk walls, ginjinha in chocolate cup, medieval streets
- **Best for**: Medieval charm, photographers, couples
- **Tip**: Go early to beat day-trippers, magical at sunset

### Setúbal & Arrábida Natural Park
- **Distance**: 50km south
- **Getting there**: Bus or car (car better for flexibility)
- **Time needed**: Full day
- **What to do**: Wild beaches, hiking, dolphin watching, seafood in Setúbal
- **Best for**: Nature lovers, beach seekers, escape from crowds
- **Tip**: Rent a car for Arrábida — buses don't reach best beaches

### Évora (UNESCO)
- **Distance**: 130km east
- **Getting there**: Bus or train, 1.5-2h, €15-20
- **Time needed**: Full day
- **What to do**: Roman temple, bone chapel, cathedral, Alentejo wine
- **Best for**: History buffs, wine lovers, those with more time
- **Tip**: Can combine with Alentejo wine tasting

### Mafra
- **Distance**: 40km northwest
- **Getting there**: Bus from Campo Grande, 1h
- **Time needed**: Half day
- **What to do**: Enormous palace-convent (2,000 rooms), baroque library
- **Best for**: Architecture lovers, Saramago fans (see "Baltasar and Blimunda")
- **Tip**: Combine with Ericeira (surf town) nearby

### Costa da Caparica
- **Distance**: 15km south
- **Getting there**: Bus 153 from Praça de Espanha, or ferry + bus
- **Time needed**: Half to full day
- **What to do**: Long sandy beach, beach bars, surfing
- **Best for**: Locals' beach escape, surfers, budget beach day
- **Tip**: Mini-train runs along beach to different praia stops

### Wine Regions

**Setúbal/Palmela** (Muscatel wines)
- 30 min drive
- José Maria da Fonseca winery tours
- Combine with Arrábida

**Alentejo** (full day or overnight)
- 1.5-2h drive
- Évora, Estremoz, Monsaraz
- Best with car, or book tour

**Arruda dos Vinhos** (day trip)
- 40km north
- Less touristy wine area
- Book winery visits in advance

## Festivals & Events

**January-February**
- Carnival (February) — Processions, parties, not Rio-level but fun

**March-May**
- Fish & Flavours Festival (April) — Seafood focus
- IndieLisboa (April) — Film festival
- Peixe em Lisboa (April) — Fish festival

**June** (The big month)
- **Santo António (June 12-13)** — Lisbon's biggest festival
  - Sardines everywhere
  - Street parties in Alfama
  - Book accommodation months ahead
  - City goes crazy in the best way
- Festas de Lisboa (all month) — Concerts, events, sardines

**July-August**
- Super Bock Super Rock (July)
- NOS Alive (July) — Major music festival in Oeiras
- Many locals leave, tourists arrive

**September-October**
- Santa Casa Alfama (September) — Fado festival
- ModaLisboa (October) — Fashion week
- Web Summit (November) — Huge tech conference

**November-December**
- **Web Summit (early Nov)** — 70,000+ tech people descend
- Christmas markets (December)
- New Year's Eve in Praça do Comércio

## Useful Apps

| App | Purpose |
|-----|---------|
| **Moovit** | Public transport routing |
| **Bolt/Uber** | Ride-hailing |
| **Google Maps** | Navigation (works offline) |
| **Get Your Guide** | Activity booking |
| **Fork** | Restaurant reservations |
| **MB Way** | Portuguese payment app (if you get account) |

## Emergency Contacts

| Service | Number |
|---------|--------|
| Emergency (all) | 112 |
| Police | 112 |
| Ambulance | 112 |
| Fire | 112 |
| Tourist Police | (+351) 213 421 634 |

**Hospitals with English**:
- CUF Descobertas (private, near airport)
- Hospital da Luz (private, central)
- Hospital de Santa Maria (public, largest)

## Departure Checklist

- [ ] Return Navegante card? (No, keep for next visit - €0.50)
- [ ] Buy pastéis de nata for flight? (Bakeries sell boxes)
- [ ] Visit final miradouro for goodbye?
- [ ] Allow 2 hours before flight (airport can be busy)
- [ ] Uber/Metro to airport equally valid
- [ ] Check TAP for online check-in (24h before)
