# Lisbon Itineraries

## Planning Principles

**Critical rules for Lisbon**:
1. **Hills are real** — Don't underestimate elevation changes. Plan downhill routes.
2. **Midday heat** — Summer months: do indoor activities 13:00-16:00.
3. **Portuguese time** — Things open late, close for lunch in some cases, dinner starts 20:00+.
4. **Walking distances deceive** — Short on map = long with hills and cobblestones.

## One Perfect Day

Best for: Layover, quick visit, getting the essential Lisbon experience.

### Morning (08:00-12:30)
**08:00** — Early breakfast at your hotel or local café (galão + pastel de nata)

**09:00** — Head to **Alfama** before crowds
- Start at **Miradouro das Portas do Sol** for morning light on Alfama
- Walk down through the maze of streets
- Pass by **Sé Cathedral** (10 min inside if open)
- End at **Feira da Ladra** if Tuesday/Saturday (flea market)

**11:00** — **Tram 28** from Sé area
- Take it just 4-5 stops through Alfama to Graça
- **Miradouro da Graça** — Best city panorama, have a coffee

**12:00** — Walk down toward Baixa through Mouraria

### Midday (12:30-15:30)
**12:30** — Lunch in **Baixa/Chiado** area
- **Cervejaria Ramiro** (if shellfish, arrive before 13:00)
- Or **A Cevicheria** in Príncipe Real
- Budget option: Tasca in side streets

**14:00** — **Chiado** exploration
- **Livraria Bertrand** — World's oldest bookstore
- **A Brasileira** — Coffee, see Pessoa statue
- **Convento do Carmo** — Earthquake ruins, 15 min visit

**15:00** — **Elevador da Bica** or **Elevador da Glória**
- Ride one of the funiculars for the experience
- Photos, then walk to São Pedro de Alcântara viewpoint

### Afternoon/Evening (16:00-22:00)
**16:00** — Head to **Belém** (Tram 15E from Praça da Figueira, 20 min)
- **Pastéis de Belém** — Skip the queue by eating inside, not takeaway
- **Jerónimos Monastery** — Late afternoon has shorter lines
- Walk along waterfront to **Tower of Belém** (exterior only if time short)
- **MAAT** rooftop for sunset over the river

**19:00** — Return to center (Tram 15E back)

**20:00** — Dinner in **Santos** or **Bairro Alto**
- Santos: Modern Portuguese cuisine
- Bairro Alto: Traditional tascas

**22:00** — Optional: Fado show in Alfama or drinks in Bairro Alto

## Three Days: The Complete Experience

### Day 1: Historic Lisbon

**Morning: Belém**
- 09:00 — Tram 15E to Belém
- 09:30 — **Jerónimos Monastery** (pre-booked tickets)
- 11:00 — **Pastéis de Belém** (avoid lunch rush)
- 11:30 — Walk to **Tower of Belém** (exterior)
- 12:00 — **MAAT** or **Berardo Collection** (both excellent, pick one)

**Lunch: Belém Area**
- 13:00 — **Ponto Final** across the river (ferry from Belém), or
- **Este Oeste** in CCB for quicker option

**Afternoon: Alfama**
- 15:00 — Bus 728 to Alfama or return to center
- 15:30 — **São Jorge Castle** (pre-book if summer)
- 17:00 — Wander down through Alfama
- Various **miradouros** along the way
- **Sé Cathedral**

**Evening: Fado**
- 19:30 — Early dinner in Alfama
- 21:00 — **Fado show** (book ahead)
  - Budget: Tasca do Chico (intimate, authentic)
  - Mid-range: Mesa de Frades
  - Classic: Clube de Fado

### Day 2: Neighborhoods & Local Life

**Morning: Príncipe Real & Jardim Botânico**
- 09:30 — Coffee at **Copenhagen Coffee Lab** or **Fabrica Coffee Roasters**
- 10:00 — Explore **Príncipe Real** streets and boutiques
- 10:30 — **Jardim Botânico** (hidden gem, €3)
- 11:30 — Walk through **Bairro Alto** (quiet in morning)

**Midday: Chiado & Rossio**
- 12:00 — **Convento do Carmo** (earthquake ruins)
- 12:30 — Lunch at **Belcanto** (splurge), or **Café A Brasileira** (budget)
- 13:30 — Browse **Bertrand** and Chiado bookshops

**Afternoon: Time Out Market & Cais do Sodré**
- 14:30 — **Time Out Market** — try multiple stalls
- Or skip Time Out for **Mercado da Ribeira** upstairs (real market, mornings only)
- 16:00 — Walk along riverfront to **Santos**

**Evening: Santos & Alcântara**
- 17:00 — **LX Factory** — browse shops, Ler Devagar bookstore
- 19:00 — Sunset drinks at **Rio Maravilha** rooftop
- 20:30 — Dinner in Santos (Taberna da Rua das Flores, or similar)
- 22:00 — Optional: Bars in Cais do Sodré's "Pink Street"

### Day 3: Sintra Day Trip

**Full day outside Lisbon**

**Morning**
- 08:30 — Train from Rossio Station (buy Viva Viagem if you don't have one)
- 09:15 — Arrive Sintra
- 09:30 — Bus 434 to **Pena Palace** (pre-booked tickets essential)
- 11:30 — Walk down through park (stunning forest trails)

**Midday**
- 12:30 — Lunch in Sintra town
  - **Tascantiga** — modern Portuguese
  - **Incomum** — creative cuisine
  - Budget: Café Paris (touristy but solid)

**Afternoon**
- 14:00 — **Quinta da Regaleira** (2 hours minimum)
  - Initiation Well, grottos, gardens
  - Less crowded than Pena, more magical
- 16:30 — Brief walk through **Sintra National Palace** area (exterior)
- 17:30 — Train back to Lisbon

**Evening**
- 19:00 — Back in Lisbon
- 19:30 — Relaxed dinner in Baixa or Chiado
- 21:00 — Gelato at **Santini** (Portugal's best ice cream)

## One Week: Deep Dive

### Days 1-3: As Above

### Day 4: Cascais & Coast

**Full day beach/coastal escape**

**Morning**
- 09:00 — Train from Cais do Sodré to **Cascais** (40 min, scenic coastal route)
- 10:00 — Explore Cascais old town, marina
- 10:30 — Rent bikes (many rental shops)
- 11:00 — Cycle to **Boca do Inferno** (Hell's Mouth) — dramatic cliffs

**Midday**
- 12:30 — Return bikes, lunch in Cascais
  - **Casa da Guia** complex has nice options
  - **O Pescador** for seafood

**Afternoon**
- 14:00 — Bus to **Guincho Beach** (wild Atlantic beach, great for surfing)
- 16:00 — Return to Cascais, beach time at town beaches
- Or explore **Estoril** (casino, gardens) on return

**Evening**
- 18:30 — Sunset drinks in Cascais marina
- 19:30 — Train back to Lisbon
- 20:30 — Dinner in Lisbon

### Day 5: Art, Museums & Markets

**Morning: Gulbenkian**
- 10:00 — **Calouste Gulbenkian Museum** (3 hours)
  - World-class collection: Egyptian, Islamic, European masters
  - Beautiful gardens included
  - Café on site for break

**Midday**
- 13:00 — Walk through **Parque Eduardo VII** (views from top)
- 14:00 — Lunch near Marquês de Pombal
  - **Cervejaria Ribadoura** for seafood

**Afternoon: Art Route**
- 15:30 — **Museu Nacional de Arte Antiga** (Portuguese masters, Bosch panels)
- Or alternative: **Museu do Oriente** (Asian art, Portuguese exploration history)

**Evening: Graça & Mouraria**
- 18:00 — Tram 28 to Graça
- 18:30 — Walk through **Mouraria** (multicultural, street art)
- 20:00 — Dinner in Mouraria
  - **Zé da Mouraria** — traditional
  - International options abundant (Indian, Chinese, etc.)

### Day 6: Across the River & Local Life

**Morning: Almada & Costa da Caparica**
- 09:00 — Ferry from Cais do Sodré to **Cacilhas**
- 09:15 — Walk along Almada waterfront (views back to Lisbon)
- 10:00 — Optional: **Cristo Rei** statue (bus 101)
- Or: Bus to **Costa da Caparica** beaches

**If beaches**:
- 11:00 — Costa da Caparica — local beach town, good surf
- Beach lunch, relax
- Return late afternoon

**If not beaches**:
- 11:00 — Ferry back, explore **Marvila** neighborhood
  - Craft beer (Dois Corvos, Lince)
  - Street art
  - Industrial-chic vibe

**Afternoon: Campo de Ourique**
- 15:00 — **Cemitério dos Prazeres** (historic cemetery, beautiful)
- 16:00 — **Mercado de Campo de Ourique** (food hall, locals' favorite)
- 17:00 — Browse Campo de Ourique neighborhood (family-friendly, residential)

**Evening**
- 19:00 — Return to center
- 20:00 — Final dinner — splurge on fine dining
  - **Belcanto** (2 Michelin stars)
  - **Alma** (1 Michelin star)
  - Or classic: **Cervejaria Ramiro** shellfish

### Day 7: Your Choice + Departure

**Option A: Óbidos Day Trip**
- Medieval walled town, 1 hour by bus
- Ginjinha (cherry liqueur) in chocolate cups
- Quieter than Sintra, very picturesque

**Option B: Setúbal & Arrábida**
- Stunning natural park, dramatic coastline
- Best with rental car
- Wild beaches, dolphins sometimes visible

**Option C: Slow Final Morning**
- Sleep in
- Favorite café revisit
- Last-minute shopping (Príncipe Real boutiques)
- Final miradouro visit
- Pack and depart

## Itinerary Customizations

### With Kids
- **Day 1**: Oceanário (Parque das Nações), cable car, playground
- **Day 2**: Lisbon Zoo, or boat tour
- **Day 3**: Sintra — kids love Quinta da Regaleira's tunnels
- Avoid: Long walks in Alfama, tiny tascas, late fado shows

### On a Budget
- Free walking tours (tip-based)
- Pack picnic lunches (supermarket + park)
- Focus on free attractions: miradouros, neighborhoods, beaches
- First Sunday free museums
- Skip Sintra palace interiors, just walk the grounds

### Foodie Focus
- Add: Cooking class (Lisbon Cooking Academy)
- Add: Wine tasting (ViniPortugal in Praça do Comércio)
- Add: Food tour of Mouraria/Alfama
- Replace some sightseeing with long lunches
- Day trip to Alentejo wine region

### History Buff
- Add: Full day at Belém monuments
- Add: Museu Nacional de Arte Antiga
- Add: Mafra Convent day trip
- Add: Évora day trip (Roman temple, bone chapel)
- Hire private guide for Alfama/Jerónimos

## Timing Tips

**Best photo times**:
- Miradouros: Sunrise or golden hour (sunset-1hr)
- Alfama: Morning light (before 10:00)
- Belém: Late afternoon (west-facing)
- LX Factory: Anytime (interesting in overcast)

**Crowd avoidance**:
- Major sights: Opening time or last 2 hours
- Sintra: Weekdays only, earliest train
- Tram 28: Early morning or during dinner hours
- Time Out Market: Before 12:00 or after 15:00
- Pastéis de Belém: Before 10:00 or after 21:00

**Beat the heat (summer)**:
- Outdoor sights: 09:00-12:00 and after 17:00
- 13:00-17:00: Museums, cafés, siesta
- Evening: Riverside walks, rooftop bars
