# Portugal Visa & Immigration Guide (Feb 2026)

## Overview: Who Needs What

| Status | Visa Needed? | Notes |
|--------|--------------|-------|
| EU/EEA/Swiss | No | Free movement, register after 3 months |
| UK post-Brexit | Yes | Various options available |
| US/Canada/Australia | Yes for stays >90 days | Tourist visa-free entry |
| Other nationalities | Check | Varies by country |

---

## EU/EEA/Swiss Citizens

### Requirements
- **Stay**: Unlimited
- **Work**: No permit needed
- **Registration**: Required after 3 months (Certificado de Registo)

### Process
1. Arrive freely
2. Get NIF
3. Within 3 months: Register at Câmara Municipal
4. Receive EU Citizen Registration Certificate

### Documents for Registration
- Passport/ID
- Proof of residence (rental contract)
- Proof of income/employment OR health insurance + means of subsistence
- Application form

### After Registration
- Full resident rights
- Access to public healthcare (register at Centro de Saúde)
- Work anywhere without permit
- Apply for permanent residence after 5 years
- Citizenship eligible after 5 years

---

## D7 Visa (Passive Income/Retirees)

### What It Is
Visa for those with passive income who want to live in Portugal without working. Popular with retirees and those with investments/rental income.

### Requirements (2026)

| Requirement | Detail |
|-------------|--------|
| Income | €920/month minimum (100% of minimum wage) |
| Income type | Passive: pensions, rentals, dividends, investments |
| Dependents | +50% (€460) for spouse, +30% (€276) per child |
| Health insurance | Private coverage for Portugal |
| Clean record | No criminal convictions |
| Accommodation | Proof of housing in Portugal |

### Process

**Step 1: Apply at Portuguese consulate (home country)**
- Book appointment
- Submit documents
- Pay fee (~€90)
- Wait 2-3 months

**Documents needed**:
- Passport (valid 6+ months)
- Proof of income (tax returns, bank statements)
- Criminal record (apostilled)
- Health insurance
- Proof of accommodation (rental or property)
- NIF (can get beforehand or state intention)
- Application forms

**Step 2: Arrive in Portugal**
- Entry stamped
- Begin residence process

**Step 3: SEF/AIMA appointment**
- Schedule online (can be months' wait)
- Attend with all documents
- Receive residence permit

### D7 Renewals
- First permit: 2 years
- Renewals: 3 years each
- Must spend majority of time in Portugal
- Maintain income requirements

### Path to Citizenship
- After 5 years legal residence
- Basic Portuguese language test (A2 level)
- Apply through Civil Registry

---

## D8 Visa (Digital Nomad Visa)

### What It Is
Introduced 2022, designed for remote workers employed by foreign companies or freelancers serving foreign clients.

### Requirements (2026)

| Requirement | Detail |
|-------------|--------|
| Income | 4x Portuguese minimum wage (~€3,680/month) |
| Employment | Remote work for non-Portuguese employer |
| OR Freelance | Serving non-Portuguese clients |
| Health insurance | Required |
| Clean record | Required |

### Process

Same as D7:
1. Apply at consulate
2. Arrive in Portugal
3. SEF/AIMA appointment

### Key Differences from D7
- **D7**: Passive income, not supposed to work
- **D8**: Active work allowed (for foreign employers/clients)
- **D8**: Higher income threshold
- **D8**: Explicitly designed for digital nomads

### D8 Considerations
- Still a relatively new visa
- Implementation varies
- Some ambiguity in rules
- Consult immigration lawyer for complex situations

---

## Golden Visa (Investment Visa)

### Current Status (Feb 2026)

**Major changes in 2023**: Real estate route eliminated for most of Portugal.

### Remaining Options

| Investment Type | Minimum Amount |
|-----------------|----------------|
| Investment fund subscription | €500,000 |
| Capital transfer for R&D | €500,000 |
| Capital for business (10 jobs) | €500,000 |
| Arts & cultural heritage | €250,000 |
| Low-density area business | €500,000 |

### Investment Fund Route (Most Popular)

**Requirements**:
- €500,000 in qualifying Portuguese VC/PE fund
- Fund must be CMVM-registered
- 60%+ invested in Portuguese companies
- 5-year hold minimum

**Benefits**:
- Residence permit (initial 2 years, then 3-year renewals)
- Minimal stay requirement (~7 days/year)
- Path to citizenship after 5 years
- Family included
- Schengen access

### Golden Visa Reality Check

**Pros**:
- Minimal physical presence
- Access to EU
- Citizenship path

**Cons**:
- High capital requirement
- Fund performance not guaranteed
- 5-year lock-up
- Program could change
- Complex legal/tax implications

**Advice**: Use specialized Golden Visa lawyers; significant investment warrants professional guidance.

---

## Work Visa (Employment)

### For Non-EU Workers

**Requirement**: Job offer from Portuguese employer before applying.

### Process
1. Portuguese employer obtains work permit (IEFP approval)
2. Worker applies for D1 visa at consulate
3. Arrive and convert to residence permit

### Documents
- Employment contract
- Employer's IEFP approval
- Passport, criminal record, etc.
- Proof of qualifications

### Tech Worker Visa (Fast-Track)

**For qualified tech workers**:
- Expedited processing
- Employer must meet criteria
- Faster than standard work visa

---

## Student Visa (D4)

### For Non-EU Students

**Requirements**:
- Acceptance at Portuguese institution
- Proof of financial means
- Health insurance
- Accommodation

### Can Work?
- Part-time allowed (20h/week during term)
- Full-time during holidays

### Path to Work Permit
- Can convert to work visa upon employment
- Some advantages for finding work while studying

---

## NHR 2.0 (IFICI) - Tax Regime

### What Happened to NHR?

**Original NHR** (2009-2024): 
- 10 years of favorable tax treatment
- 20% flat rate on qualifying income
- Foreign income often exempt

**Ended**: March 31, 2025 for new applicants

### NHR 2.0 / IFICI (Current)

**Who qualifies**:
- Not Portuguese tax resident for previous 5 years
- Working in "high value-added" activities OR
- Companies investing in specific sectors

**Benefits**:
- 20% flat tax on qualifying income
- 10-year duration
- Foreign-source income may be exempt (depends on situation)

**High Value Activities include**:
- Senior tech positions
- Scientific research
- University professors
- Certain medical specialists
- Others specified by law

### Important Notes

- **More restrictive** than original NHR
- **Specific employment** usually required
- **Not for passive income** like retirees
- **Complex rules** — consult tax specialist
- Rules continue to evolve

---

## Family Reunification

### Who Can Bring Family?

Visa holders can apply for dependents:
- Spouse/partner
- Minor children
- Dependent adult children
- Parents (if dependent)

### Process
- Apply simultaneously or after main applicant established
- Same documentation requirements
- Usually processed together

### Family Rights
- Dependents get same residence rights
- Can work (spouses)
- Access education and healthcare

---

## Citizenship

### Requirements

**By residence (naturalization)**:
- 5 years legal residence
- Portuguese language: A2 level
- No criminal record
- Connection to Portuguese community

### Process
1. Gather documents
2. Apply at Civil Registry (Conservatória)
3. Interview
4. Wait for decision (6-18 months)
5. Take oath if approved

### Portuguese Language Test
- A2 level CEFR
- Written and oral
- Not extremely difficult
- Can prepare with courses

### Dual Citizenship
- Portugal allows dual citizenship
- Check your home country's rules
- Many expats maintain both

---

## Practical Tips

### General Advice

1. **Start early** — Visa processes take months
2. **Apostille everything** — Criminal records, diplomas, etc.
3. **Use professionals** — Immigration lawyers save headaches
4. **Keep records** — Save all documents, receipts, correspondence
5. **Check current rules** — Regulations change frequently

### SEF/AIMA Wait Times

**Reality check**:
- Appointments can be months away
- Online booking opens sporadically
- Check early morning for new slots
- Third-party alerting services exist

### Recommended Lawyers/Services

- Specific recommendations change
- Search: "Portugal immigration lawyer" + your nationality
- Verify credentials with Portuguese Bar Association
- Budget: €500-3,000 depending on complexity

### Common Mistakes

- Underestimating processing times
- Incomplete documentation
- Missing appointment deadlines
- Not maintaining required status (income, residency days)
- Tax implications overlooked

---

## Visa Comparison

| Visa | For | Income Req | Work in PT? | Stay Req |
|------|-----|------------|-------------|----------|
| D7 | Passive income | €920/mo | No* | Majority |
| D8 | Remote workers | €3,680/mo | Remote only | Majority |
| Golden | Investors | €500k | Optional | 7 days/yr |
| D1 | Employment | Job offer | Yes | Continuous |
| D4 | Students | Varies | Limited | Academic |

*D7 technically prohibits work; grey area with some remote work.

---

## Quick Contacts

- **AIMA** (Immigration): aima.gov.pt
- **VFS Global**: Visa application centers
- **Portuguese Consulates**: Listed on MNE website
- **SEF/AIMA appointments**: sefservicos.sef.pt

---

## Timeline Expectations

| Stage | Duration |
|-------|----------|
| Document gathering | 2-4 weeks |
| Consulate appointment booking | 1-4 weeks |
| Visa processing | 2-3 months |
| SEF/AIMA appointment wait | 1-6 months |
| Residence permit issuance | 2-4 weeks after |
| **Total**: | **4-12 months** |
