# Lisbon Transport Guide

## The Navegante Card (Essential)

The unified transport card for Lisbon metropolitan area. Replaced the Viva Viagem in name but works similarly.

### Getting the Card
- **Cost**: €0.50 for card (lasts years)
- **Where**: Any metro station machine
- **Language**: English available on machines

### Loading Options

**Zapping (Pay-as-you-go)**
- Load credit (€5, €10, €15, €20, etc.)
- Tap on/tap off at validators
- **Metro/Carris**: €1.72 per trip (valid 60 min)
- **Ferries**: €1.50-2.50 depending on route
- **CP trains** (Cascais, Sintra): Zone-based

**24-Hour Pass**
- **Carris/Metro**: €7.00 — Unlimited metro, bus, tram, funiculars
- **Carris/Metro + Ferries**: €10.35 — Adds river crossings
- Validates first use, 24 hours from then

**Monthly Pass**
- **Metropolitan**: €30-40 depending on zones
- For residents and long-term stays
- Requires photo registration

### Best Strategy by Visit Length

| Stay | Recommendation |
|------|----------------|
| 1-3 days | Load Zapping + consider Lisboa Card if heavy sightseeing |
| 4-7 days | Zapping, maybe one 24h pass for museum day |
| 1+ months | Register for monthly Navegante pass |

---

## Metro

### The Network
- **4 lines**: Blue, Yellow, Green, Red
- **56 stations**
- **Hours**: 6:30-1:00 daily
- **Frequency**: 3-6 minutes peak, 8-10 minutes off-peak

### Lines Overview

| Line | Color | Key Stations |
|------|-------|--------------|
| Azul (Blue) | Blue | Santa Apolónia, Baixa-Chiado, Amoreiras, Reboleira |
| Amarela (Yellow) | Yellow | Rato, Marquês de Pombal, Campo Grande, Odivelas |
| Verde (Green) | Green | Cais do Sodré, Baixa-Chiado, Rossio, Telheiras |
| Vermelha (Red) | Red | Alameda, Oriente (airport connector), São Sebastião |

### Getting to Key Areas

| Destination | Station | Line |
|-------------|---------|------|
| Airport | Aeroporto | Red |
| Baixa/downtown | Baixa-Chiado, Rossio | Blue, Green |
| Alfama | Nearest: Santa Apolónia | Blue |
| Parque das Nações | Oriente | Red |
| Belém | No metro (use tram 15E) | — |
| LX Factory | No metro (use bus/tram) | — |
| Príncipe Real | Nearest: Rato | Yellow |
| Cascais | No metro (use train) | — |

### Metro Art
Lisbon metro stations feature distinctive artwork:
- **Parque**: Abstract colors
- **Oriente**: International artists, stunning
- **Olaias**: Colorful, one of Europe's most beautiful
- **Alameda**: Traditional tiles

Worth stopping to appreciate.

---

## Trams (Eléctricos)

### Historic Trams

**Tram 28 (Most Famous)**
- Route: Martim Moniz → Campo de Ourique through Alfama, Baixa, Chiado, Bairro Alto
- **The reality**: Overcrowded, pickpocket-heavy, slow
- **Better strategy**: Take it for 3-4 stops through Alfama only, or ride Tram 12

**Tram 12**
- Route: Circular through Alfama, Mouraria
- Less crowded than 28, similar old-timey experience

**Price**: 
- Onboard: €3.30 (cash)
- With Zapping: €1.72

### Modern Trams

**Tram 15E**
- Route: Praça da Figueira ↔ Algés (via Belém)
- Modern, air-conditioned articulated trams
- Best way to reach Belém from center
- Every 10-15 minutes
- Zapping: €1.72

---

## Funiculars & Elevators

Historic engineering solutions to Lisbon's hills:

| Name | Route | Hours | Price |
|------|-------|-------|-------|
| **Elevador da Glória** | Restauradores ↔ Bairro Alto | 7:00-24:00 | €4 or Zapping |
| **Elevador da Bica** | Rua de São Paulo ↔ Largo Calhariz | 7:00-21:00 | €4 or Zapping |
| **Elevador do Lavra** | Largo Annunciada ↔ Rua Câmara Pestana | 7:00-20:00 | €4 or Zapping |
| **Elevador de Santa Justa** | Baixa ↔ Carmo (up to Chiado) | 7:00-23:00 | €5.30 |

**Tip**: Santa Justa has huge queues. Walk up via Baixa streets or enter from Carmo church level (free).

---

## Buses (Carris)

### Network
- Extensive network covering areas metro doesn't reach
- Less frequent than metro (10-20 min waits)
- Can be confusing for newcomers

### Useful Routes

| Route | Connects |
|-------|----------|
| 714 | Cais do Sodré → Belém → Algés |
| 728 | Restelo → Belém → Alfama → Parque das Nações |
| 737 | Baixa → Castelo São Jorge |
| 758 | Praça do Comércio → Príncipe Real → Rato |
| 734 | Rossio → Graça → Martim Moniz |

### Payment
- **Onboard**: Not recommended (€2.00 cash, driver only)
- **Zapping**: €1.72, much easier

---

## Ferries (Cacilheiros)

Cross the Tagus for views, beaches, and restaurants:

### Routes from Cais do Sodré

| Destination | Time | Zapping Price |
|-------------|------|---------------|
| Cacilhas | 10 min | €1.50 |
| Trafaria | 30 min | €2.00 |
| Porto Brandão | 20 min | €1.50 |
| Montijo | 30 min | €3.25 |

### Why Ferry

**Cacilhas**: 
- Stunning views of Lisbon from the water
- Great seafood restaurants (Ponto Final, etc.)
- Cristo Rei statue nearby
- Worth it just for the ride

**Trafaria**:
- Access to Costa da Caparica beaches

---

## Trains (CP - Comboios de Portugal)

### Suburban Lines

**Cascais Line** (from Cais do Sodré)
- Route: Cais do Sodré → Cascais (40 min)
- Coastal route, beautiful views
- Stops: Belém, Algés, Oeiras, Estoril, Cascais
- Every 20 minutes
- Price: €2.35 Zapping to Cascais

**Sintra Line** (from Rossio)
- Route: Rossio → Sintra (40 min)
- Every 20 minutes
- Price: €2.35 Zapping to Sintra

**Azambuja Line** (from Santa Apolónia/Oriente)
- Northeast of Lisbon
- Less tourist-relevant

### Long-Distance Trains

**From Santa Apolónia / Oriente**:
- Porto: Alfa Pendular (2h40, €30-45)
- Faro (Algarve): Intercidades (3h, €25-35)
- Évora: (1.5h, €15-20)

**Book at**: cp.pt

---

## Taxis & Rideshare

### Taxis
- **Color**: Black with green roof, or beige
- **Metered**: Yes, always insist
- **Flag**: €3.90 base during day
- **Per km**: ~€0.50
- **Airport to center**: Fixed €15-20 (more at night)
- **Tip**: Not expected, round up

### Uber & Bolt

Both widely available:
- **Cheaper** than taxis usually
- **Easier** for non-Portuguese speakers
- **Reliable** in central areas
- **Airport**: Pick up from designated area
- **Price examples**:
  - Center to airport: €8-15
  - Baixa to Santos: €5-8
  - Center to Belém: €10-15

### When to Use Each

| Situation | Best Option |
|-----------|-------------|
| Airport with luggage | Uber/Bolt or taxi |
| Night out in Bairro Alto | Uber/Bolt |
| Quick central hop | Uber/Bolt |
| Regular commute | Metro |
| Tourist sightseeing | Metro + walking + occasional Uber |

---

## Driving in Lisbon

### Should You?
**For tourists**: Generally NO.
- Parking nightmare in center
- Narrow streets, aggressive drivers
- Trams, pedestrians, hills
- One-way mazes

**When it makes sense**:
- Day trips (Sintra, Arrábida, Alentejo)
- Living in suburbs with family
- Large group/lots of luggage

### If You Drive

**Parking**:
- **EMEL**: City parking authority, green zones
- **Price**: €0.50-1.50/hour depending on zone
- **Apps**: ePark app for paying
- **Avoid**: Double parking (common but risky)

**Tolls**:
- Electronic only on many highways
- Rent car with Via Verde or buy temporary pass
- Ponte 25 de Abril: €1.85 (southbound only)

### Car Rental
- **Airport**: All major companies
- **City**: Various locations
- **Price**: From €30/day including insurance
- **Insurance**: Get full coverage, streets are narrow

---

## Apps for Transport

| App | Use |
|-----|-----|
| **Moovit** | Best for routing public transport |
| **Google Maps** | General navigation, real-time updates |
| **Carris** | Official Carris app |
| **Metro de Lisboa** | Official metro app |
| **Uber** | Rideshare |
| **Bolt** | Rideshare (often cheaper) |
| **ePark** | Parking payment |

---

## Airport Connections

### To City Center

| Method | Time | Cost | Best For |
|--------|------|------|----------|
| Metro (Red line) | 25-35 min | €1.72 | Budget, central hotels |
| Aerobus | 25-40 min | €4 | Near Rossio/Cais do Sodré |
| Uber/Bolt | 15-25 min | €8-15 | Convenience, luggage |
| Taxi | 15-25 min | €15-20 fixed | Late night |

**Pro tip**: If metro is running and you're traveling light, it's by far the best value.

---

## Getting Around: Strategy by Situation

### Tourist Day
- Metro to general area
- Walk between attractions
- Tram 28/15E for specific routes
- Uber for exhaustion/luggage

### Commuter Day
- Metro if on line
- Bus/tram otherwise
- Monthly pass if 1+ months

### Night Out
- Metro until midnight
- Uber after
- Night buses exist but infrequent

### Day Trip
- Train (Sintra, Cascais)
- Bus (Óbidos, Évora)
- Rental car (Arrábida, Alentejo flexibility)
