# Lisbon Tech Scene Guide

## The Tech Transformation

Lisbon went from sleepy Southern European capital to tech hub in under a decade. The catalysts:
- **Web Summit arrival (2016)**: Put Lisbon on global tech map
- **Golden Visa/NHR**: Attracted investment and talent
- **Cost arbitrage**: Cheaper than London/Berlin (initially)
- **Quality of life**: Weather, food, safety
- **COVID remote work**: Digital nomad surge

### Current State (2026)

**5,091 active startups** in Portugal (2025 data)
**€2.856 billion** in annual turnover
**28,000 jobs** in startup ecosystem
**Average startup salary**: €2,200/month (81% above national average)

---

## Major Tech Employers

### Multinational Engineering Centers

| Company | Focus | Approx. Headcount |
|---------|-------|-------------------|
| **Google** | Engineering | 500+ |
| **Mercedes-Benz.io** | Digital products | 500+ |
| **Volkswagen Digital Solutions** | Automotive software | 300+ |
| **Siemens** | Various | 200+ |
| **Cisco** | Engineering | 200+ |
| **Cloudflare** | Engineering | 100+ |
| **Datadog** | Engineering | 100+ |
| **OutSystems** (HQ) | Low-code platform | 400+ |
| **Farfetch** (HQ) | Fashion tech | 500+ |

### Portuguese Tech Champions

| Company | What They Do | Status |
|---------|--------------|--------|
| **OutSystems** | Low-code development | Unicorn, HQ in Lisbon |
| **Farfetch** | Luxury fashion e-commerce | Public company |
| **Talkdesk** | Contact center software | Unicorn |
| **Feedzai** | Fraud prevention AI | Unicorn |
| **Sword Health** | Digital physical therapy | Unicorn |
| **Remote** | HR/payroll platform | Unicorn |

### Growing Companies

- **Unbabel** — AI translation
- **Anchorage Digital** — Crypto custody (HQ moved)
- **Coverflex** — Employee benefits
- **Amplemarket** — Sales automation
- **Rows** — Spreadsheet/database hybrid
- **Aptoide** — Android app store

---

## Salaries (Feb 2026)

### By Role (Gross Monthly, EUR)

| Role | Junior | Mid | Senior | Lead/Staff |
|------|--------|-----|--------|------------|
| Software Engineer | €1,200-1,800 | €2,000-3,000 | €3,500-5,500 | €5,000-7,000 |
| Frontend Developer | €1,200-1,700 | €1,800-2,800 | €3,000-4,500 | €4,500-6,000 |
| Backend Developer | €1,300-1,800 | €2,000-3,200 | €3,500-5,500 | €5,000-7,000 |
| Data Scientist | €1,400-2,000 | €2,500-3,500 | €4,000-6,000 | €5,500-8,000 |
| Data Engineer | €1,300-1,900 | €2,200-3,200 | €3,800-5,500 | €5,000-7,000 |
| DevOps/SRE | €1,400-2,000 | €2,500-3,500 | €4,000-6,000 | €5,500-7,500 |
| Product Manager | €1,500-2,200 | €2,500-3,500 | €4,000-5,500 | €5,500-7,500 |
| UX/UI Designer | €1,000-1,500 | €1,800-2,800 | €3,000-4,500 | €4,000-5,500 |
| Engineering Manager | — | €3,000-4,000 | €4,500-6,000 | €6,000-9,000 |

### Salary Context

**vs Other Cities** (Senior SWE):
- Lisbon: €3,500-5,500
- Barcelona: €4,000-6,000
- Berlin: €5,000-7,000
- Amsterdam: €5,500-8,000
- London: €6,000-10,000

**Reality check**: Salaries lower than Northern Europe, but so is cost of living (somewhat). Tax burden is significant.

### Net Salary Examples

| Gross Monthly | Net Monthly | Effective Tax |
|---------------|-------------|---------------|
| €2,000 | ~€1,400 | ~30% |
| €3,000 | ~€1,950 | ~35% |
| €4,000 | ~€2,450 | ~39% |
| €5,000 | ~€2,900 | ~42% |

### Salary Negotiation Tips

- **Know market rate**: Use Glassdoor, Teamlyzer (Portuguese), Landing.jobs
- **Total comp**: Ask about bonuses, equity, meal allowances
- **14 months**: Standard Portuguese contracts pay holiday (June) and Christmas bonuses
- **Remote premiums**: Some companies pay more for remote (foreign employer rates)
- **Consider equity**: Early-stage startups may offer more equity

---

## Job Market

### Where to Find Jobs

**Platforms**:
- **Landing.jobs** — Portugal-focused tech jobs
- **LinkedIn** — Standard, many listings
- **AngelList/Wellfound** — Startups
- **Indeed Portugal** — General + tech
- **Glassdoor** — Reviews + jobs
- **Remote OK/We Work Remotely** — Remote positions

**Communities**:
- **Portuguese Tech Community** (Slack)
- **Landing.jobs Community**
- **Tech events** (see below)

### Hiring Process

**Typical stages**:
1. Recruiter screen (30 min)
2. Technical screen (1 hour, may include coding)
3. Technical interview(s) (2-3 hours, system design, coding)
4. Culture/team fit
5. Offer

**Timeline**: 2-6 weeks typically

### Visa Sponsorship

**Companies that sponsor**:
- Most large multinationals
- Well-funded startups
- Verify before applying

**Tech Visa program**: Fast-track for qualified tech workers

---

## Web Summit

### What It Is
World's largest tech conference, held in Lisbon since 2016.

### 2025 Stats
- **71,386 attendees**
- **157 countries**
- **November (usually 10-13)**
- **Venue**: Altice Arena + FIL, Parque das Nações

### Why It Matters
- **Networking**: Founders, investors, corporates
- **Visibility**: Lisbon showcased globally
- **Side events**: Thousands of meetups during week
- **Hiring**: Companies recruit heavily

### Attending
- **Tickets**: €500-2,500+ depending on pass type
- **Book accommodation early**: Hotels sell out months ahead
- **Alternatives**: Many free side events

### Criticism
- Too big, hard to navigate
- Expensive
- Less substance than hype
- **But**: Still valuable for connections, especially startup founders

---

## Tech Hubs & Offices

### Innovation Districts

**Parque das Nações**
- Modern, corporate feel
- Near FIL/Altice (Web Summit venue)
- Companies: Various tech offices

**Avenidas Novas / Saldanha**
- Business district
- Mixed tech/corporate
- Good metro access

**LX Factory / Alcântara**
- Creative tech
- Startups, design agencies
- Hip atmosphere

**Second Home (Santos)**
- High-profile coworking
- Vibrant community
- Events and programming

### Coworking Spaces

| Space | Location | Monthly Price | Vibe |
|-------|----------|---------------|------|
| **Second Home** | Santos, others | €250-400 | Creative, beautiful |
| **Heden** | Santos | €200-350 | Digital nomad focused |
| **Outsite** | Santos | €200-300 | Community coliving/coworking |
| **Selina** | Marquês Pombal | €200-350 | Coliving + coworking |
| **Cowork Central** | Baixa | €150-250 | Central, traditional |
| **Village Underground** | Alcântara | €200-300 | Creative, artsy |
| **LACS** | Conde de Óbidos | €200-350 | Large, corporate |
| **NOW Beato** | Beato | €150-250 | Emerging area |

### Day Passes
Most spaces: €15-30/day

---

## Tech Events & Meetups

### Regular Events

- **Lisbon Data Science Meetup** — Monthly
- **Python Portugal** — Regular meetups
- **Lisbon JavaScript** — Frontend community
- **AWS User Group Lisbon** — Cloud
- **DevOps Lisboa** — Infrastructure
- **UX Lisboa** — Design

### Major Conferences

| Event | When | Focus |
|-------|------|-------|
| **Web Summit** | November | General tech |
| **PixelsCamp** | Variable | Developer conference |
| **SAPO Codebits** | Variable | Portuguese tech |
| **Building the Future** | Spring | Portuguese enterprise tech |

### Finding Events
- **Meetup.com** — Most tech meetups
- **Eventbrite** — Larger events
- **LinkedIn Events** — Corporate events
- **Landing.jobs Events** — Job-related

---

## Education & Upskilling

### Bootcamps

- **Le Wagon** — Web development, data science
- **Ironhack** — Web dev, UX, data
- **Ubiqum Code Academy** — Various tech tracks
- **Wild Code School** — Web development

### Universities

- **Instituto Superior Técnico (IST)** — Top engineering school
- **NOVA IMS** — Information management
- **Católica** — Some tech programs

### Online + Local
Many tech workers combine online learning (Coursera, etc.) with local community

---

## Remote Work Scene

### Digital Nomad Hub

Lisbon is **one of Europe's top digital nomad destinations**:
- D8 visa available
- Strong coworking scene
- Fast internet
- Good weather
- English widely spoken

### Typical Setup

- Coworking: €200-350/month
- Home: Ensure good internet
- Cafés: Excellent WiFi culture (Copenhagen Coffee Lab, Fabrica, etc.)

### Remote-Friendly Companies

Many companies offer fully remote or hybrid:
- Portuguese startups increasingly flexible
- Multinationals often offer remote
- International remote jobs (D8 visa for non-EU)

---

## Networking Tips

### How to Network in Lisbon Tech

1. **Attend Web Summit** (or side events during week)
2. **Join meetups** — Technical and startup-focused
3. **Cowork** — Second Home, Heden have built-in community
4. **LinkedIn** — Active Portuguese tech community
5. **Slack communities** — Portuguese Tech Community

### Cultural Notes

- **Relationships matter** — Personal connections valued
- **Less transactional** than US/UK networking
- **Coffee meetings** — Common way to connect
- **Dinner/drinks** — Business often discussed socially
- **Be patient** — Takes time to build network

---

## Starting in Lisbon Tech

### As an Employee

1. **Job search**: Use platforms above
2. **Visa**: Employer sponsors if non-EU
3. **Negotiate**: Know market rates
4. **Network**: Join communities

### As a Freelancer

1. **Register**: Get NIF, open activity (Ato Isolado or full)
2. **Find clients**: Local + international
3. **Cowork**: Community helps
4. **Invoicing**: Recibos verdes system

### As a Founder

See `startup.md` for full details on starting a company.

---

## Outlook

### Trends

**Positive**:
- Continued investment (though slower than 2021-2022)
- Talent pool growing
- Infrastructure maturing
- Quality of life attracting senior talent

**Challenges**:
- Salaries still lag vs Northern Europe
- Housing costs strain local talent
- Competition for talent intense
- Some talent emigrates for higher pay

### Sectors to Watch

- AI/ML (strong academic pipeline)
- Climate tech
- Health tech
- Fintech
- B2B SaaS
