# Lisbon Startup Ecosystem Guide

## Ecosystem Overview

### Current State (Feb 2026)

**Portugal's startup ecosystem reached a milestone**:
- **5,091 active startups** (2025)
- **€2.856 billion** annual turnover
- **28,000 jobs** in startup sector
- **8% growth** vs 2024
- **7 unicorns** (OutSystems, Farfetch, Talkdesk, Feedzai, Sword Health, Remote, Anchorage)

### Evolution

| Period | Phase |
|--------|-------|
| Pre-2015 | Small scene, few exits |
| 2015-2017 | Web Summit arrives, attention grows |
| 2018-2020 | First unicorns, VC activity increases |
| 2021-2022 | Peak funding, crypto boom |
| 2023-2024 | Correction, focus on fundamentals |
| 2025+ | Maturing ecosystem, sustainable growth |

---

## Funding Landscape

### Investment Stages Available

| Stage | Typical Check | Key Players |
|-------|---------------|-------------|
| Pre-seed | €50K-300K | Angels, accelerators |
| Seed | €300K-2M | Indico, Armilar, Shilling |
| Series A | €2M-15M | Indico, Faber, Target Global |
| Series B+ | €15M+ | International funds |

### Portuguese VCs

| Fund | Focus | Stage |
|------|-------|-------|
| **Indico Capital** | Generalist | Seed to Series B |
| **Armilar Venture Partners** | Tech | Seed to Series A |
| **Faber Ventures** | Deep tech, B2B | Pre-seed to Series A |
| **Shilling Capital** | Generalist | Seed |
| **MAZE** | Impact | Seed |
| **Portugal Ventures** | Government fund | Seed to Series A |
| **LC Ventures** | Consumer, SaaS | Seed |

### Active Angels

**Notable angel investors**:
- Founders of successful Portuguese startups
- Tech executives from multinationals
- Business Angels Club of Lisbon

**Angel networks**:
- FNABA (Federação Nacional de Associações de Business Angels)
- Business Angels Club
- Various syndicates

### International VCs Active in Portugal

| Fund | Origin | Notes |
|------|--------|-------|
| **Target Global** | Germany | Series A focus |
| **Point Nine** | Berlin | SaaS |
| **Balderton** | UK | Growth |
| **Atomico** | UK | Growth |
| **Accel** | US/Europe | Various |

---

## Accelerators & Incubators

### Major Programs

| Program | Focus | Duration | Investment |
|---------|-------|----------|------------|
| **Startup Lisboa** | Generalist | 12 months | Support, no equity |
| **BGI MIT Portugal** | Deep tech | 9 months | €50K |
| **Fábrica de Startups** | Generalist | Various | Support |
| **Beta-i** | Corporate innovation | Various | Project-based |
| **EIT programs** | Various verticals | Variable | Grants |

### Startup Lisboa

**Portugal's largest incubator**:
- Multiple locations
- 500+ startups supported
- No equity taken
- Services: space, mentorship, connections
- Application-based

### Sector-Specific

- **EIT Health** — Health tech
- **EIT Digital** — Digital innovation
- **EIT InnoEnergy** — Clean energy
- **Blue Bio Value** — Ocean economy

---

## Support Programs

### Government Incentives

**Startup Portugal programs**:
- **Startup Voucher**: €840/month for founders (12 months)
- **Tech Visa**: Fast-track work permits
- **Vale Incubação**: €10K voucher for incubator services

**IAPMEI**:
- Various SME support programs
- Innovation vouchers
- Competitiveness grants

**SIFIDE**:
- R&D tax credit
- Up to 82.5% of R&D expenses
- Significant benefit for tech companies

### EU Funding

**Available through Portugal**:
- Horizon Europe
- EIC Accelerator
- Regional development funds (Portugal 2030)

**Reality**: Complex applications, but substantial funding available

---

## Where Startups Work

### Incubators with Space

| Location | Area | Notes |
|----------|------|-------|
| **Startup Lisboa** | Baixa, Santos, Beato | Multiple hubs |
| **LX Factory** | Alcântara | Creative, smaller offices |
| **Hub Criativo do Beato** | Beato | Large, new development |
| **Beta-i** | Beato, Center | Innovation hub |

### Coworking with Startup Focus

| Space | Location | Monthly |
|-------|----------|---------|
| **Second Home** | Santos, Príncipe Real | €250-400 |
| **Heden** | Santos | €200-350 |
| **LACS** | Conde d'Óbidos | €200-350 |
| **Village Underground** | Alcântara | €200-300 |

---

## Notable Lisbon Startups

### Unicorns & Soonicorns

| Company | Sector | Founded | Status |
|---------|--------|---------|--------|
| **OutSystems** | Low-code | 2001 | Unicorn |
| **Farfetch** | E-commerce | 2007 | Public |
| **Talkdesk** | Contact center | 2011 | Unicorn |
| **Feedzai** | AI/Fraud | 2011 | Unicorn |
| **Sword Health** | Digital health | 2015 | Unicorn |
| **Remote** | HR tech | 2019 | Unicorn |
| **Unbabel** | AI translation | 2013 | Growth |
| **Coverflex** | HR/Benefits | 2019 | Series B |
| **Amplemarket** | Sales AI | 2019 | Series B |

### Rising Stars

- **Rows** — Next-gen spreadsheets
- **YData** — Synthetic data
- **Utrust** — Crypto payments
- **360imprimir** — Online printing
- **Cloudflare** — (large engineering center)

---

## Building Your Team

### Talent Pool

**Strengths**:
- Strong engineering schools (IST, NOVA, UP)
- Multilingual workforce
- Increasingly experienced (ecosystem maturing)
- More senior talent staying vs emigrating

**Challenges**:
- Intense competition for top talent
- Salary expectations rising
- International companies pulling talent
- Sometimes lack of scale-up experience

### Hiring Strategies

1. **Job boards**: Landing.jobs, LinkedIn, AngelList
2. **University connections**: IST career fairs, etc.
3. **Community**: Meetups, Web Summit
4. **Referrals**: Incentivize existing team
5. **Acqui-hires**: Acquiring small teams

### Compensation Reality

Startups compete with:
- Portuguese unicorns (pay well)
- International tech centers (Google, Mercedes.io)
- Remote international jobs

**What works**:
- Meaningful equity
- Growth opportunity
- Mission/vision
- Flexibility
- Learning environment

---

## Legal & Structure

### Company Formation

See `business.md` for detailed formation guide.

**For startups specifically**:
- Usually **Lda** (limited liability company)
- Minimum capital: €1
- **Empresa na Hora**: Same-day formation possible

### Equity & ESOP

**Employee stock options**:
- Increasingly common
- Tax treatment complex
- Structure carefully with lawyer
- Vesting periods standard (4 years, 1 year cliff)

**Shareholder agreements**:
- Essential for founder teams
- Cover: voting, vesting, decisions, exits

### Investment Documents

**Standard for Portuguese market**:
- Term sheet (non-binding)
- SHA (Shareholders Agreement)
- Subscription agreement
- Often simplified at early stage

**Note**: Portuguese legal system, but international VCs may want English law documents

---

## Fundraising Process

### Typical Seed Round

1. **Prepare**: Deck, metrics, data room
2. **Research**: Target appropriate funds
3. **Warm intros**: Network for introductions
4. **First meetings**: Pitch, qualify interest
5. **Deep dives**: Metrics, team, market
6. **Term sheet**: Negotiate terms
7. **Due diligence**: Legal, financial, technical
8. **Close**: Sign documents, wire funds

**Timeline**: 3-6 months typical

### What Investors Look For

**Universal**:
- Strong team
- Large market
- Clear differentiation
- Traction (revenue, users, growth)
- Realistic plan

**Portugal-specific considerations**:
- Can you attract/retain talent?
- International expansion plan?
- Why build here?

### Pitch Deck Essentials

1. Problem
2. Solution
3. Market size
4. Business model
5. Traction
6. Competition
7. Team
8. Financials
9. Ask

---

## Community & Networking

### Events

| Event | When | Type |
|-------|------|------|
| **Web Summit** | November | Major conference |
| **Lisbon Investment Summit** | Annual | Investor-focused |
| **PixelsCamp** | Variable | Developer conference |
| **SAPO Codebits** | Variable | Tech |
| **Building the Future** | Spring | Enterprise |

### Regular Meetups

- Startup Grind Lisbon
- Founders Friday
- Sector-specific: Fintech, Health Tech, etc.
- Technical: Python, JS, Data Science

### Informal Networking

- Coffee at coworkings
- Second Home bar/events
- LX Factory weekends
- LinkedIn (Portuguese ecosystem very active)

---

## International Expansion

### Common Paths

**From Lisbon**:
1. Start with Portuguese customers
2. Expand to Brazil (language advantage)
3. Enter Spain
4. Broader Europe
5. US/Global

**Or**:
1. Build in Lisbon (engineering, operations)
2. Start sales in larger markets (US, UK)
3. Use Lisbon as HQ for Europe

### Why Lisbon Works for International

- English widely spoken
- Timezone bridges US/Asia
- EU base (regulatory, market access)
- Cost-effective operations
- Quality of life attracts talent

---

## Challenges & Realities

### What's Hard

- **Funding gap**: Less late-stage capital than US/UK
- **Market size**: Portugal is small, need international early
- **Talent competition**: Intense, salaries rising
- **Bureaucracy**: Government processes slow
- **Scale experience**: Fewer people who've done hypergrowth
- **Exit environment**: Limited M&A activity locally

### What's Good

- **Quality of life**: Attracts and retains talent
- **Cost**: Still cheaper than London/SF (but narrowing)
- **Support**: Government and private programs helpful
- **Network**: Small ecosystem = accessible
- **Momentum**: Continuing to grow and mature
- **International**: Founders increasingly global-minded

---

## Resources

### Organizations

- **Startup Portugal**: startupportugal.com
- **AICEP**: Investment/export agency
- **IAPMEI**: SME support
- **Startup Lisboa**: startuplisboa.com
- **Beta-i**: beta-i.com

### Media

- **Dinheiro Vivo Tech** — Portuguese tech coverage
- **Eco** — Portuguese business
- **EU-Startups** — European startup news
- **Tech.eu** — European tech

### Communities

- **Portuguese Tech Community** (Slack)
- **Landing.jobs Community**
- **LinkedIn groups**

---

## Timeline: Launching a Startup

| Month | Activity |
|-------|----------|
| 1 | Validate idea, form founding team |
| 2 | Register company (Empresa na Hora) |
| 2-3 | Build MVP, initial customers |
| 3-4 | Apply to accelerators/incubators |
| 4-6 | First paying customers, metrics |
| 6-9 | Prepare for fundraising |
| 9-12 | Pre-seed/seed round |
| 12+ | Scale, hire, expand |
