# Safety & Legal Guide for Lisbon

## Overall Safety Assessment

**Lisbon is one of Europe's safest capitals.** Violent crime against tourists is extremely rare. The main concerns are opportunistic theft and scams—annoyances rather than dangers.

### Global Safety Index Position
- Regularly ranks in top 10 safest cities globally
- Safer than Barcelona, Rome, Paris, London
- Comparable to Copenhagen, Vienna

---

## Crime Reality

### What Actually Happens

**Pickpocketing** — The main issue:
- Tram 28 (notorious)
- Rossio/Restauradores area
- Elevador de Santa Justa queue
- Crowded tourist spots
- Bairro Alto late night

**Tourist scams**:
- Fake drugs (oregano sold as weed)
- Restaurant overcharging
- Friendship bracelet vendors
- Petition signature scams

**What rarely happens**:
- Violent crime
- Mugging with weapons
- Home invasion
- Assault

### By Neighborhood

| Area | Day | Night | Notes |
|------|-----|-------|-------|
| Baixa | ★★★★☆ | ★★★★☆ | Tourist crowds = pickpockets |
| Chiado | ★★★★★ | ★★★★★ | Very safe |
| Alfama | ★★★★☆ | ★★★☆☆ | Some dark streets at night |
| Bairro Alto | ★★★★☆ | ★★★☆☆ | Drunk crowds, petty theft |
| Príncipe Real | ★★★★★ | ★★★★★ | Very safe |
| Santos | ★★★★★ | ★★★★☆ | Safe |
| Mouraria | ★★★☆☆ | ★★★☆☆ | Some drug activity, but safe |
| Cais do Sodré | ★★★★☆ | ★★★☆☆ | Late-night rowdiness |
| Graça | ★★★★★ | ★★★★☆ | Residential, safe |
| Parque das Nações | ★★★★★ | ★★★★★ | Very safe |
| Benfica | ★★★★☆ | ★★★★☆ | Safe, less touristy |

### Martim Moniz / Intendente
Special mention: These areas have visible drug dealing. However:
- Dealers target addicts, not tourists
- Police presence increased
- Gentrification ongoing
- Walk through confidently, ignore approaches
- Statistically still safe

---

## Prevention Tips

### Anti-Pickpocket

**Do**:
- Use crossbody bags with zipper
- Keep phone in front pocket
- Be extra alert on Tram 28
- Carry only what you need
- Split cash between locations

**Don't**:
- Back pocket anything
- Open bags in crowds
- Leave bags unattended
- Flash expensive items
- Set phone on café table

### Scam Avoidance

**Restaurant scams**:
- Couvert (bread/olives) is charged—return if unwanted
- Ask price before ordering fish by weight
- Check bill carefully
- Avoid places with aggressive doorway solicitation

**Street scams**:
- "Petition" signers → decline and walk
- Friendship bracelets → firm no, keep walking
- "Dropped" gold rings → fake, ignore
- CD sellers → don't engage
- Drug offers → decline, don't buy, walk on

### Women's Safety

**Lisbon is generally very safe for solo women travelers**:
- Street harassment less common than Southern Europe
- Safe to walk alone in most areas
- Normal precautions apply at night
- Bairro Alto late night: stick to main streets
- Trust your instincts as anywhere

**Practical tips**:
- Uber at night vs walking dark streets
- Stay in populated areas after midnight
- Portuguese culture is generally respectful

---

## Drugs & Alcohol Laws

### Drug Policy

**Portugal's unique approach** (since 2001):
- **Personal use amounts decriminalized** (not legal!)
- Possession of <10-day supply = administrative offense, not criminal
- Results in: fine, treatment referral, or warning
- NO jail for personal use amounts
- **Dealing remains criminal**

**What this means practically**:
- You won't be arrested for carrying small amounts
- Police may confiscate and issue citation
- You'll meet a "dissuasion commission" if cited
- Buying still exposes you to criminal dealers
- Quality/safety not guaranteed
- Tourists: don't assume immunity—discretion advised

**Reality on streets**:
- Dealers visible in Rossio, Martim Moniz, Bairro Alto
- Often sell fake/low quality
- Ignore approaches, don't engage

### Alcohol Laws

| Rule | Detail |
|------|--------|
| Legal drinking age | 18 |
| Public drinking | Generally tolerated |
| Drunk driving | Zero tolerance (0.5g/L, lower for new drivers) |
| Store sales | Available until late |
| Bar hours | Many until 4am |

**DUI consequences**:
- Fines €250-2,500
- License suspension
- Possible prison for high levels
- Don't do it

---

## Emergency Services

### Emergency Numbers

| Service | Number |
|---------|--------|
| General Emergency | 112 |
| Police (PSP) | 112 |
| Ambulance | 112 |
| Fire | 112 |

**112 works from any phone**, including without SIM.

### Police

**PSP (Public Security Police)**: Main urban police
**GNR (Republican Guard)**: Rural areas, highways

**Tourist Police Station**:
- Location: Praça dos Restauradores (Palácio Foz)
- English spoken
- For: theft reports, lost documents, tourist issues

### Hospitals with English

**Public**:
- Hospital de Santa Maria (largest)
- Hospital de São José (central)

**Private** (faster, English guaranteed):
- CUF Descobertas (near airport)
- Hospital da Luz (central)
- British Hospital (historic, Estrela area)

### Pharmacies

- **Green cross** signs
- Many open late
- Farmácias de serviço: 24h rotation
- Pharmacists can advise on minor issues
- Many medications available without prescription (more than UK/US)

---

## Legal Considerations

### Portuguese Law Basics

**As a tourist**:
- Carry ID (passport copy acceptable)
- Obey traffic laws
- Don't buy from street dealers
- Respect photography restrictions

**As a resident**:
- Register with local authorities (EU) or immigration (non-EU)
- Pay taxes if resident >183 days
- Vehicle registration if bringing car
- Pet registration

### Photography Rules

**Generally permissive**:
- Street photography: allowed
- Tourist sites: allowed (no tripods sometimes)
- People: technically need consent for publication
- Government buildings: some restrictions
- Military: no photography
- Private property: ask permission

**Practical rule**: Be respectful. If someone objects, delete.

### Short-Term Rental Laws

**Alojamento Local (AL) regulations**:
- New licenses suspended in most of Lisbon (2023+)
- Many existing Airbnbs operating under old licenses
- Some operate illegally
- As a renter: not your legal problem
- As operator: complex licensing required

### Work Without Permit

**For non-EU citizens**:
- Working without proper visa = illegal
- Digital nomad grey area addressed by D8 visa
- Freelancing for foreign clients without visa = technically problematic
- Enforcement: sporadic but exists
- Get proper visa for long-term

---

## Natural Hazards

### Earthquakes

**Lisbon sits on active fault lines** (1755 disaster):
- Minor tremors occasionally felt
- Building codes updated for seismic safety
- Modern buildings: safer
- Historic buildings: variable
- If earthquake: stay calm, doorframe or under desk, away from windows

### Weather Hazards

**Summer heat**:
- Heat waves reaching 40°C+
- Stay hydrated
- Seek shade/AC midday
- Heat stroke risk for unacclimatized

**Winter storms**:
- Occasional heavy rain
- Flooding in low areas
- Strong winds
- Generally mild

### Fire Season

- **Summer wildfires**: Common in Portugal, occasionally visible/smellable from Lisbon
- Air quality can suffer
- Usually not direct threat to city
- Follow local news if smoke visible

### Ocean

**Atlantic beaches**:
- Powerful currents
- Cold water (even summer)
- Only swim at guarded beaches
- Respect flag warnings
- Not Mediterranean-calm

---

## LGBTQ+ Safety

**Portugal is one of Europe's most LGBTQ+-friendly countries**:
- Same-sex marriage legal (2010)
- Anti-discrimination laws
- Lisbon Pride well-attended
- Príncipe Real = LGBTQ+ hub
- Generally very accepting

**Practical experience**:
- Public affection: generally fine
- Some older/rural areas: more conservative
- Harassment: rare
- Nightlife: welcoming everywhere

---

## For Families

### Child Safety

**Very family-friendly city**:
- Low crime
- Drivers generally cautious near kids
- Many family-oriented spaces
- Beaches: supervised in summer

**Watch for**:
- Hills + strollers = exhausting
- Cobblestones can be tricky
- Traffic in narrow streets
- Hot surfaces in summer

### Playground Quality

- City parks have good playgrounds
- Parque das Nações excellent for families
- Jardim da Estrela has playground
- Many smaller squares have play areas

---

## Insurance Recommendations

### Travel Insurance

**Should cover**:
- Medical expenses (even with EHIC)
- Trip cancellation
- Theft/loss
- Emergency evacuation

**Providers**: World Nomads, SafetyWing, Allianz, etc.

### Residents

**Health insurance options**:
- Public SNS (free for residents)
- Private supplementary (€50-200/month)
- Company plans (often included in employment)

---

## Reporting Issues

### Theft Report

**Why report**:
- Insurance claims require police report
- Credit card replacement
- Passport replacement process

**How**:
1. Tourist Police (Praça dos Restauradores) easiest
2. Any PSP station
3. Online: queixaselectronicas.mai.gov.pt (Portuguese)

**What to bring**:
- ID/passport (or copy)
- List of stolen items
- Details of incident

### Lost Passport

1. File police report
2. Contact your embassy/consulate
3. Apply for emergency travel document
4. Allow several days processing

**Embassies**: Most in Lapa/Estrela area

---

## COVID & Health Protocols (2026)

**Current status**: Largely normalized
- No mask requirements (as of knowledge date)
- No vaccination requirements for entry
- Public health infrastructure remains
- Protocols could change—check before travel

---

## Summary: Staying Safe

**The basics**:
1. Watch belongings in tourist areas
2. Don't engage with street dealers
3. Trust your instincts
4. Use Uber at night if unsure
5. Keep copies of documents
6. Have travel insurance
7. Know emergency number: 112

**Perspective**: Lisbon is genuinely safe. These precautions are the same as any major city. Don't let safety concerns prevent enjoyment—just be sensible.
