# Moving to & Settling in Lisbon

## Pre-Arrival Preparation

### 3-6 Months Before

**Research phase**:
- Determine visa type needed (see `visas.md`)
- Start gathering documents
- Research neighborhoods (see neighborhood guides)
- Budget planning (see `cost.md`)
- Research schools if with children

**Financial preparation**:
- Ensure sufficient savings (6 months expenses recommended)
- Understand currency/banking options
- Get international credit cards (no forex fees)

### 1-3 Months Before

**For non-EU requiring visa**:
- Apply for D7/D8/appropriate visa
- Apostille documents
- Criminal background checks
- Health insurance arranged

**For EU citizens**:
- Minimal paperwork needed
- But plan NIF acquisition
- Consider job search if employed

**Practical**:
- Book temporary accommodation (1-2 months Airbnb)
- Research neighborhoods in person if possible
- Healthcare coverage sorted
- Pet arrangements if applicable

### 1 Month Before

**Logistics**:
- Decide: ship belongings or start fresh?
- International shipping: 6-8 weeks by sea, expensive
- Most expats: Arrive with essentials, buy rest locally
- Cancel/pause home country subscriptions

**Tech**:
- Download offline maps
- Research SIM options
- Backup important documents digitally

---

## First Week Checklist

### Day 1-2
- [ ] Arrive, settle into temporary accommodation
- [ ] Get Portuguese SIM card (airport or NOS/Vodafone store)
- [ ] Walk neighborhoods you're considering
- [ ] Get oriented to public transport

### Day 3-5
- [ ] **Get NIF** (critical first step)
- [ ] Start apartment hunting (Idealista, Facebook groups)
- [ ] Open bank account (if possible—may need address)
- [ ] Explore local supermarkets, essentials

### Day 6-7
- [ ] Schedule apartment viewings
- [ ] Research health center registration
- [ ] Connect with expat communities
- [ ] Begin Portuguese basics if haven't already

---

## Finding an Apartment

### The Challenge

Lisbon's rental market is **extremely competitive**:
- Limited supply
- High demand from locals, expats, digital nomads
- Prices elevated from tourism/investment boom
- Scams exist

### Where to Search

**Platforms**:
- **Idealista**: Main platform, most listings
- **Imovirtual**: Similar to Idealista
- **Spotahome**: Verified furnished rentals
- **Uniplaces**: Verified, young professional focus
- **Facebook groups**: "Lisbon Expats", "Housing in Lisbon"

**Agencies**:
- More expensive (1 month fee)
- But helpful for non-Portuguese speakers
- Can expedite process

### Viewing Tips

**What to check**:
- Natural light (north-facing can be dark)
- Heating/AC (many have neither)
- Water pressure
- Noise (visit at different times)
- Elevator (many don't have)
- Storage space
- Building maintenance

**Questions to ask**:
- What's included in rent?
- How are utilities paid?
- Contract length?
- Deposit amount?
- Renewal terms?

### Contract Basics

**Standard terms**:
- **Deposit**: 2 months rent (returnable)
- **Agency fee**: 1 month (if using agent)
- **Contract length**: 1 year minimum typical
- **Notice period**: Usually 120 days
- **Annual increase**: Linked to inflation index

**Red flags**:
- No contract offered
- Cash only, no receipts
- Landlord unavailable
- Below-market prices (scam likely)
- Payment before viewing (always scam)

### Timing

- **Best months**: October-May (less competition)
- **Worst months**: June-September (tourism surge)
- **Web Summit week**: Impossible

---

## First Month Tasks

### Week 1-2

**Administrative**:
- [ ] Sign rental contract
- [ ] Set up utilities transfer
- [ ] Register address with authorities (EU) or SEF (non-EU)
- [ ] Get Número de Utente (healthcare number)
- [ ] Open Portuguese bank account

**Practical**:
- [ ] Furnish apartment if unfurnished
- [ ] Set up internet
- [ ] Get phone contract (if staying long-term)
- [ ] Learn neighborhood: shops, transport, services

### Week 3-4

**Integration**:
- [ ] Register at local health center
- [ ] Get monthly transport pass
- [ ] Join local communities/activities
- [ ] Start Portuguese classes
- [ ] Find regular café (important socially!)

**Work-related**:
- [ ] If employed: Start job, register with Social Security
- [ ] If freelance: Register as independent worker
- [ ] If remote: Set up coworking or home office

---

## Registration & Legal

### EU Citizens

**Requirement**: Register with Câmara Municipal after 3 months

**Process**:
1. Go to Câmara Municipal or Loja do Cidadão
2. Bring: passport, proof of address, proof of income/employment
3. Get Certificado de Registo

**Timeline**: Can do anytime, but officially within 3 months

### Non-EU Citizens

**Process** (after arriving with visa):
1. Schedule SEF appointment (online booking)
2. Attend appointment with all documents
3. Receive residence permit

**Documents typically needed**:
- Valid visa
- Passport
- Proof of address
- Proof of income/employment
- Health insurance
- Criminal record check
- NIF

**Timeline**: SEF appointments can have long waits (months). Book early.

---

## Social Security (Segurança Social)

### Why It Matters

- Healthcare entitlement
- Pension contributions
- Unemployment insurance
- Required for legal employment

### Getting NISS

**NISS** = Número de Identificação de Segurança Social

**If employed**:
- Employer usually registers you
- You receive NISS automatically

**If self-employed**:
- Register yourself at Segurança Social
- Choose contribution bracket
- Pay monthly (~€20-350/month depending on income declaration)

---

## Healthcare Setup

### Public System (SNS)

1. Get NIF
2. Register at local Centro de Saúde
3. Receive Número de Utente
4. Assigned a family doctor (can take time)
5. Access public healthcare

**EU citizens**: EHIC provides temporary coverage

### Private Insurance

**Why consider**:
- Faster access to specialists
- Private hospitals (more English)
- Skip public waiting lists
- Company plans often include

**Providers**: MGEN, Multicare, Médis, Fidelidade

---

## Working in Portugal

### Employment Contract

**Typical terms**:
- 40-hour work week
- 22 vacation days
- 14 months salary (holiday bonus June, Christmas bonus December)
- Notice periods vary by tenure

### Freelance / Self-Employed

**Ato Isolado**: Occasional services (up to €12,500/year)
**Trabalhador Independente**: Full self-employed status

**Setup**:
1. Register as self-employed at Finanças
2. Register with Segurança Social
3. Issue recibos verdes (green receipts) for income
4. Quarterly IVA (VAT) declarations
5. Annual IRS (income tax)

### Tax Overview

**Employment**:
- Tax deducted at source by employer
- Progressive rates 14.5% to 48%
- Social security: 11% employee, 23.75% employer

**Self-employed**:
- Pay quarterly advances
- Annual declaration
- Social security: Self-paid, based on income

**For detailed tax info**: See `visas.md` (NHR 2.0) or consult an accountant

---

## Integration Tips

### Learn Portuguese

**Even basics help enormously**:
- Locals appreciate effort
- Opens social doors
- Necessary for some services
- Free classes available (IEFP)

**Options**:
- IEFP free courses for residents
- Language schools (Lisbon Language Café, CIAL)
- Online (Duolingo, Babbel, iTalki)
- Conversation exchanges

### Find Your Tribe

**Expat communities**:
- InterNations Lisbon
- Facebook groups (by nationality, interest)
- Meetup.com events
- Digital nomad communities (Santos, coworkings)

**Local integration**:
- Neighborhood associations
- Sports clubs
- Volunteer organizations
- Cultural activities

### Portuguese Workplace Culture

**What to expect**:
- More hierarchical than Northern Europe
- Relationships matter
- Meetings can run long
- Lunch often proper sit-down
- Dress: Smart casual in most tech; formal in finance

---

## Practical Tips from Expats

### What People Wish They'd Known

1. **Learn Portuguese** — Even basics transform experience
2. **NIF first** — Get it immediately upon arrival
3. **Bank account takes time** — Don't underestimate
4. **Apartments go fast** — Decide quickly
5. **Winter can be cold inside** — Check heating
6. **August is dead** — Plan around closures
7. **Bureaucracy is slow** — Be patient
8. **Relationships > processes** — Personal connections help
9. **Good shoes** — Hills and cobblestones are real
10. **Embrace Portuguese time** — Things move slower

### Cultural Adjustments

**Coming from Northern Europe/US**:
- Things happen slower (embrace it)
- Direct communication less common
- Lunch is sacred (don't schedule meetings 13:00-14:30)
- Work-life balance better than expected
- Socializing is essential

**Coming from Southern Europe**:
- Similar pace
- Portuguese are quieter than Spanish/Italian
- More reserved initially, warm once known
- Fado culture unique

---

## Cost of Setting Up

### One-Time Costs

| Item | Cost |
|------|------|
| NIF (through representative) | €100-200 |
| Apartment deposit | 2 months rent |
| Agency fee (if used) | 1 month rent |
| Initial furnishing | €500-3,000 |
| Utility deposits | €100-200 |
| First month supplies | €200-400 |
| **Minimum setup** | **€3,000-8,000** |

### Recommended Starting Fund

**Conservative estimate**:
- 3-6 months living expenses
- Plus setup costs
- **Total**: €10,000-20,000 depending on lifestyle

---

## Timeline Summary

| When | What |
|------|------|
| 3-6 months before | Visa application if needed |
| 1-2 months before | Book temporary housing |
| Week 1 | Arrive, get SIM, get NIF |
| Week 2-4 | Find apartment, sign contract |
| Month 2 | Utilities, bank, healthcare registration |
| Month 2-3 | Residence registration, social security |
| Month 3+ | Integration, Portuguese classes, building life |
