# Local Services & Setup in Lisbon

## The NIF: Your Portuguese Life Begins Here

### What is the NIF?
**Número de Identificação Fiscal** — Portuguese tax identification number. You need this for EVERYTHING:
- Opening bank account
- Signing rental contract
- Getting phone contract
- Setting up utilities
- Starting employment
- Buying property
- Even some hotel bookings

### How to Get NIF

**EU Citizens**:
- Go to any Finanças (tax office)
- Bring: Passport, proof of address (any document)
- Usually same-day
- Free

**Non-EU Citizens**:
Option 1: Finanças with Portuguese address
Option 2: Fiscal representative (if no address yet)

### The Catch-22 Problem

**You need NIF to rent an apartment, but need address to get NIF.**

**Solutions**:
1. **Fiscal representative service**: Companies provide address, get NIF for you (~€100-200)
2. **Use hotel/Airbnb address**: Some Finanças accept, not officially
3. **Have a Portuguese friend**: Can vouch for your address
4. **Do it from abroad**: Some consulates help

**Recommended services**:
- Bordr
- Anchorless
- Various law firms

### Finanças Offices

- **Main office**: Rua da Alfândega (Baixa)
- **Other branches**: Throughout city
- **Hours**: 9:00-15:30 weekdays
- **Pro tip**: Go early, expect queues

---

## Banking

### Opening an Account

**Requirements** (typically):
- NIF
- Passport/ID
- Proof of address
- Proof of income (sometimes)

**Ease by status**:
- EU citizens: Relatively easy
- Non-EU with proper visa: Manageable
- Non-EU without visa: Difficult

### Main Banks

| Bank | Type | Notes |
|------|------|-------|
| **Millennium BCP** | Traditional | Largest, good English support |
| **CGD (Caixa Geral)** | State-owned | Reliable, traditional |
| **Novo Banco** | Traditional | From former BES |
| **Santander Totta** | Spanish-owned | Similar to Spanish parent |
| **ActivoBank** | Digital-first | Easy opening, no fees |
| **Moey** | Fully digital | Easiest for foreigners |

### Digital-First Options

**For expats/digital nomads** (easier opening):
- **Moey**: Portuguese digital bank, easy process
- **Revolut**: Works for many purposes (not full Portuguese account)
- **N26**: Available in Portugal
- **Wise**: Multi-currency, useful

### Banking Costs

| Service | Typical Cost |
|---------|--------------|
| Monthly maintenance | €0-8 |
| Debit card | Often free |
| International transfer | €5-25 |
| ATM (Multibanco) | Free at own bank, €1-2 others |

### Multibanco ATMs

Portugal's ATM network is excellent:
- Can pay bills, utilities, taxes
- Top up phones
- Buy concert tickets
- Available everywhere
- Generally safe

---

## Phone & Internet

### Mobile Providers

| Provider | Network | Notes |
|----------|---------|-------|
| **NOS** | Own | Largest coverage |
| **Vodafone** | Own | Good coverage, popular |
| **MEO** | Own | Portugal Telecom legacy |
| **NOWO** | Uses NOS | Budget option |

### Prepaid SIM (Tourists/Short-term)

- Buy at airport, NOS/Vodafone/MEO stores
- €10-20 for card + data
- Example: NOS €15 = 5GB, 30 days
- Top up at any Multibanco or store
- No contract, passport needed

### Contract Plans

**Typical monthly costs**:
- Basic: €10-15/month
- Standard: €20-30/month
- Unlimited data: €30-50/month

**Requirements**:
- NIF
- Portuguese bank account
- ID
- 12-24 month contracts typical

### Home Internet

**Providers**: Same as mobile (NOS, Vodafone, MEO)

**Typical packages**:
- Fiber available in most of Lisbon
- €30-50/month for internet only
- Bundles (TV + internet + mobile): €50-80/month

**Reality**:
- Fiber is fast and reliable where available
- Some old buildings: DSL only
- Installation: 1-2 weeks typically

---

## Utilities

### Electricity (EDP, Galp, Endesa)

**Setup**:
- NIF required
- Contact provider online or phone
- Transfer existing contract or new
- First bill: deposit sometimes required

**Cost**: €40-100/month depending on usage

### Gas

**Piped gas** (Lisboagás distribution):
- Available in most buildings
- Same providers: EDP, Galp
- €20-50/month

**Bottled gas** (older buildings):
- Buy at supermarkets or delivered
- ~€25 per bottle, lasts 1-2 months

### Water (EPAL)

- Municipal monopoly
- Contact EPAL directly
- Setup requires NIF + rental contract
- €15-30/month typically

### Setting Up All Utilities

**If taking over existing apartment**:
1. Get readings from previous tenant
2. Call/online to transfer contracts
3. Provide NIF, rental contract, ID

**New connections**:
1. Contact each provider
2. Schedule installation/activation
3. Can take 1-2 weeks

---

## Postal Services

### CTT (Portuguese Post)

- Reliable national service
- Mail delivery: Daily except Sunday
- Tracking available
- Most post offices: Mon-Fri 9:00-18:00

### Receiving Packages

**Options**:
- Home delivery
- CTT pickup points (convenience stores)
- Amazon lockers (limited)
- Collect from post office

**Customs (from outside EU)**:
- VAT charged on items >€22
- Customs inspection possible
- Can cause delays

### Sending International

- EU: Standard mail €1-2
- International: €2-5+ depending on weight
- Express options available (more expensive)

---

## Healthcare Registration

### SNS (National Health Service)

**For residents**:
1. Get NIF
2. Register at local health center (Centro de Saúde)
3. Receive Número de Utente (healthcare number)
4. Access public healthcare

**What you need**:
- NIF
- Proof of residence
- ID/passport
- EU health card (if EU citizen)

### Finding Your Health Center

- Based on residential address
- Use SNS website to find assigned center
- Register in person

### EU Citizens (EHIC/GHIC)

- Temporary coverage with European card
- For tourists/short stays
- Full registration needed for long-term

---

## Transportation Registration

### Navegante Monthly Pass

**For regular users**:
1. Go to any metro station with photo capability
2. Bring ID
3. Get card with photo
4. Load monthly pass (€40 metropolitan)

**Renewal**: Online or Multibanco

### Getting Portuguese Drivers License

**EU licenses**: Valid indefinitely in Portugal

**Non-EU licenses**:
- Valid 185 days for residents
- Must exchange within that period
- Some countries have agreements (exchange without test)
- Others require full Portuguese test

**Process**:
- IMT (Instituto da Mobilidade e dos Transportes)
- NIF required
- Various documents
- Can be bureaucratic

---

## Essential Apps

| App | Purpose |
|-----|---------|
| **Moovit** | Public transport |
| **Uber/Bolt** | Rideshare |
| **MB Way** | Mobile payments (Portuguese bank needed) |
| **SNS 24** | Healthcare line, appointments |
| **IRS Portal** | Tax filing |
| **Idealista** | Housing search |
| **The Fork** | Restaurant reservations |
| **EMEL** | Parking |

### MB Way

**Portugal's mobile payment system**:
- Works with Portuguese bank account
- Pay in stores, transfer money
- Very widely used
- Sign up through bank app

---

## Government Services

### Citizen Shops (Lojas do Cidadão)

One-stop for multiple services:
- NIF
- Social security
- ID renewals
- Various registrations

**Locations**: Several in Lisbon (Laranjeiras, Restauradores, etc.)
**Pro tip**: Book online appointments when possible

### Online Portal (ePortugal)

- Digital citizen services
- Tax filing
- Certificate requests
- Various applications
- Digital signature available

### Bureaucracy Reality

**Expect**:
- Queues
- Multiple visits sometimes
- Portuguese language dominance
- Paper documents still common
- Patience required

**Tips**:
- Bring all possible documents
- Arrive early
- Book appointments when available
- Learn basic Portuguese phrases
- Hire a translator/lawyer for complex issues

---

## Portuguese Phrases for Services

| Situation | Portuguese |
|-----------|------------|
| I need to get a NIF | Preciso de obter um NIF |
| Where do I register? | Onde é que me registo? |
| Do you speak English? | Fala inglês? |
| I need a receipt | Preciso de um recibo |
| Can I pay by card? | Posso pagar com cartão? |
| Where do I sign? | Onde assino? |
| What documents do I need? | Que documentos preciso? |
| I don't understand | Não compreendo |

---

## Laundry & Home Services

### Laundromats

- Less common than some countries
- Most Portuguese have washing machines
- "Lavandaria" = laundry
- Self-service: €4-8 per load
- Full service: €10-20

### Dry Cleaning

- "Lavandaria/Limpeza a seco"
- Available in most neighborhoods
- Prices comparable to other EU countries

### Home Cleaning

- Cleaning services: €10-15/hour
- Platforms: Zaask, GetNinjas
- Word of mouth common
- Many informal (cash) arrangements

### Repairs

- "Canalizador" = plumber
- "Electricista" = electrician
- "Carpinteiro" = carpenter
- Finding reliable: Ask neighbors, building manager
- Platforms: Zaask, Fixando

---

## Recycling & Waste

### Ecopontos (Recycling Bins)

Color-coded bins throughout city:
- **Yellow**: Plastic, metal
- **Blue**: Paper, cardboard
- **Green**: Glass
- **Grey/Black**: General waste

### Collection

- General waste: Regular collection
- Recycling: Bring to ecopontos
- Large items: Schedule with Câmara Municipal

### Composting

- Growing but limited
- Some neighborhoods have programs
- Check with Junta de Freguesia
