# Healthcare in Lisbon

## System Overview

Portugal has a **dual healthcare system**:
- **SNS (Serviço Nacional de Saúde)**: Public, universal
- **Private sector**: Faster access, higher cost

### Quality Assessment

**Public (SNS)**:
- Good emergency care
- Quality varies by facility
- Long waits for specialists
- Underfunded but competent
- Improving but strained

**Private**:
- Excellent quality
- Fast access
- English widely spoken
- International standards
- Cost is main barrier

---

## Public Healthcare (SNS)

### Who's Covered

| Status | Coverage |
|--------|----------|
| Portuguese citizens | Full |
| EU citizens (with EHIC/GHIC) | Emergency + temporary |
| EU citizens (registered residents) | Full |
| Legal residents (non-EU) | Full (after registration) |
| Undocumented | Emergency only |

### Getting Registered

**For residents**:
1. Get NIF (tax number)
2. Go to your local Centro de Saúde
3. Bring: ID, proof of residence, NIF
4. Register and get **Número de Utente**
5. Assigned a family doctor (médico de família)

**Timeline**: Registration itself is quick; getting family doctor may take months.

### Taxas Moderadoras

Small co-pays for public services:

| Service | Cost |
|---------|------|
| GP consultation | €5 |
| Specialist consultation | €7-15 |
| Hospital emergency | €15-20 |
| Various tests | €2-10 |

**Exemptions**: Low income, chronic conditions, pregnancy, children, over 65

### Finding Your Health Center

- Based on your registered address
- Use SNS website or 808 200 204
- Centro de Saúde for primary care
- Hospital for emergencies/specialists

### Emergency Care

**Hospital emergencies**:
- Open 24/7
- Triage by severity
- Can have very long waits for non-urgent
- Quality is good for genuine emergencies

**When to go**:
- Genuine emergencies
- After-hours when Centro de Saúde closed
- Referred by GP

---

## Private Healthcare

### Why Go Private

- **Speed**: See specialists in days, not months
- **English**: More common in private
- **Facilities**: Often more modern
- **Comfort**: Shorter waits, nicer environment
- **Choice**: Select your doctor

### Major Private Hospital Groups

| Group | Hospitals | Notes |
|-------|-----------|-------|
| **CUF** | Multiple | Largest private group |
| **Luz Saúde** | Hospital da Luz, others | High quality |
| **Lusíadas** | Several locations | Comprehensive |
| **SAMS** | Various | Some public access |
| **British Hospital** | Estrela | Historic, English-speaking |

### Consultation Costs

| Service | Cost |
|---------|------|
| GP consultation | €50-100 |
| Specialist | €70-150 |
| Blood tests | €50-150 |
| X-ray | €30-80 |
| MRI | €200-400 |
| Minor procedure | €200-500 |

### Private Without Insurance

**Pay-as-you-go**:
- Works well for occasional use
- Ask prices upfront
- Often cheaper than you expect
- Some offer packages

---

## Health Insurance

### Do You Need It?

| Situation | Insurance Recommendation |
|-----------|-------------------------|
| EU with EHIC, short stay | EHIC sufficient |
| Long-term resident | SNS + optional private supplement |
| Non-EU, D7/D8 visa | Required for visa, good to maintain |
| Employed | Often included in benefits |
| Self-employed | Strongly recommended |

### Private Insurance Options

**Portuguese insurers**:
- **Médis** (Ageas)
- **Multicare** (Fidelidade)
- **Allianz**
- **Tranquilidade**
- **MGEN**

**Typical costs**:
- Basic: €50-80/month
- Comprehensive: €100-200/month
- Family plans: €150-400/month

**What's covered**:
- Private consultations
- Diagnostic tests
- Hospital admission
- Dental (sometimes)
- Optical (sometimes)

### International Insurance

**Digital nomad options**:
- **SafetyWing**: €40-80/month, travel-focused
- **World Nomads**: Travel insurance
- **Cigna Global**: Comprehensive international

**Important**: For visa applications, insurance must meet specific requirements.

---

## Finding Doctors

### Finding a GP

**Public (médico de família)**:
- Assigned when you register at Centro de Saúde
- Can request change if unhappy
- Availability varies

**Private GP**:
- Search through insurance network
- Hospital groups have GP services
- Ask expat community for recommendations

### English-Speaking Doctors

**Where to find**:
- Private hospitals (ask for English speakers)
- British Hospital
- CUF and Luz usually have English
- Expat forums (recommendations)

**Online resources**:
- Hospital websites list doctor languages
- Doctoranytime.com
- Insurance company directories

### Specialists

**Via public system**:
1. GP refers you
2. Hospital assigns appointment
3. Wait can be months

**Via private**:
1. Book directly or through GP
2. Appointment within days/weeks
3. Pay out of pocket or with insurance

---

## Pharmacies

### How They Work

- **Green cross** sign
- Pharmacists can advise on minor issues
- Many medications available without prescription
- Prescription needed for antibiotics, controlled substances
- Most open: 9:00-13:00, 15:00-19:00

### Night/Weekend Pharmacies

**Farmácias de serviço**:
- Rotating 24-hour pharmacies
- Posted on pharmacy doors
- Online: farmaciaservico.net
- Phone: 808 202 134

### Medication Costs

- Generally reasonable
- Generic alternatives usually available
- Some medications cheaper than other EU countries

---

## Dental Care

### Not Well Covered

**SNS dental**: Very limited
- Mostly extractions
- Long waits
- Basic care only

**Private dental**: Standard for most needs
- Cleaning: €50-80
- Filling: €50-100
- Root canal: €150-400
- Crown: €300-600
- Implant: €800-1,500

### Dental Tourism

Portugal is actually a destination for dental tourism:
- Quality good
- Prices lower than UK/US/Northern Europe
- Many dentists speak English

---

## Mental Health

### Growing Awareness

Mental health services are improving:
- SNS has psychiatry/psychology services
- Long waits for public
- Private: Better access

### Options

**Public**:
- Centro de Saúde can refer
- Hospital psychiatry departments
- Community mental health teams

**Private**:
- Psychologists: €50-100/session
- Psychiatrists: €100-150/session
- Many English-speaking practitioners

**Crisis**:
- SOS Voz Amiga: 213 544 545
- Hospital emergency for acute crises

---

## Pregnancy & Childbirth

### Prenatal Care

**Public (SNS)**:
- Good quality
- All standard tests included
- Hospital delivery
- Long waits for some appointments

**Private**:
- More choice
- Same doctor throughout
- Private or semi-private room
- Higher cost (€3,000-8,000 for delivery)

### Hospital Birth

Most births are hospital-based:
- Public hospitals: Good quality
- Private: CUF Descobertas, Hospital da Luz popular
- Epidural available
- C-section rates debated

### Maternity Leave

**For employees**:
- 120-180 days paid leave
- Shared between parents possible
- Protected employment

---

## COVID-19 & Vaccinations

### Current Status (2026)

- Largely normalized
- No travel restrictions
- Masks may be advised in healthcare settings
- Check current guidelines before travel

### Vaccinations Available

**Through SNS**:
- Childhood vaccines (PNV schedule)
- COVID-19
- Flu (seasonal)
- HPV
- Others as needed

**Through private/travel clinics**:
- Travel vaccines
- Faster access
- Yellow fever, typhoid, etc.

---

## Practical Tips

### What to Bring

**From home**:
- Copies of medical records
- Prescription medications (with letter)
- Glasses/contacts prescription
- Health insurance documents

### In Case of Emergency

1. **Call 112** for ambulance
2. Go to nearest hospital urgência (emergency)
3. Bring ID and health card
4. Be prepared for triage wait

### Non-Emergency Care

1. **Centro de Saúde** for GP needs
2. **SNS 24 (808 24 24 24)**: Health line for advice
3. **Pharmacy** for minor issues
4. **Private clinic** for speed

### Useful Contacts

| Service | Number/Website |
|---------|----------------|
| Emergency | 112 |
| SNS 24 (health line) | 808 24 24 24 |
| Night pharmacy | 808 202 134 |
| INEM (emergencies) | 112 |

---

## Comparison: Public vs Private

| Factor | Public (SNS) | Private |
|--------|--------------|---------|
| Cost | €0-20 per visit | €50-150+ |
| Wait times | Long for specialists | Short |
| English | Variable | Usually available |
| Quality | Good for emergencies | Excellent |
| Choice | Limited | Full |
| Best for | Routine, emergencies | Speed, specialists |

### Recommended Strategy

**Most expats**:
1. Register with SNS (free, good for emergencies)
2. Get private insurance (reasonable cost)
3. Use private for specialists/non-urgent
4. Use public for emergencies, long-term conditions

This hybrid approach maximizes value and access.
