# Practical Food Guide: Dietary, Cultural & Logistics

## Dietary Accommodations

### Vegetarian

**Situation**: Portugal is traditionally meat/fish-heavy, but Lisbon has adapted significantly.

**What works**:
- Dedicated vegetarian restaurants (see list below)
- Brunch spots (nearly all have vegetarian options)
- Indian, Asian, Middle Eastern restaurants
- Petiscos/tapas style (choose veggie items)
- Salads, omelettes, vegetable sides at tascas

**What doesn't**:
- Many traditional soups contain meat
- "Vegetable" dishes may have pork stock
- Caldo verde usually has chouriço
- Some beans are cooked with meat

**Key phrase**: "Sou vegetariano/a. Isto tem carne ou peixe?" (I'm vegetarian. Does this have meat or fish?)

**Top vegetarian restaurants**:
- **The Green Affair** (Príncipe Real) — Upscale plant-based
- **Ao 26** (Bairro Alto) — Vegan institution
- **PSI** (Príncipe Real) — Vegan Portuguese
- **Jardim das Cerejas** (Príncipe Real) — Vegetarian
- **Vegana by Tentúgal** (Intendente) — Vegan pastries

### Vegan

**Harder than vegetarian** but growing rapidly:
- Fewer dedicated restaurants than major European cities
- BUT the ones that exist are good quality
- Brunch spots increasingly vegan-friendly
- Fine dining accommodates with notice

**Watch out for**:
- Eggs in pastries
- Butter everywhere
- Stock in soups/rice
- Honey in desserts

**Key phrase**: "Sou vegan. Isto tem algum produto animal—ovos, leite, manteiga?" (I'm vegan. Does this have any animal products—eggs, milk, butter?)

**Resources**: Happy Cow app works well in Lisbon

### Gluten-Free

**Situation**: Traditional Portuguese cuisine is bread-heavy. But awareness is growing.

**Easy wins**:
- Grilled fish (naturally GF)
- Rice dishes (common in Portugal)
- Salads
- GF pastries at dedicated shops
- Fine dining (always accommodates)

**Watch out for**:
- Couvert bread (can decline)
- Breaded items (rissóis, croquetes, pataniscas)
- Some sauces
- Cross-contamination

**Key phrase**: "Sou celíaco/a. Isto tem glúten?" (I'm celiac. Does this have gluten?)

**Resources**:
- **Celeiro** (Baixa) — Health food store + café
- **Various specialty bakeries** — Growing options
- Most brunch spots have GF bread options

### Halal

**Options exist** thanks to Mouraria's Muslim community:
- Halal butchers in Mouraria/Martim Moniz
- Middle Eastern restaurants
- Turkish/Lebanese options
- Some chicken/fish restaurants work

**Key phrase**: "Isto é halal?" (Is this halal?)

**Note**: Few mainstream restaurants labeled halal. Best to cook or eat at halal establishments.

### Kosher

**Limited options**:
- Small Jewish community
- Contact Comunidade Israelita de Lisboa for recommendations
- Some restaurants will work with advance notice
- Kosher products at specialty stores

### Nut Allergies

**Take seriously**: Portuguese pastries often contain almonds.

**Common nut use**:
- Almond in pastries, cakes
- Walnut in traditional sweets
- Pine nuts in some dishes
- Peanuts less common

**Key phrase**: "Sou alérgico/a a nozes. Isto tem frutos secos?" (I'm allergic to nuts. Does this have tree nuts?)

### Shellfish Allergies

**Important**: Shellfish is everywhere in Portuguese cuisine.

**Watch out for**:
- Stocks and bases
- Rice dishes (may have shellfish stock)
- Mixed seafood dishes
- Cross-contamination in cervejarias

**Key phrase**: "Sou alérgico/a a marisco." (I'm allergic to shellfish.)

---

## The Couvert Situation

**What it is**: Bread, butter, olives, cheese, pâté, etc. brought automatically to table.

**Rules**:
1. **Not free** — You pay for what you eat (€3-8 typically)
2. **Can decline** — "Não obrigado" when brought
3. **Return untouched** — They take back what you don't open
4. **Tourist trap version** — Elaborate spreads costing €15+
5. **Always ask price** — If it looks fancy

**Strategy**:
- At tascas: Usually just bread/butter, reasonable
- At tourist spots: Decline if elaborate
- At fine dining: Usually included in experience

---

## Tipping & Payment

### Tipping Culture

**Portugal is NOT a tipping culture like US**:
- Service included in prices
- Not expected, but appreciated
- 5-10% for good service at restaurants
- Round up at cafés
- Don't feel obligated

**How to tip**:
- Cash on table when leaving
- Card tips less common
- Some machines ask—feel free to skip

### Payment Methods

**Accepted**:
- Multibanco (Portuguese debit cards)
- Visa, Mastercard widely accepted
- Contactless very common
- Apple Pay, Google Pay at many places

**Cash still useful for**:
- Small tascas
- Market stalls
- Tips
- Some traditional places

**Not accepted**: American Express (rarely)

---

## Restaurant Hours

### Typical Hours

| Meal | Open | Kitchen Closes |
|------|------|----------------|
| Breakfast | 8:00 | 11:00 |
| Lunch | 12:30 | 15:00 |
| Dinner | 19:30 | 22:30 |

### Important Notes

- **Don't arrive for dinner at 18:00** — Nothing open
- **Lunch ends sharply** — Kitchen closes at 15:00
- **Weekends**: Brunch runs 10:00-15:00 at popular spots
- **Sunday dinner**: Many places closed
- **Monday**: Many restaurants closed (rest day)
- **August**: Many close for vacation

### Late Night Eating

After midnight, options:
- Bairro Alto bars with food
- Cais do Sodré late-night spots
- 24h places near nightlife
- Bifana/prego stands

---

## Seasonal & Festival Food

### Santo António (June 12-13)
**The big one**:
- Sardines EVERYWHERE
- Street parties in Alfama
- Grilled sardines on bread
- Eat standing in the street
- Book restaurants weeks ahead (or embrace street food)

### Christmas Season
- **Bolo Rei** — Fruit cake, traditional
- **Rabanadas** — Portuguese French toast
- **Sonhos** — Fried dough balls
- **Bacalhau** — Cod on Christmas Eve
- Family-focused; many restaurants closed Dec 24-25

### Easter
- **Folar** — Sweet or savory bread
- **Amêndoas** — Sugar-coated almonds
- Many restaurants closed Easter Sunday

### New Year's Eve
- Raisins at midnight (12 for luck)
- Restaurants often have set menus (expensive)
- Book well ahead

---

## Grocery Shopping

### Major Chains

| Chain | Level | Where |
|-------|-------|-------|
| **Pingo Doce** | Mid-range | Everywhere |
| **Continente** | Mid-range | Many locations |
| **Lidl** | Budget | Suburban mainly |
| **Aldi** | Budget | Growing presence |
| **El Corte Inglés** | Upscale | Chiado basement |
| **Jumbo** | Hypermarket | Colombo, outskirts |

### Mini Markets
- **Mini Preço** — Small convenience stores
- **Many neighborhood shops** — Higher prices, convenience
- **Open late** — Useful for forgotten items

### Specialty Stores

**Health/Organic**:
- **Celeiro** (Baixa) — Health food
- **Miosótis** (Príncipe Real) — Organic
- **Go Natural** (various) — Organic chain

**Gourmet**:
- **Manteigaria Silva** (Baixa) — Traditional Portuguese products
- **Conserveira de Lisboa** — Canned fish paradise
- **Charcutaria Lisboa** — Charcuterie specialist

### Market Shopping

**For fresh produce, fish, meat**:
- **Mercado da Ribeira** (upstairs) — Early morning
- **Mercado de Arroios** — Local, mornings
- **Mercado de Campo de Ourique** — Local favorite

---

## Drinking Culture

### Coffee

**Standard orders**:
- **Café** — Espresso, the default
- **Bica** — Same as café (Lisbon term)
- **Galão** — Weak latte in a tall glass
- **Meia de leite** — Coffee with milk (stronger than galão)
- **Carioca** — Weak espresso
- **Abatanado** — Long black/Americano style

**Culture notes**:
- Standing at bar = cheaper
- After meals, café only (never cappuccino)
- Coffee is cheap: €0.70-1.20 for espresso
- Order at counter, pay after

### Alcohol

**Wine with meals**: The norm. House wine is typically good and cheap (€2-4/glass).

**Beer**: Sagres vs Super Bock rivalry. Ask for:
- **Imperial** — Draft lager (Lisbon term)
- **Fino** — Same thing (Porto term)
- **Caneca** — Larger glass

**Spirits**:
- **Ginjinha** — Sour cherry liqueur, Lisbon specialty
- **Licor Beirão** — Herbal liqueur
- **Aguardente** — Brandy/firewater

**Legal notes**:
- Drinking age: 18
- Public drinking: Generally tolerated
- Drunk driving: Zero tolerance

---

## Food Safety

**Generally excellent**:
- EU standards apply
- Fresh seafood handled well
- Tap water safe everywhere

**Standard precautions**:
- Check seafood freshness (smell test)
- Busy restaurants = fresher food
- Buffets can be risky if food sits
- Street food is generally safe

---

## For Parents with Kids

### Kid-Friendly Restaurants
- **Time Out Market** — Options for everyone
- **Most pizzerias** — Universal kid appeal
- **Oceanário restaurant** — After aquarium visit
- **Landeau** — Chocolate cake solves everything
- **Brunch spots** — Generally welcoming

### Kids Menu Reality
- Not always available
- Half portions ("meia dose") usually possible
- Traditional Portuguese = large portions, can share
- Pasta/pizza always available

### Eating Early
- Challenging—most restaurants open dinner 19:30
- Hotel restaurants often more flexible
- Pizza places may accommodate
- Eating at food halls works (no set hours)
