# Portuguese Cuisine Guide

## The Holy Trinity: Bacalhau, Sardines, Grilled Fish

### Bacalhau (Salt Cod)
Portugal's national dish—allegedly 365 ways to prepare it, one for each day.

**Why salt cod?**: Portuguese fishermen preserved Atlantic cod for long voyages. It became the default protein, even though fresh fish abounds.

**Essential preparations**:

| Dish | Description | Where to Try |
|------|-------------|--------------|
| **Bacalhau à Brás** | Shredded cod with matchstick potatoes, eggs, olives | Any tasca—it's everywhere |
| **Bacalhau com Natas** | Creamy baked cod with potatoes | Classic comfort food |
| **Bacalhau à Gomes de Sá** | Baked with potatoes, onions, eggs, olives | Traditional, Porto-style |
| **Bacalhau à Lagareiro** | Roasted whole with olive oil, garlic | For purists |
| **Pastéis de Bacalhau** | Fried cod croquettes | Every bar, pastelaria |
| **Bacalhau Espiritual** | Fluffy, soufflé-like baked dish | Special occasions |

**Pro tip**: Good bacalhau should be flaky, not stringy. If it's tough, kitchen failed.

### Sardinhas (Sardines)
Portugal's summer food, especially during June festivals.

**Season**: June-September (peak flavor)

**The ritual**:
- Charcoal grilled whole
- Served on bread (to catch juices)
- Eaten with hands
- Head and tail removed, spine pulled out
- Paired with grilled peppers (pimentos)

**Where**: Any tasca June-August, or street during Santo António (June 12-13)

**Reality check**: Off-season sardines exist but lack flavor. Don't order in December.

### Fresh Grilled Fish
Portugal's true strength—simply prepared, incredibly fresh.

**What to order**:
- **Robalo (Sea Bass)**: Delicate, premium price
- **Dourada (Sea Bream)**: Classic, reliable
- **Pargo (Red Snapper)**: Firm, flavorful
- **Pregado (Turbot)**: Luxurious, expensive
- **Linguado (Sole)**: Classic, pan-fried often
- **Peixe-espada (Black Scabbardfish)**: Distinctive, Madeiran specialty

**Ordering fish**:
- Often sold by weight (per kg)
- 300-400g per person typical
- Ask price before ordering: "Quanto custa o quilo?"
- Grilled (grelhado) is standard preparation

---

## Shellfish & Seafood

### The Cervejaria Experience
Beer halls specializing in shellfish—peak Lisbon food culture.

**What to order**:

| Shellfish | Portuguese | Notes |
|-----------|------------|-------|
| Prawns | Gambas | Size varies: camarão (small) to gamba gigante |
| Langoustines | Lagostim | Essential, expensive |
| Crab | Sapateira | Spider crab is traditional |
| Clams | Amêijoas | Often à Bulhão Pato (garlic, coriander) |
| Razor Clams | Lingueirão | Grilled or sautéed |
| Percebes | Percebes | Gooseneck barnacles—acquired taste, expensive |
| Lobster | Lagosta | Ultimate splurge |

**Price warning**: Shellfish is sold by weight and can escalate quickly. €50-80/person is normal at good cervejarias.

**Top cervejarias**:
- **Cervejaria Ramiro** (Intendente) — Most famous, worth the queue
- **Cervejaria Trindade** (Chiado) — Historic, touristy but good
- **Marisqueira M** (Cais do Sodré) — Modern, pricier
- **Pinóquio** (Rossio) — Classic, less hype than Ramiro

### Percebes
Special mention: gooseneck barnacles are Portugal's strangest delicacy.
- Harvested from dangerous cliffs
- Look alien, taste of pure ocean
- Very expensive (€30-50/plate)
- Twist and pull to eat
- Seasonal (spring best)

---

## Meat Dishes

### Pork
Portugal's most common meat—multiple preparations:

| Dish | Description |
|------|-------------|
| **Leitão** | Suckling pig, roasted. Bairrada region specialty. |
| **Carne de Porco Alentejana** | Pork with clams—surf and turf, Alentejo style |
| **Bifana** | Pork steak sandwich, very thin, garlicky |
| **Presunto** | Dry-cured ham (like jamón, different cure) |
| **Torresmos** | Pork cracklings |

### Beef & Veal
Less dominant but present:

| Dish | Description |
|------|-------------|
| **Prego** | Steak sandwich—beef in bread with mustard |
| **Bife à Portuguesa** | Steak with fried egg, Portuguese style |
| **Bitoque** | Thin steak with egg, chips, rice—diner classic |
| **Vitela** | Veal, various preparations |

### Cozido à Portuguesa
The full Portuguese boiled dinner:
- Multiple meats (beef, pork, chicken, sausages)
- Vegetables (cabbage, turnips, carrots, potatoes)
- Everything cooked in one pot
- Winter dish, hearty
- Family-style serving

### Francesinha
Not Lisbon—it's from Porto. But worth mentioning:
- Sandwich layered with meats, covered in cheese and sauce
- Deeply indulgent, borderline obscene
- Try it in Porto, not Lisbon

---

## Petiscos (Portuguese Tapas)

Small plates, often served at bars and modern tabernas:

| Petisco | Description |
|---------|-------------|
| **Pica-pau** | Cubed pork or beef in garlic sauce with pickles |
| **Moelas** | Chicken gizzards in garlic—acquired taste |
| **Alheiras** | Sausage (originally Jewish, game meat) |
| **Pataniscas** | Cod fritters |
| **Pimentos de Padrón** | Grilled peppers (some hot!) |
| **Salada de polvo** | Octopus salad |
| **Azeitonas** | Olives (always good) |
| **Queijo** | Cheese—try Queijo da Serra |

---

## Soups

### Caldo Verde
The national soup:
- Potato-based broth
- Kale (couve galega) shredded thin
- Slice of chouriço
- Drizzle of olive oil
- Simple, comforting, everywhere

### Açorda
Bread soup with coriander, garlic, eggs—Alentejo origin. Rich, hearty.

### Sopa de Pedra
"Stone soup"—from Almeirim. Beans, meat, vegetables. From the folk tale.

### Gazpacho (Alentejo style)
Cold bread soup, different from Spanish version.

---

## Pastries & Sweets

### The Pastel de Nata
Portugal's greatest export after people.

**What it is**: Custard tart with crispy puff pastry, caramelized top.

**The debate**: 
- "Pastel de Belém" = only from Pastéis de Belém (secret recipe since 1837)
- "Pastel de nata" = everywhere else
- Both delicious; Belém's has specific character worth trying

**Where to get the best**:
- **Pastéis de Belém**: The original, worth the experience
- **Manteigaria**: Modern, excellent, multiple locations
- **Pastelaria Batalha**: Old-school Lisbon
- **Aloma**: Hidden gem

**How to eat**: Warm, sprinkled with cinnamon and powdered sugar. Fresh from oven = best.

### Other Essential Pastries

| Sweet | Description |
|-------|-------------|
| **Travesseiro** | Sintra specialty—almond pillow pastry |
| **Queijada** | Sintra cheese tart, dense |
| **Bola de Berlim** | Cream-filled Portuguese doughnut |
| **Jesuíta** | Flaky pastry with royal icing |
| **Pastel de Feijão** | Bean paste pastry |
| **Toucinho do Céu** | "Bacon from heaven" — almond cake |
| **Arroz doce** | Rice pudding with cinnamon |

### Convent Sweets
Many Portuguese sweets originated in convents (nuns used egg yolks after whites were used to starch habits):
- Barriga de freira ("nun's belly")
- Papos de anjo ("angel's double chin")
- Toucinho do céu ("bacon from heaven")

---

## Cheese & Charcuterie

### Portuguese Cheeses

| Cheese | Region | Notes |
|--------|--------|-------|
| **Queijo da Serra** | Serra da Estrela | Creamy sheep cheese, DOP protected |
| **São Jorge** | Azores | Aged cow's milk, semi-hard |
| **Azeitão** | Setúbal | Small, soft, runny when ripe |
| **Serpa** | Alentejo | Raw sheep's milk, strong |
| **Nisa** | Alentejo | Semi-soft, mild |

### Charcuterie

| Product | Description |
|---------|-------------|
| **Presunto** | Dry-cured ham, different from Spanish jamón |
| **Chouriço** | Smoked pork sausage, paprika-heavy |
| **Morcela** | Blood sausage |
| **Farinheira** | Bread-based sausage |
| **Salpicão** | Cured loin |

---

## Drinks with Food

### Wine
- **Vinho Verde**: Light, slightly fizzy, white or red. Perfect with fish.
- **Douro reds**: Full-bodied, pair with meat
- **Alentejo**: Both colors, good value
- **Setúbal Moscatel**: Dessert wine, with pastries

### Beer
- **Sagres** and **Super Bock**: The two national lagers
- **Imperial/Fino**: Draft beer (different names in different cities)
- Growing craft scene: Dois Corvos, Musa, Lince

### After Dinner
- **Ginjinha**: Sour cherry liqueur. Lisbon classic. Try at A Ginjinha (Rossio).
- **Aguardente**: Portuguese brandy, fiery
- **Licor Beirão**: Herbal liqueur
- **Café**: Essential after every meal (espresso by default)

---

## Where to Experience Each

| Dish Type | Best Neighborhood | Top Pick |
|-----------|-------------------|----------|
| Bacalhau | Mouraria, any tasca | Casa do Alentejo |
| Grilled fish | Alfama, Belém | Ponto Final (Cacilhas ferry) |
| Shellfish | Intendente | Cervejaria Ramiro |
| Petiscos | Santos, Chiado | Taberna da Rua das Flores |
| Cozido | Mouraria | O Velho Eurico (winter) |
| Pastéis de nata | Belém | Pastéis de Belém |
| Modern Portuguese | Chiado | Belcanto |
