# International & Fine Dining in Lisbon

## Lisbon's Culinary Evolution

Lisbon's food scene has transformed dramatically since 2010. What was once a city of traditional tascas now offers world-class dining across cuisines. The catalyst: tourism boom, Web Summit influx, and young Portuguese chefs returning from abroad.

## Fine Dining

### Michelin-Starred Restaurants (2026)

**Two Stars**
- **Belcanto** (Chiado) — José Avillez's flagship. Modern Portuguese taken to extremes. Tasting menus €180-250. Book weeks ahead.

**One Star**
- **Alma** (Chiado) — Henrique Sá Pessoa. Refined Portuguese with global techniques. €120-180.
- **Feitoria** (Belém, Altis hotel) — River views, seafood focus. €100-150.
- **Eleven** (Parque Eduardo VII) — Long-standing, classic fine dining. Views. €100-150.
- **Loco** (Príncipe Real) — Alexandre Silva. Creative, seasonal. €90-130.

**Recent additions**: Scene evolves yearly. Check current Michelin guide.

### High-End Portuguese (Non-Starred)

- **Prado** (Baixa) — Farm-to-table, ingredient-driven. €60-90.
- **A Cevicheria** (Príncipe Real) — Portuguese-Peruvian. Excellent ceviche. €40-60.
- **100 Maneiras** (Bairro Alto) — Ljubomir Stanisic. Creative tasting. €70-100.
- **Mini Bar** (Chiado) — José Avillez's playful small plates. €50-80.

### Upscale Seafood

Beyond cervejarias:
- **Sea Me** (Chiado) — Peixaria meets restaurant. €50-80.
- **Can the Can** (Cais do Sodré) — Canned fish elevated. €40-60.
- **O Velho Eurico** (Mouraria) — High-end traditional. €40-70.

---

## International Cuisines

### Asian

**Japanese**
- **Tasca do Chico** — Wait, wrong Chico. **Kanazawa** (Príncipe Real) — Omakase, excellent. €80-150.
- **Yakuza by Olivier** (Santos) — Japanese-influenced. €50-80.
- **Tomo** (various) — Solid everyday Japanese. €20-35.
- **Udon House** (various) — Quick udon fix. €10-15.

**Chinese**
- **Deli Gao** (Mouraria) — Authentic Cantonese in Chinatown. €15-25.
- **China Grill** (Martim Moniz) — Local favorite. €12-20.
- **Various in Martim Moniz area** — Explore for authentic (and cheap)

**Thai**
- **Distrito Thai** (various) — Consistent Thai chain. €15-25.
- **Banana Café** (Príncipe Real) — Pan-Asian, Thai emphasis. €20-35.

**Vietnamese**
- **Pho 99** (Mouraria) — Good pho. €10-15.
- **Growing options** — Check current scene

**Indian**
- **Tasquinha do Lagarto** (Mouraria) — Indo-Portuguese. €15-25.
- **Various in Mouraria** — Explore, quality varies

**Korean**
- **Soyo** (various) — Korean fusion. €20-30.
- Limited authentic options

### Middle Eastern & Mediterranean

**Lebanese**
- **Al Mandari** (various) — Solid Lebanese. €20-35.
- **Mezze** (Príncipe Real) — Upscale mezze plates. €30-45.

**Turkish**
- **Café Istanbul** (Intendente) — Authentic kebabs. €15-25.

**Israeli/Jewish**
- **Limited options** — The scene is growing but small

### African

**Mozambican/Lusophone African**
- **Cantinho do Aziz** (Mouraria) — Mozambican classics. €15-25.
- **Associação Cabo-Verdiana** (Arroios) — Cape Verdean home cooking. €10-20.

**Brazilian**
- **Brasil à Mesa** (various) — Solid Brazilian. €20-35.
- **Boteco** (Cais do Sodré) — Brazilian bar/food. €15-25.
- Multiple churrascarias throughout city

### European

**Italian**
- **Mercantina** (Príncipe Real) — Excellent pizza. €15-25.
- **Pizzeria Romana Al Taglio** (various) — Roman-style pizza by weight. €8-15.
- **Osteria** (Chiado) — Proper Italian. €35-50.
- Quality varies wildly—many tourist traps

**French**
- **Pois Café** (Alfama) — French-leaning brunch spot. €15-25.
- **Café de São Bento** (São Bento) — Steak frites institution. €30-50.
- **Le Petit Bistro** (Príncipe Real) — Classic French. €30-45.

**Spanish**
- Less presence than you'd expect given proximity
- **Tapisco** (Príncipe Real) — Spanish-Portuguese tapas. €30-45.

### American & Burgers

- **Honorato** (various) — Portugal's best burger chain. €12-18.
- **Burger Factory** (various) — Solid option. €12-16.
- **Ground Burger** (Príncipe Real) — Craft burgers. €15-20.
- **Shake Shack** — Arrived 2024. Airport, Colombo.

### Mexican & Latin American

- **Pistola y Corazón** (Cais do Sodré) — Tacos, mezcal, fun. €25-40.
- **The Mexican** (various) — Basic but serviceable. €15-25.
- **Clandestino** (various) — Mexican street food. €12-20.
- **A Cevicheria** (see above) — Peruvian-Portuguese. €40-60.

---

## Brunch Culture

Brunch is a Portuguese adoption from the expat wave. Now well-established:

### Top Brunch Spots

| Restaurant | Location | Style | Price |
|------------|----------|-------|-------|
| **Copenhagen Coffee Lab** | Príncipe Real, Chiado | Scandi-minimal, excellent coffee | €12-20 |
| **Heim Café** | Intendente | German-Portuguese fusion | €12-18 |
| **Fauna & Flora** | Príncipe Real | Healthy, inventive | €15-22 |
| **The Mill** | Príncipe Real | American-style, pancakes | €15-22 |
| **Nicolau** | Baixa | Classic, busy | €12-18 |
| **Café da Garagem** | São Jorge Castle | Views, queue | €12-18 |
| **Landeau** | Multiple | Chocolate cake required | €10-15 |
| **Hello, Kristof** | Santos | Eclectic, great décor | €15-22 |
| **Comoba** | Alcântara | Near LX Factory | €12-18 |

**Weekend warning**: Popular spots queue from 11:00. Arrive early or go weekday.

---

## Coffee Culture

### Third Wave Coffee

Lisbon embraced specialty coffee:

**Best Third Wave Spots**
- **Copenhagen Coffee Lab** — The original Lisbon specialty coffee
- **Fabrica Coffee Roasters** — Excellent, multiple locations
- **Dear Breakfast** — Coffee + food
- **The Mill** — Australian-style
- **Wish Coffee** — Small, passionate
- **O Pequeno** — Cozy, quality

**Traditional Portuguese Coffee**
Don't neglect the galão (large, milky) at traditional pastelarias—different experience, culturally essential.

---

## Food Halls & Markets

### Time Out Market (Mercado da Ribeira)
- Location: Cais do Sodré
- What: Best-of vendors (Honorato, Sea Me, Manteigaria)
- Price: Higher than neighborhood spots
- Atmosphere: Crowded, communal tables
- Best for: Sampling, tourists, groups

### Mercado de Campo de Ourique
- Location: Campo de Ourique
- What: Similar concept, more local
- Price: Reasonable
- Atmosphere: Less crowded
- Best for: Locals, neighborhood feel

### Mercado de Arroios (Mercado Fuso)
- Location: Arroios
- What: Traditional market with food stalls
- Price: Budget-friendly
- Best for: Authentic experience

---

## Dietary-Specific Options

### Vegetarian & Vegan

**Dedicated Vegetarian/Vegan**
- **The Green Affair** (Príncipe Real) — Plant-based fine dining. €35-50.
- **Ao 26** (Bairro Alto) — Vegan institution. €15-25.
- **PSI** (Príncipe Real) — Vegan Portuguese. €15-25.
- **Jardim das Cerejas** (Príncipe Real) — Vegetarian. €12-20.
- **Vegana by Tentúgal** (Intendente) — Vegan pastries.

**Good Veggie Options (Not Exclusively)**
- Most brunch spots have vegetarian options
- Indian/Asian restaurants work well
- Modern Portuguese increasingly accommodates

### Gluten-Free

- **Celeiro** (Baixa) — Health food store with café
- **Most brunch spots** — Offer GF options
- **Fine dining** — Accommodates with notice
- **Traditional tascas** — Challenging (bread everywhere)

---

## Delivery Apps

- **Uber Eats** — Widest selection
- **Glovo** — Good coverage
- **Bolt Food** — Growing
- **Restaurant direct delivery** — Many upscale places deliver now

---

## Neighborhood Dining Summary

| For | Go To |
|----|-------|
| Traditional Portuguese | Mouraria, Alfama, Graça |
| Modern Portuguese | Santos, Chiado |
| Fine dining | Chiado, Príncipe Real |
| International variety | Príncipe Real, Cais do Sodré |
| Budget eats | Mouraria, Arroios, Martim Moniz |
| Brunch | Príncipe Real, Santos |
| Late night | Bairro Alto, Cais do Sodré |
| Seafood | Intendente, Cais do Sodré |

---

## Booking Recommendations

| Restaurant | Advance Needed |
|------------|----------------|
| Belcanto | 4-6 weeks |
| Cervejaria Ramiro | Same day, but call |
| A Cevicheria | 1-2 weeks |
| Alma | 2-4 weeks |
| Popular brunches | No booking, but arrive early |
| Tascas | No booking needed |
