# Education in Lisbon

## System Overview

Portugal has a well-structured education system:
- **Pre-school (Educação Pré-escolar)**: Ages 3-6, optional
- **Basic Education (Ensino Básico)**: Ages 6-15, compulsory
- **Secondary (Ensino Secundário)**: Ages 15-18
- **Higher Education**: Universities and polytechnics

---

## Public vs Private Schools

### Public Schools (Escolas Públicas)

**Pros**:
- Free for residents
- Available throughout Lisbon
- Portuguese language immersion
- Integration with local community

**Cons**:
- Large class sizes (25-30 students)
- Varying quality by school/area
- Portuguese-only instruction
- Less flexible curriculum

**Quality varies significantly** by neighborhood. Research specific schools, not just areas.

### Private Schools (Escolas Privadas)

**Pros**:
- Smaller classes (12-20 students)
- Often bilingual programs
- Modern facilities
- Extra-curricular activities

**Cons**:
- Expensive (€500-2,000+/month)
- Waiting lists common
- May create social bubble

---

## International Schools

For expat families, international schools are often the choice:

### Major International Schools

| School | Curriculum | Monthly Fee | Location |
|--------|------------|-------------|----------|
| St. Julian's School | British | €1,200-1,800 | Carcavelos |
| Carlucci American International | American/IB | €1,500-2,000 | Sintra |
| Deutsche Schule Lissabon | German | €600-900 | Estoril |
| Lycée Français Charles Lepierre | French | €500-800 | Lisbon |
| St. Dominic's International | IB | €1,200-1,700 | São Domingos de Rana |
| CLIP (Colégio Luso Internacional do Porto) | British | €800-1,200 | Lisbon Campus |
| International Sharing School | IB | €800-1,200 | Taguspark |
| Oeiras International School | IB | €900-1,400 | Oeiras |

### Application Process

1. **Contact early**: 12-18 months before start date
2. **Visit schools**: Tours usually available
3. **Application forms**: Often online
4. **Assessments**: Academic tests, interviews
5. **Waiting lists**: Common for popular schools
6. **Deposit**: Usually 1-3 months fees

### Considerations

- **Location**: Factor in commute from home
- **Curriculum**: Match with future education plans (UK, US, IB, local)
- **Language**: Portuguese requirement varies
- **Community**: Some schools more diverse than others

---

## Portuguese School System Details

### Structure

| Level | Ages | Grades | Duration |
|-------|------|--------|----------|
| Pre-school | 3-6 | - | Optional |
| 1st Cycle | 6-10 | 1-4 | 4 years |
| 2nd Cycle | 10-12 | 5-6 | 2 years |
| 3rd Cycle | 12-15 | 7-9 | 3 years |
| Secondary | 15-18 | 10-12 | 3 years |

### School Year
- **Start**: Mid-September
- **End**: Mid-June
- **Breaks**: Christmas (2 weeks), Carnival (3 days), Easter (2 weeks)

### Grading System
- **Basic education**: 1-5 scale
- **Secondary**: 0-20 scale
- **Passing**: 10/20 in secondary

---

## Enrolling in Public School

### Requirements
- Proof of residence (utility bill, rental contract)
- Child's ID/passport
- Previous school records (translated if needed)
- Health/vaccination records
- NIF (tax number) for parent

### Process
1. Identify your school zone (área de residência)
2. Visit local school for information
3. Submit enrollment during period (usually April-June)
4. Provide required documents
5. Placement confirmation

### For Non-Portuguese Speakers
- **PLNM (Português Língua Não Materna)**: Portuguese as foreign language support
- Available in many schools
- Quality and availability varies
- Consider supplementary Portuguese tutoring

---

## Childcare (Ages 0-3)

### Options

| Type | Cost/Month | Notes |
|------|------------|-------|
| Public crèche | €50-300 (income-based) | Limited availability |
| Private crèche | €300-800 | More spots, varied quality |
| IPSS (non-profit) | €100-400 | Social security support |
| Nanny (ama) | €600-1,200 | At-home care |
| Au pair | €400-600 + room/board | Limited hours |

### Finding Childcare
- **Register early**: Quality creches have waiting lists
- **Public**: Through Segurança Social
- **Private**: Direct contact or agencies
- **Recommendations**: Expat groups, local networks

---

## Higher Education

### Universities in Lisbon

**Public**:
- **Universidade de Lisboa (ULisboa)**: Largest, merged from UTL and UL
- **NOVA University Lisbon**: Modern, international programs
- **ISCTE – Instituto Universitário de Lisboa**: Business, social sciences

**Private**:
- **Universidade Católica Portuguesa**: Well-regarded, business school
- **Universidade Lusófona**: Large private university
- **Universidade Europeia**: International programs

### Polytechnics
- **Instituto Politécnico de Lisboa (IPL)**: Applied sciences, engineering
- **Various specialized schools**: Tourism, health, arts

### Tuition (2025-2026)

| Type | Annual Fee |
|------|------------|
| Public (Portuguese/EU) | €697-1,000 |
| Public (non-EU) | €3,000-7,000 |
| Private | €5,000-15,000+ |
| MBA programs | €15,000-40,000 |

### English-Taught Programs
Growing number available, especially at:
- NOVA SBE (business)
- Católica Lisbon School (business)
- IST (engineering)
- Various master's programs

---

## Language Learning for Children

### Options
- **School PLNM classes**: Free but variable quality
- **Private tutoring**: €20-40/hour
- **Language schools**: After-school programs
- **Immersion**: Full Portuguese school environment

### Reality Check
- Children adapt faster than adults
- Full immersion works but can be stressful initially
- Consider bilingual transition programs
- Portuguese opens doors in Angola, Brazil, Mozambique

---

## Special Educational Needs

### Public System
- **Decree-Law 54/2018**: Inclusive education framework
- **Support available**: Varies by school
- **Assessment**: Through school psychologist
- **Resources**: Often limited

### Private/International
- Generally better resourced
- Specialized support staff
- Additional fees may apply
- Not all schools equipped

### Specialist Support
- Private therapists available
- Long waits in public system
- Expat networks share recommendations

---

## Practical Tips

### Choosing a School
1. **Visit multiple schools**: Don't just rely on reputation
2. **Talk to parents**: Current families give best insights
3. **Consider commute**: Traffic in Lisbon is significant
4. **Think long-term**: Where will child continue education?
5. **Language strategy**: Portuguese or international track?

### Common Mistakes
- Enrolling late (missing deadlines)
- Underestimating Portuguese language challenge
- Choosing school for prestige vs. fit
- Not visiting before committing
- Ignoring transportation logistics

### Resources
- **Expat Facebook groups**: Real experiences
- **School open days**: Usually fall/spring
- **Education consultants**: For complex situations
- **Embassy contacts**: Country-specific school info

---

## Summer Programs & Activities

### During School Year
- After-school activities (ATL): €100-200/month
- Sports clubs: Football, swimming, tennis
- Music schools: Conservatory or private
- Language classes: English, French, etc.

### Summer
- **Campos de férias**: Day camps, €100-300/week
- **Beach schools**: Surfing, sailing
- **International camps**: English immersion
- **Sports camps**: Football academies popular

---

## Key Contacts

- **Direção-Geral da Educação**: www.dge.mec.pt
- **DGES (Higher Education)**: www.dges.gov.pt
- **School zones**: Check Câmara Municipal de Lisboa website
- **International school associations**: ECIS, CIS accreditation
