# Cost of Living in Lisbon (Feb 2026)

## The Big Picture

Lisbon is no longer Europe's affordable capital. Since 2015, prices have doubled while Portuguese wages barely moved. This creates a two-tier economy: local reality vs expat/digital nomad experience.

### The Numbers

| Monthly Expense | Budget | Mid-Range | Comfortable |
|-----------------|--------|-----------|-------------|
| **Rent (1BR center)** | €1,000-1,200 | €1,200-1,600 | €1,600-2,200 |
| **Rent (1BR periphery)** | €700-900 | €900-1,200 | €1,200-1,500 |
| **Utilities** | €80-120 | €120-180 | €150-250 |
| **Groceries** | €200-300 | €300-400 | €400-600 |
| **Dining out** | €100-200 | €200-400 | €400-800 |
| **Transport** | €40-60 | €60-100 | €100-200 |
| **Phone/Internet** | €30-50 | €50-70 | €70-100 |
| **Entertainment** | €50-100 | €100-200 | €200-500 |
| **Healthcare** | €0-50 | €50-100 | €100-300 |
| **TOTAL (single)** | **€1,500-2,000** | **€2,200-3,200** | **€3,200-5,500** |

### Context: Portuguese vs Expat

**Median Portuguese salary**: ~€1,200-1,500/month net
**Average startup salary**: ~€2,200/month gross
**Senior developer salary**: €3,000-5,000/month gross

**The disconnect**: A €1,400 1BR apartment = 90%+ of median salary. Locals typically house-share, live with parents, or live outside city.

---

## Housing Costs

### Rental Market (Feb 2026)

| Type | Center | Semi-Central | Periphery |
|------|--------|--------------|-----------|
| Room (shared flat) | €500-700 | €400-600 | €350-500 |
| Studio | €900-1,300 | €700-1,000 | €600-800 |
| 1 Bedroom | €1,200-1,800 | €1,000-1,400 | €800-1,200 |
| 2 Bedroom | €1,600-2,500 | €1,300-1,800 | €1,000-1,500 |
| 3 Bedroom | €2,200-3,500 | €1,800-2,500 | €1,400-2,000 |

**Center**: Chiado, Príncipe Real, Baixa, Santos
**Semi-Central**: Arroios, Graça, Campo de Ourique, Alcântara
**Periphery**: Benfica, Amadora, Alvalade, Parque das Nações

### Hidden Housing Costs

| Cost | Amount |
|------|--------|
| Security deposit | 2 months rent |
| Agency fee (if used) | 1 month rent |
| NIF registration (representative) | €100-200 |
| Furniture (if unfurnished) | €1,000-3,000 |
| Initial utility deposits | €100-200 |

### Housing Crisis Context

- **Why it's expensive**: Golden Visa speculation, tourism/Airbnb, limited building
- **Availability**: Very low—expect competition, quick decisions needed
- **Scams**: Never pay before viewing. Use Idealista carefully.
- **Trend**: Prices plateaued in 2025-2026 but not falling

---

## Utilities

### Monthly Averages

| Utility | Studio | 1BR | 2BR |
|---------|--------|-----|-----|
| Electricity | €40-70 | €50-90 | €70-120 |
| Gas (if used) | €20-40 | €30-50 | €40-70 |
| Water | €15-25 | €20-35 | €30-50 |
| Internet | €30-40 | €30-40 | €30-40 |
| **Total** | **€105-175** | **€130-215** | **€170-280** |

### Seasonal Variation

- **Summer**: AC = €30-50 extra/month (if you have AC)
- **Winter**: Heating = €20-40 extra/month
- **Note**: Many Portuguese apartments have NO heating/AC—confirm before renting

### Providers

| Service | Main Providers |
|---------|----------------|
| Electricity | EDP, Galp, Endesa |
| Gas | EDP Gas, Galp |
| Water | EPAL (municipal) |
| Internet | NOS, MEO, Vodafone |

---

## Food Costs

### Groceries (Monthly)

| Style | Cost |
|-------|------|
| Budget cooking | €150-250 |
| Regular cooking | €250-400 |
| Premium/organic | €400-600 |

### Supermarket Price Examples

| Item | Price Range |
|------|-------------|
| Bread (loaf) | €0.80-2.00 |
| Milk (1L) | €0.70-1.20 |
| Eggs (12) | €2.00-4.00 |
| Chicken breast (kg) | €6-10 |
| Rice (kg) | €1.00-2.50 |
| Olive oil (1L) | €6-12 |
| Wine (bottle) | €3-20 |
| Coffee (pack) | €2-5 |
| Vegetables | Generally cheap |
| Fruit | Generally cheap |

### Eating Out

| Meal Type | Price |
|-----------|-------|
| Coffee (espresso) | €0.70-1.20 |
| Pastel de nata | €1.20-1.50 |
| Quick lunch (prato do dia) | €8-12 |
| Casual dinner | €15-25 |
| Mid-range restaurant | €25-40 |
| Fine dining | €60-150 |
| Beer (draft, 33cl) | €2-3.50 |
| Wine (glass, restaurant) | €3-6 |
| Cocktail | €8-14 |

### Food Delivery

- **Uber Eats/Glovo order**: €15-25 typically
- **Delivery fees**: €1-4
- **Not as cheap** as cooking, not as expensive as dining out

---

## Transportation Costs

### Monthly Options

| Option | Cost |
|--------|------|
| Navegante monthly (metropolitan) | €40 |
| Zapping (moderate use) | €30-50 |
| Uber/Bolt (occasional) | €30-80 |
| **Realistic monthly total** | **€50-100** |

### Without Car

Lisbon is very livable without a car:
- Metro covers most needs
- Uber fills gaps
- Car rental for day trips (~€30-50/day)

### With Car

| Expense | Monthly |
|---------|---------|
| Parking (residential) | €50-150 |
| Fuel | €100-200 |
| Insurance | €40-80 |
| Maintenance (averaged) | €50-100 |
| **Total** | **€240-530** |

---

## Healthcare Costs

### Public Healthcare (SNS)

- **Free** for residents with healthcare number
- **Taxas moderadoras**: Small fees (€5-15) for visits
- **Wait times**: Can be long for non-urgent care
- **Quality**: Good for emergencies, variable for routine

### Private Healthcare

| Service | Cost |
|---------|------|
| GP consultation | €50-100 |
| Specialist consultation | €70-150 |
| Dental cleaning | €50-80 |
| Private health insurance (basic) | €50-100/month |
| Private health insurance (comprehensive) | €100-300/month |

### Common Insurance Options

- **MGEN, Multicare, Médis** — Portuguese insurers
- **SafetyWing, World Nomads** — Digital nomad options
- **Company plans** — Often included in employment

---

## Entertainment & Lifestyle

### Monthly Entertainment Budget

| Level | Budget |
|-------|--------|
| Minimal | €50-100 |
| Active social life | €150-300 |
| Comfortable | €300-500 |

### Activity Costs

| Activity | Price |
|----------|-------|
| Movie ticket | €7-10 |
| Museum entry | €5-15 (many free Sundays) |
| Gym membership | €30-60/month |
| Yoga class | €12-20 |
| Fado show (with dinner) | €40-80 |
| Night out (drinks) | €20-50 |
| Day trip (transport) | €10-30 |
| Weekend trip (Portugal) | €100-300 |

### Coworking Costs

| Option | Price |
|--------|-------|
| Day pass | €15-30 |
| Monthly flex desk | €150-250 |
| Fixed desk | €200-350 |
| Private office | €400+ |

**Popular spaces**: Second Home, Heden, Outsite, Selina

---

## Comparison: Lisbon vs Other Cities

### European Capitals (Feb 2026)

| City | 1BR Rent | Dinner Out | Monthly Total |
|------|----------|------------|---------------|
| Lisbon | €1,400 | €20-35 | €2,500-3,500 |
| Barcelona | €1,400 | €20-35 | €2,500-3,500 |
| Madrid | €1,300 | €18-30 | €2,300-3,200 |
| Berlin | €1,300 | €20-35 | €2,300-3,300 |
| Amsterdam | €1,800 | €30-50 | €3,200-4,500 |
| Paris | €1,800 | €35-60 | €3,500-5,000 |
| London | €2,200 | €35-60 | €4,000-5,500 |

**Verdict**: Lisbon is now mid-tier European pricing, NOT the budget option it once was.

### Vs Other Portuguese Cities

| City | Rent (1BR) | Overall |
|------|------------|---------|
| Lisbon | €1,400 | 100% (baseline) |
| Porto | €1,100 | ~80% |
| Cascais | €1,500 | ~105% |
| Braga | €700 | ~55% |
| Coimbra | €600 | ~50% |
| Algarve | €900-1,200 | 70-90% |

---

## Salary Expectations

### By Industry (Gross Monthly)

| Role | Junior | Mid | Senior |
|------|--------|-----|--------|
| Software Developer | €1,200-1,800 | €2,000-3,000 | €3,500-5,500 |
| Data Scientist | €1,400-2,000 | €2,500-3,500 | €4,000-6,000 |
| Product Manager | €1,500-2,200 | €2,500-3,500 | €4,000-5,500 |
| Designer | €1,000-1,500 | €1,800-2,800 | €3,000-4,500 |
| Marketing | €1,000-1,500 | €1,800-2,500 | €2,800-4,000 |
| Finance | €1,200-1,800 | €2,000-3,000 | €3,500-6,000 |

### Tax Reality

| Gross Salary | Net Salary | Tax + SS Rate |
|--------------|------------|---------------|
| €2,000 | ~€1,400 | ~30% |
| €3,000 | ~€1,950 | ~35% |
| €4,000 | ~€2,450 | ~39% |
| €5,000 | ~€2,900 | ~42% |

**Note**: These are approximate. Tax depends on many factors.

---

## Budget Templates

### Solo Digital Nomad (Comfortable)

| Category | Monthly |
|----------|---------|
| Room in shared flat (center) | €650 |
| Utilities share | €60 |
| Food (mix cooking/out) | €400 |
| Transport | €50 |
| Coworking (flexible) | €150 |
| Phone/internet | €30 |
| Entertainment | €200 |
| Buffer | €100 |
| **TOTAL** | **€1,640** |

### Couple (Mid-Range)

| Category | Monthly |
|----------|---------|
| 1BR apartment (semi-central) | €1,300 |
| Utilities | €150 |
| Food (cooking + occasional dining) | €600 |
| Transport | €80 |
| Phone/internet | €60 |
| Entertainment | €300 |
| Healthcare | €100 |
| Buffer | €150 |
| **TOTAL** | **€2,740** |

### Family (3-4 people, Comfortable)

| Category | Monthly |
|----------|---------|
| 3BR apartment | €2,200 |
| Utilities | €250 |
| Food | €800 |
| Transport | €200 |
| School (if international) | €800-1,500 |
| Healthcare | €200 |
| Activities | €300 |
| Buffer | €300 |
| **TOTAL** | **€5,050-5,750** |

---

## Money-Saving Tips

### Housing
- Live in peripheral neighborhoods (Benfica, Arroios)
- House-share in center
- Negotiate 6+ month contracts
- Avoid August (peak tourist rental pricing)

### Food
- Cook at home
- Use Lidl/Aldi for groceries
- Lunch special (prato do dia) instead of dinner
- Portuguese wine is cheap and excellent

### Transport
- Get monthly Navegante if using transit daily
- Walk—Lisbon is very walkable despite hills
- Bike in flat areas

### Entertainment
- Free museum days (first Sunday)
- Free miradouros (viewpoints)
- Happy hours (17:00-20:00 drinks deals)
- Parks and beaches are free
