# Lisbon Climate & Weather Guide

## Climate Overview

Lisbon has a **Mediterranean climate** with Atlantic influence—mild, wet winters and warm, dry summers. It's one of Europe's sunniest capitals with over 2,800 hours of sunshine annually.

### The Basic Pattern

| Season | Months | Temperature | Rainfall | Character |
|--------|--------|-------------|----------|-----------|
| Spring | Mar-May | 15-22°C | Moderate | Pleasant, blooming |
| Summer | Jun-Aug | 22-30°C | Very little | Hot, dry, crowded |
| Autumn | Sep-Nov | 16-24°C | Increasing | Mild, good weather |
| Winter | Dec-Feb | 10-15°C | Rainy periods | Mild but wet |

---

## Month-by-Month Breakdown

### January
- **Temperature**: 8-15°C (avg high 15°C)
- **Rainfall**: 110mm (rainiest month)
- **Daylight**: ~10 hours
- **Character**: Quiet, rainy, cool
- **Good for**: Museums, indoor activities, low prices
- **Avoid if**: You need guaranteed sunshine

### February
- **Temperature**: 9-16°C
- **Rainfall**: 100mm
- **Daylight**: ~11 hours
- **Character**: Still winter, occasional sunny spells
- **Good for**: Carnival period, budget travel
- **Note**: Almond blossoms begin in Algarve

### March
- **Temperature**: 11-18°C
- **Rainfall**: 70mm
- **Daylight**: ~12 hours
- **Character**: Spring emerging, variable weather
- **Good for**: Shoulder season pricing, fewer crowds
- **Dress**: Layers essential, rain jacket

### April
- **Temperature**: 12-20°C
- **Rainfall**: 55mm
- **Daylight**: ~13 hours
- **Character**: Pleasant spring, flowers blooming
- **Good for**: Sightseeing, outdoor activities
- **Events**: Easter (dates vary)

### May
- **Temperature**: 14-22°C
- **Rainfall**: 40mm
- **Daylight**: ~14 hours
- **Character**: Excellent weather, not yet hot
- **Good for**: Everything outdoor
- **Highlight**: Jacaranda trees bloom late May (purple everywhere)

### June
- **Temperature**: 17-26°C
- **Rainfall**: 15mm
- **Daylight**: ~15 hours
- **Character**: Summer begins, festive
- **Good for**: Santo António festival, sardines
- **Events**: Santo António (June 12-13) = massive street parties

### July
- **Temperature**: 19-28°C
- **Rainfall**: 5mm
- **Daylight**: ~14.5 hours
- **Character**: Peak summer, hot and dry
- **Good for**: Beach, late nights
- **Events**: Festival season (music, culture)
- **Warning**: Peak tourism, book ahead

### August
- **Temperature**: 19-29°C
- **Rainfall**: 5mm
- **Daylight**: ~13.5 hours
- **Character**: Hottest month, many locals leave
- **Reality check**: Many Portuguese businesses close
- **Good for**: Beach if you don't mind crowds
- **Avoid if**: Want authentic local experience

### September
- **Temperature**: 18-27°C
- **Rainfall**: 30mm
- **Daylight**: ~12.5 hours
- **Character**: Still warm, crowds thin
- **Good for**: Beach + sightseeing combo
- **Excellent month**: Best weather-to-crowds ratio

### October
- **Temperature**: 15-23°C
- **Rainfall**: 80mm
- **Daylight**: ~11 hours
- **Character**: Autumn begins, pleasant
- **Good for**: Wine harvest, outdoor activities
- **Rain**: Starts increasing

### November
- **Temperature**: 12-18°C
- **Rainfall**: 115mm
- **Daylight**: ~10 hours
- **Character**: Wet, cooler, quiet
- **Events**: Web Summit (usually)
- **Good for**: Culture, indoor activities

### December
- **Temperature**: 9-15°C
- **Rainfall**: 115mm
- **Daylight**: ~9.5 hours
- **Character**: Mild winter, festive
- **Good for**: Christmas markets, New Year
- **Note**: Milder than Northern Europe

---

## Best Times to Visit

### For Perfect Weather
**May and September-October**: 
- Warm but not scorching
- Less crowded than summer
- Lower prices than peak
- Long daylight hours
- Pleasant for walking

### For Beach
**June-September**:
- Water warmest (still cool: 18-20°C)
- Best beach weather
- Longest days
- Note: Atlantic never warm like Mediterranean

### For Budget
**November-February (except Christmas)**:
- Lowest prices
- Fewest tourists
- Rainy but mild
- Indoor attractions shine

### For Nightlife/Festivals
**June**: Santo António chaos (good chaos)
**July-August**: Festival season
**November**: Web Summit networking

### To Avoid
**August**: Hot, crowded, locals gone, some closures
**Web Summit week**: Hotel prices insane

---

## Compared to Other Cities

### vs Madrid
- Lisbon: Milder summers (28°C vs 35°C)
- Lisbon: More winter rain
- Lisbon: Ocean breeze moderates heat
- Madrid: More continental extremes

### vs Barcelona
- Similar overall
- Lisbon: Slightly cooler (Atlantic vs Mediterranean)
- Lisbon: More rain in winter
- Barcelona: Warmer sea for swimming

### vs London
- Lisbon: Much sunnier (2,800h vs 1,600h)
- Lisbon: Milder winters
- Lisbon: Much drier summers
- London: More consistent year-round grey

### vs Northern Europe
- **Winter**: 10-15°C vs below freezing
- **Summer**: Similar highs, much less rain
- **Overall**: Escape destination for Northern Europeans

---

## Practical Weather Tips

### Summer Survival (Jun-Sep)

**Heat management**:
- Schedule outdoor activities before 11am or after 5pm
- Midday = museum/indoor time
- Stay hydrated (carry water)
- Seek shade—Lisbon has limited tree cover downtown
- AC is NOT universal—confirm in accommodation

**What to pack**:
- Sunscreen (SPF 30+)
- Hat
- Light, breathable clothing
- Comfortable walking shoes
- Sunglasses
- Reusable water bottle

**Hills + Heat = Exhaustion**:
- Use funiculars/elevators
- Take breaks in cafés
- Consider mornings for hill neighborhoods
- Pace yourself

### Winter Preparation (Nov-Feb)

**Rain reality**:
- Can rain for days straight
- Not constant, but frequent
- Temperatures mild but damp

**What to pack**:
- Waterproof jacket (essential)
- Umbrella
- Layers (weather variable)
- Closed-toe waterproof shoes
- Warm sweater (buildings often unheated)

**Indoor activities ready**:
- Museums
- Markets (Time Out, Campo de Ourique)
- Cafés
- Shopping centers

### Year-Round

**The hills factor**:
- Cobblestones + wet = slippery
- Wear proper shoes (no slick soles)
- Rain makes climbs harder
- Good shoes matter more than fashion

**Air conditioning**:
- Many older buildings have none
- Confirm AC exists before summer booking
- Traditional Portuguese solution: shutters closed midday
- Fans help but don't solve heat

**Heating**:
- Many buildings have no central heating
- Space heaters common
- Electric bills spike in winter
- Portuguese buildings can feel cold inside

---

## Microclimates & Local Variations

### Cooler Spots
- **Sintra**: 3-5°C cooler, more misty (microclimate from forest)
- **Cascais/coast**: Ocean breeze, cooler in summer
- **Riverside**: Slightly cooler than inland

### Warmer Spots
- **Baixa**: Heat trapped in valley
- **Inland areas**: Less breeze
- **Upper floors**: Heat rises

### Weather Differences Within Region
- **Costa da Caparica**: Can be foggy when Lisbon sunny
- **Sintra**: Often cloudy when Lisbon clear
- **Alentejo (inland)**: Much hotter in summer

---

## Climate Events

### Heat Waves
- **Frequency**: Several times per summer
- **Temperature**: Can exceed 40°C
- **Duration**: Usually 3-5 days
- **What to do**: Stay indoors midday, hydrate, beaches

### Atlantic Storms
- **Season**: Mostly Nov-Feb
- **Character**: Strong winds, heavy rain
- **Impact**: Some outdoor attractions close
- **Named storms**: Occasionally (European naming system)

### Drought
- **Increasing issue**: Climate change impact
- **Summer dry spells**: Normal
- **Water restrictions**: Occasionally imposed
- **Visible effects**: Brown landscapes inland

---

## What Locals Do

### Summer
- Beach weekends (leave Friday evening)
- August: Many leave Lisbon entirely
- Late dinners (cooler)
- Indoor activities midday
- Air-conditioned shopping malls

### Winter
- Normal life continues (mild by European standards)
- Cafés for warmth
- More indoor socializing
- Hot chocolate (chocolate quente)
- Embrace rain with proper gear

### Shoulder Seasons
- Best outdoor dining
- Parks and gardens
- Day trips
- Wine regions

---

## Climate Change Notes

**Observed trends**:
- Summers getting hotter
- Heat waves more frequent
- Drought periods longer
- Rainfall patterns changing
- Winters remaining mild

**What this means**:
- Summer AC increasingly important
- Water conservation messaging
- Fire risk awareness
- Slight unpredictability

---

## Packing List by Season

### Summer (Jun-Aug)
- [ ] Sunscreen, hat, sunglasses
- [ ] Light, breathable clothing
- [ ] Swimwear
- [ ] Sandals AND comfortable walking shoes
- [ ] Light jacket for AC/evenings
- [ ] Reusable water bottle

### Shoulder (Apr-May, Sep-Oct)
- [ ] Layers (temperature varies)
- [ ] Light jacket
- [ ] Mix of short and long sleeves
- [ ] Comfortable walking shoes
- [ ] Small umbrella (just in case)
- [ ] Swimwear (September especially)

### Winter (Nov-Mar)
- [ ] Waterproof jacket (essential)
- [ ] Umbrella
- [ ] Warm layers
- [ ] Closed waterproof shoes
- [ ] Scarf/hat for cold days
- [ ] Warm sweater for indoor spaces
