# Starting a Business in Lisbon

## Business Structure Options

### Common Legal Forms

| Type | Portuguese | Use Case | Min Capital |
|------|------------|----------|-------------|
| **Sole Proprietor** | Empresário em Nome Individual | Freelancers, simple businesses | None |
| **Unipessoal (Single-Member LLC)** | Sociedade Unipessoal por Quotas | One-owner company | €1 |
| **Lda (LLC)** | Sociedade por Quotas | Most small/medium businesses | €1 |
| **SA (Corporation)** | Sociedade Anónima | Large companies, investors | €50,000 |

### Most Common: Lda (Sociedade por Quotas)

**Why Lda**:
- Limited liability
- Low minimum capital (€1)
- Flexible management
- Suitable for most SMBs
- Can have multiple shareholders

**Characteristics**:
- Shareholders liable up to capital contribution
- Minimum 1 shareholder (Unipessoal) or 2+ (regular)
- Manager(s) appointed
- No minimum capital effectively

---

## Company Formation Process

### Standard Timeline: 2-4 Weeks

**Option 1: Empresa na Hora (Company in an Hour)**

Fast-track government program:
1. Go to "Empresa na Hora" desk (various locations)
2. Choose pre-approved company name
3. Sign documents
4. Receive NIF and registration
5. **Time**: Same day

**Cost**: ~€360

**What you need**:
- ID for all shareholders
- NIF for all shareholders
- Registered address
- Define capital and shareholding
- Define business activities (CAE codes)

**Limitations**:
- Must use pre-approved name list
- Standard articles of association
- Present in person

**Option 2: Traditional (Custom)**

For custom names or complex structures:
1. Reserve company name (RNPC)
2. Draft articles of association
3. Notarize documents
4. Register at commercial registry
5. Register for tax/social security

**Time**: 2-4 weeks
**Cost**: €500-1,500 (including lawyer if used)

### Post-Formation Steps

1. **Open business bank account**
2. **Register with Finanças** (tax authority)
3. **Register with Segurança Social** (social security)
4. **Open business activity** (if not already)
5. **Consider certified accountant** (TOC—mandatory for Ldas)

---

## Costs & Ongoing Requirements

### Formation Costs

| Item | Cost |
|------|------|
| Empresa na Hora | ~€360 |
| Traditional formation | €500-1,500 |
| Lawyer (if used) | €500-2,000 |
| Initial bank deposit | Varies |

### Annual Costs

| Item | Cost |
|------|------|
| Certified accountant (TOC) | €100-300/month |
| Registered office | Varies (can be home) |
| Annual filing | ~€100 |
| Social security (if sole owner) | ~€20-350/month |

### Accounting Requirement

**Lda/SA require**:
- Certified accountant (Técnico Oficial de Contas)
- Cannot do own accounts
- Typical cost: €100-300/month for small company

---

## Taxation

### Corporate Tax (IRC)

**Standard rate**: 21%

**Reduced rates**:
- SMEs: 17% on first €25,000 profit
- Interior regions: Additional reductions

**Startup regime** (certain conditions):
- Potential for reduced rates
- Check current incentives

### VAT (IVA)

**Standard rate**: 23%
**Reduced**: 13% (restaurants, some food)
**Super-reduced**: 6% (essential goods, books)

**VAT registration**: Required above €12,500 annual turnover

**EU sales**: Standard VAT rules apply (reverse charge for B2B)

### Tax Calendar

| Deadline | What |
|----------|------|
| Monthly | VAT declarations (if monthly regime) |
| Quarterly | VAT (if quarterly), tax prepayments |
| May 31 | Corporate tax (IRC) annual return |
| June 30 | IRS (personal income tax if relevant) |

---

## Hiring Employees

### Employment Basics

**Standard contract**:
- 40 hours/week
- 22 vacation days
- 14 months salary (holiday + Christmas bonuses)

**Employer costs** (on top of gross salary):
- Social security: 23.75%
- Work accident insurance: ~1-2%
- Meal allowance: Common (~€6/day)

**Example total cost**:
- €2,000 gross salary = ~€2,600 total employer cost

### Hiring Process

1. Register with Segurança Social as employer
2. Issue employment contract
3. Register employee with Segurança Social
4. Submit monthly declarations
5. Pay monthly social security

### Firing Complexity

Portuguese labor law is **protective of employees**:
- Just cause required for dismissal
- Severance: Typically 12-20 days per year of service
- Notice periods: 15-75 days depending on tenure
- Can be complex and expensive

**Workaround**: Fixed-term contracts (but limited)

---

## Freelancing (Trabalhador Independente)

### When Freelancing Makes Sense

- Testing business idea
- Consulting
- Creative services
- International clients (using D8 visa)

### Setup

1. **NIF** (personal tax number)
2. **Open activity** at Finanças
3. **Register** with Segurança Social
4. **Issue recibos verdes** (green receipts) for each payment

### Taxation

**Below €12,500/year**: Can use simplified regime, no VAT
**Above €12,500/year**: VAT registration required

**Income tax**: Progressive rates (14.5-48%)
**Social security**: Based on declared income, min ~€20/month

### Recibos Verdes

Digital invoices through Portal das Finanças:
- Issue for each payment received
- Specify if VAT-exempt or charged
- Client receives copy automatically

---

## Industry-Specific Requirements

### Regulated Activities

Some sectors require:
- **Licensed accountant** for accounting services
- **Medical qualifications** for healthcare
- **Engineering license** for certain activities
- **Food safety certification** for F&B
- **Financial licenses** for banking/fintech

### Check CAE Codes

CAE (Classificação das Atividades Económicas) determines:
- Applicable regulations
- Tax rates in some cases
- Licensing requirements

---

## Funding Options

### For Portuguese Companies

**Grants**:
- Portugal 2030 (EU structural funds)
- IAPMEI programs
- Regional incentives
- Startup vouchers

**Loans**:
- Banco Português de Fomento
- Commercial banks
- Microfinance

**Equity**:
- See `startup.md` for VC/angel scene

### Accessing Grants

**Complex process**:
- Usually requires consultants
- Competitive
- Bureaucratic
- But significant funds available

**Bodies to know**:
- IAPMEI — SME support
- AICEP — Investment/export agency
- Compete 2030 — Innovation programs

---

## Practical Tips

### Use an Accountant

**Not optional for Lda/SA** — but even freelancers benefit:
- Navigate complex Portuguese tax
- Ensure compliance
- Optimize tax position
- Save time

**Cost**: €100-300/month well spent

### Bank Account Challenges

**Opening business account**:
- Easier than personal for non-residents
- But can still be bureaucratic
- Expect: Multiple documents, in-person visits
- Neo-banks (Qonto, etc.) emerging but limited

### Registered Address

**Options**:
- Home address (if allowed by rental/HOA)
- Virtual office services
- Coworking (some offer)
- Rented commercial space

### Language

**Most business administration in Portuguese**:
- Official documents
- Tax portal
- Social security
- Courts

**Accountant helps bridge gap**, but basic Portuguese useful

---

## Resources

### Government Portals

- **ePortugal**: eportugal.gov.pt — Citizen/business services
- **Portal das Finanças**: portaldasfinancas.gov.pt — Tax
- **Segurança Social Direta**: seg-social.pt — Social security
- **IAPMEI**: iapmei.pt — SME support

### Support Organizations

- **Startup Portugal**: startupportugal.com
- **AICEP**: Invest in Portugal
- **IAPMEI**: SME programs
- **Chambers of Commerce**: British, American, German, etc.

### Finding Help

- **Accountants**: Many English-speaking serving expats
- **Lawyers**: International firms, local firms with English
- **Company formation**: Various services target expats

---

## Comparison: Freelance vs Company

| Factor | Freelance | Lda Company |
|--------|-----------|-------------|
| Setup complexity | Easy | Moderate |
| Setup cost | ~€0 | ~€400-1,500 |
| Monthly costs | Social security | Accountant + SS |
| Liability | Unlimited | Limited |
| Taxation | Personal income | Corporate (21%) |
| Credibility | Lower | Higher |
| Best for | Starting out, solo | Growing, hiring, investors |

---

## Timeline: Starting a Business

| Week | Activity |
|------|----------|
| 1 | Get NIF, research requirements |
| 2 | Choose structure, gather documents |
| 3 | Form company (Empresa na Hora) or start process |
| 3-4 | Open bank account, tax/SS registration |
| 4+ | Begin operations, hire accountant |
