---
name: Lisbon
slug: lisbon
version: 1.0.0
homepage: https://clawic.com/skills/lisbon
description: Navigate Lisbon as visitor, resident, digital nomad, tech worker, or entrepreneur with neighborhoods, transport, costs, visas, and local insights.
metadata: {"clawdbot":{"emoji":"🇵🇹","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Lisbon or Portugal for any purpose: visiting, moving, working remotely, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| Historic Center (Alfama, Baixa, Chiado) | `neighborhoods-historic.md` |
| Trendy Areas (Príncipe Real, Santos, Estrela) | `neighborhoods-trendy.md` |
| Riverside (Alcântara, Belém, Cais do Sodré) | `neighborhoods-riverside.md` |
| Modern & Suburban (Parque das Nações, Benfica) | `neighborhoods-modern.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & dining scene | `food-overview.md` |
| Portuguese cuisine | `food-local.md` |
| International & fine dining | `food-international.md` |
| Best areas for dining | `food-areas.md` |
| Practical (tipping, Ramadan, dietary) | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport (metro, trams, ferries) | `transport.md` |
| Cost of living | `cost.md` |
| Safety & laws | `safety.md` |
| Weather & seasonal tips | `climate.md` |
| Local services (banking, SIM, NIF) | `local.md` |
| **Career** | |
| Tech industry & salaries | `tech.md` |
| Business setup & freelancing | `business.md` |
| Visas (D7, digital nomad, Golden) | `visas.md` |
| Startups & funding | `startup.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare & SNS | `healthcare.md` |
| Schools & education | `education.md` |
| Expat lifestyle & social | `lifestyle.md` |
| Driving & car ownership | `driving.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, digital nomad, tech worker, student, entrepreneur
- **Timeline**: Short visit, planning to move, already there
- Load relevant auxiliary file for details

### 2. Digital Nomad & Expat Hub
Lisbon has transformed into Europe's top digital nomad destination. Key considerations:
- **D7 Visa**: Passive income route (€920/month minimum)
- **Digital Nomad Visa (D8)**: Remote workers earning 4x minimum wage
- **NHR 2.0 (IFICI)**: 20% flat tax for qualifying professionals (replaced original NHR in 2024)
- **EU citizens**: Free movement, just register with local authorities
See `visas.md` for current requirements and processes.

### 3. Cultural Context
Portugal is relaxed but traditional in unexpected ways:
- **Meal times**: Lunch 12:30-14:30, dinner 20:00-22:30 (later than Northern Europe)
- **Saudade**: The untranslatable Portuguese melancholy—respect it
- **Fado**: More than music, it's cultural identity
- **Pace**: Things move slowly. "Portuguese time" is real.
See `culture.md` for detailed guidance.

### 4. Weather Reality
- **Mediterranean climate**: Mild winters, hot dry summers
- **Best season**: Spring (Mar-May) and Fall (Sep-Oct)—20-25°C, few tourists
- **Summer (Jun-Sep)**: Hot (up to 35°C+), packed with tourists
- **Winter (Dec-Feb)**: Mild (10-15°C) but rainy; cheapest time
- **Hills + heat**: Summer walking is exhausting. Plan accordingly.
See `climate.md` for monthly breakdown and tips.

### 5. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1BR rent (center) | €1,200-1,800/month |
| 1BR rent (periphery) | €800-1,200/month |
| Senior SWE salary | €3,500-5,500/month gross |
| Startup avg salary | €2,200/month |
| Metro single (Zapping) | €1.72 |
| Tram 28 onboard | €3.30 |
| 24h transport pass | €7.00 |
| Meal at tasca | €10-15 |
| Pastel de nata | €1.20-1.50 |

### 6. Cost Reality
Lisbon is no longer cheap—it's now one of Europe's most expensive cities relative to local wages:
- **Housing**: 40-50%+ of budget for most residents; crisis-level shortage
- **Dining out**: Still reasonable by Western European standards
- **Transport**: Excellent public transit keeps costs low
- **Groceries**: Reasonable; Pingo Doce, Continente, Lidl are affordable
- **Hidden costs**: Agency fees (1 month rent), 2-month deposit, NIF bureaucracy

### 7. Transit Excellence
Unlike car-centric cities, Lisbon has excellent public transport:
- **Metro**: 4 lines, covers most central areas
- **Trams**: Historic (28, 12) and modern (15E to Belém)
- **Buses**: Extensive Carris network
- **Ferries**: To Cacilhas, Almada (stunning views)
- **Trains**: Cascais line, Sintra line from Rossio
- **Navegante card**: Essential—€0.50 card, load with Zapping credit
See `transport.md` for complete guide.

### 8. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young professionals | Santos, Príncipe Real, Arroios |
| Families | Campo de Ourique, Alvalade, Benfica |
| Digital nomads | Príncipe Real, Santos, Alcântara |
| Budget-conscious | Benfica, Amadora, Marvila |
| Beach lovers | Cascais, Costa da Caparica |
| Tech workers | Parque das Nações, Avenidas Novas |
| Culture seekers | Alfama, Mouraria, Chiado |

## The Lisbon Transformation

Understanding Lisbon requires knowing its recent history:
- **Pre-2010**: Affordable, sleepy European capital
- **2012-2015**: Troika crisis → tourism push, Golden Visa boom
- **2015-2020**: Web Summit arrives (2016), tech scene explodes, prices double
- **2020-2023**: Pandemic pause, then digital nomad surge
- **2023-2024**: Golden Visa real estate ended, NHR replaced with NHR 2.0
- **2024-present**: Housing crisis acute, local backlash against mass tourism

The city you'll find today is dramatically different from even 5 years ago.

## Lisbon-Specific Traps

- **Hills underestimation** — Seven hills are brutal. Wear proper shoes. Take trams/funiculars.
- **August exodus** — Many local businesses close. Worst month for authentic experience.
- **Tram 28 pickpockets** — Notorious. Keep belongings secure. Consider walking the route instead.
- **Pastel de Belém vs Nata** — Belém is ONE bakery. "Pastéis de nata" is the generic name.
- **Alfama at night** — Some areas deserted and poorly lit. Stick to main streets.
- **Sintra one-day ambition** — Pick 2-3 palaces max. Trying to see everything ruins it.
- **"Local" restaurants in Baixa** — Tourist traps. Venture to other neighborhoods.
- **Rental scams** — Never send money before seeing apartment. Use Idealista carefully.
- **NIF without address** — Catch-22 situation. Use a fiscal representative service initially.
- **Portuguese hours** — Don't arrive for dinner at 18:00. Nothing will be open.

## Legal Awareness

Key laws visitors/residents must know:
- **Drugs**: Decriminalized (possession of small amounts not criminal), but NOT legal. Dealing is prosecuted.
- **Alcohol**: Legal at 18+. Public drinking generally tolerated in plazas.
- **Short-term rentals**: Heavily regulated. Many Airbnbs operate in legal grey area.
- **Tax residency**: 183 days = tax resident. NHR 2.0 requires 5 years non-residency.
- **Work permits**: Non-EU citizens need proper visa. Remote work for foreign employer is grey area without D8.
- **Photography**: Generally fine. Be respectful in residential areas of Alfama/Mouraria.

See `safety.md` for comprehensive legal guidance.

## The Housing Reality (2026)

This deserves special attention:
- **Supply crisis**: Decades of underbuilding + tourism boom + digital nomads
- **Rent increases**: 200-300% in past decade in central areas
- **Local impact**: Average Portuguese salary €1,500/month can't afford central rents
- **Political tensions**: Regular protests against mass tourism and housing speculation
- **As a newcomer**: Be aware you're part of a controversial dynamic. Act respectfully.

## Language

- **Portuguese spoken**: Yes, unlike some expat bubbles, Portuguese matters here
- **English proficiency**: High among young people, variable among older generation
- **Spanish assumption**: Don't speak Spanish expecting understanding. It's rude.
- **Learning Portuguese**: Greatly appreciated. Even basics open doors.
- **Brazilian Portuguese**: Widely understood due to TV/media, but differences exist
