# Linux Patcher - Workflow Diagrams

Visual representation of how the Linux Patcher skill operates.

## Overview: Automatic Mode (Recommended)

```
┌─────────────────────────────────────────────────────────────┐
│                    User Interaction                         │
└─────────────────────────────────────────────────────────────┘
                            │
                            ▼
        ┌─────────────────────────────────────────┐
        │  Ask OpenClaw: "Update my servers"      │
        └─────────────────────────────────────────┘
                            │
                            ▼
┌─────────────────────────────────────────────────────────────┐
│              Linux Patcher Skill Activated                  │
│                  (patch-auto.sh)                            │
└─────────────────────────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Step 1: Query PatchMon API            │
        │  • Authenticate with credentials       │
        │  • Get list of hosts needing updates   │
        │  • Parse host details (user, paths)    │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Any hosts need updates?                │
        └────────────────────────────────────────┘
                    │                   │
            ┌───────┴───────┐           │
            │ YES           │ NO        │
            │               └───────────┘
            ▼                           │
  ┌─────────────────────┐              │
  │  Step 2: For Each   │              │
  │  Host That Needs    │              │
  │  Updates            │              │
  └─────────────────────┘              │
            │                           │
            ▼                           │
  ┌─────────────────────┐              │
  │  Detect OS:         │              │
  │  Ubuntu/Debian      │              │
  │  RHEL/Rocky/Alma    │              │
  │  Amazon Linux       │              │
  │  CentOS/SUSE        │              │
  └─────────────────────┘              │
            │                           │
            ▼                           │
  ┌─────────────────────┐              │
  │  Docker Installed?  │              │
  └─────────────────────┘              │
      │           │                     │
  ┌───┴───┐   ┌───┴───┐                │
  │ YES   │   │ NO    │                │
  └───┬───┘   └───┬───┘                │
      │           │                     │
      ▼           │                     │
  ┌────────────┐  │                     │
  │ --skip-    │  │                     │
  │ docker     │  │                     │
  │ flag?      │  │                     │
  └────────────┘  │                     │
      │     │     │                     │
  ┌───┴───┐ │     │                     │
  │ YES   │ │ NO  │                     │
  └───┬───┘ │     │                     │
      │     ▼     │                     │
      │  ┌─────────────────┐            │
      │  │ Find Docker     │            │
      │  │ Compose Path    │            │
      │  └─────────────────┘            │
      │     │                            │
      │     ▼                            │
      │  ┌─────────────────┐            │
      │  │ Path Found?     │            │
      │  └─────────────────┘            │
      │     │         │                 │
      │  ┌──┴──┐   ┌──┴──┐             │
      │  │ YES │   │ NO  │             │
      │  └──┬──┘   └──┬──┘             │
      │     │         │                 │
      │     ▼         │                 │
      │  ┌─────────────────────┐       │
      │  │  FULL UPDATE        │       │
      │  │  • apt/yum update   │       │
      │  │  • apt/yum upgrade  │       │
      │  │  • docker prune     │       │
      │  │  • docker pull      │       │
      │  │  • compose up -d    │       │
      │  └─────────────────────┘       │
      │          │                      │
      └──────────┼──────────────────────┘
                 ▼
      ┌─────────────────────┐
      │  HOST-ONLY UPDATE   │
      │  • apt/yum update   │
      │  • apt/yum upgrade  │
      │  • apt/yum autoremove│
      └─────────────────────┘
                 │
                 ▼
      ┌─────────────────────┐
      │  Check Reboot Status│
      └─────────────────────┘
                 │
                 ▼
      ┌─────────────────────┐
      │  Report Results     │
      │  • Success/Failure  │
      │  • Packages updated │
      │  • Reboot needed?   │
      └─────────────────────┘
                 │
                 ▼
      ┌─────────────────────┐
      │  Next Host?         │
      └─────────────────────┘
          │           │
      ┌───┴───┐   ┌───┴───┐
      │ YES   │   │ NO    │
      └───┬───┘   └───┬───┘
          │           │
          │           ▼
          │  ┌─────────────────────┐
          │  │  Summary Report     │
          │  │  • Total hosts      │
          │  │  • Successful       │
          │  │  • Failed           │
          │  └─────────────────────┘
          │           │
          └───────────┘
                      ▼
                ┌─────────┐
                │  Done   │
                └─────────┘
```

## Manual Mode: Single Host Update

```
┌─────────────────────────────────────────────────────────────┐
│  User runs: scripts/patch-host-only.sh admin@webserver      │
└─────────────────────────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  SSH to webserver as admin             │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Detect OS Distribution                │
        │  (detect-os.sh)                        │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Select Package Manager:               │
        │  • apt (Ubuntu/Debian)                 │
        │  • yum/dnf (RHEL/CentOS/Rocky/Alma)   │
        │  • zypper (SUSE)                       │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Execute Updates:                      │
        │  1. sudo {pkg_manager} update          │
        │  2. sudo {pkg_manager} upgrade -y      │
        │  3. sudo {pkg_manager} autoremove -y   │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Check if Reboot Needed                │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Report Results to User                │
        └────────────────────────────────────────┘
```

## OS Detection Logic

```
┌─────────────────────────────────────────────────────────────┐
│  SSH to Target Host                                         │
└─────────────────────────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Read: cat /etc/os-release             │
        │  Parse: ID field                       │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Match Distribution ID:                │
        └────────────────────────────────────────┘
                    │
        ┌───────────┼───────────┬───────────┬──────────┐
        │           │           │           │          │
        ▼           ▼           ▼           ▼          ▼
  ┌──────────┐ ┌──────────┐ ┌──────────┐ ┌──────────┐ ┌──────────┐
  │ ubuntu   │ │ rhel     │ │ amzn     │ │ centos   │ │ suse     │
  │ debian   │ │ rocky    │ │ amazon   │ │          │ │ opensuse │
  │          │ │ almalinux│ │          │ │          │ │          │
  └──────────┘ └──────────┘ └──────────┘ └──────────┘ └──────────┘
        │           │           │           │          │
        ▼           ▼           ▼           ▼          ▼
  ┌──────────┐ ┌──────────┐ ┌──────────┐ ┌──────────┐ ┌──────────┐
  │   apt    │ │ Check:   │ │ Check:   │ │ Check:   │ │ zypper   │
  │          │ │ dnf or   │ │ dnf or   │ │ dnf or   │ │          │
  │          │ │ yum      │ │ yum      │ │ yum      │ │          │
  └──────────┘ └──────────┘ └──────────┘ └──────────┘ └──────────┘
        │           │           │           │          │
        └───────────┴───────────┴───────────┴──────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Return Package Manager Commands:      │
        │  • UPDATE_CMD                          │
        │  • UPGRADE_CMD                         │
        │  • AUTOREMOVE_CMD                      │
        │  • TESTED flag (true/false)           │
        └────────────────────────────────────────┘
```

## Docker Detection & Full Update Flow

```
┌─────────────────────────────────────────────────────────────┐
│  patch-host-full.sh admin@webserver /opt/docker             │
└─────────────────────────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Docker Path Provided?                 │
        └────────────────────────────────────────┘
                    │           │
                ┌───┴───┐   ┌───┴───┐
                │ YES   │   │ NO    │
                └───┬───┘   └───┬───┘
                    │           │
                    │           ▼
                    │  ┌────────────────────────────┐
                    │  │  Search Common Paths:      │
                    │  │  • /home/user/Docker       │
                    │  │  • /opt/docker             │
                    │  │  • /srv/docker             │
                    │  │  • $HOME/Docker            │
                    │  └────────────────────────────┘
                    │           │
                    │           ▼
                    │  ┌────────────────────────────┐
                    │  │  docker-compose.yml found? │
                    │  └────────────────────────────┘
                    │       │           │
                    │   ┌───┴───┐   ┌───┴───┐
                    │   │ YES   │   │ NO    │
                    │   └───┬───┘   └───┬───┘
                    │       │           │
                    │       │           ▼
                    │       │  ┌────────────────┐
                    │       │  │  ERROR: Path   │
                    │       │  │  not found     │
                    │       │  └────────────────┘
                    │       │
                    └───────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Step 1: Update System Packages        │
        │  (same as host-only mode)              │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Step 2: Docker Cleanup                │
        │  sudo docker system prune -af          │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Step 3: Pull Individual Images        │
        │  For each image in `docker images`:    │
        │  sudo docker pull image:tag            │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Step 4: Pull Compose Images           │
        │  cd /docker/path                       │
        │  sudo docker compose pull              │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Step 5: Recreate Containers           │
        │  sudo docker compose up -d             │
        │  (Recreates only changed containers)   │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Check Reboot Status                   │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Report Results                        │
        └────────────────────────────────────────┘
```

## PatchMon Integration Flow

```
┌─────────────────────────────────────────────────────────────┐
│  User: "Update my servers"                                  │
└─────────────────────────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Load PatchMon Credentials             │
        │  ~/.patchmon-credentials.conf          │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  POST /api/auth/login                  │
        │  {username, password}                  │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Receive JWT Token                     │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  GET /api/v1/dashboard/hosts           │
        │  Authorization: Bearer {token}         │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Parse Response:                       │
        │  [{                                    │
        │    hostname: "webserver",              │
        │    needsUpdates: true,                 │
        │    outdatedPackages: 26,               │
        │    securityUpdates: 9,                 │
        │    sshUser: "admin",                   │
        │    dockerPath: "/opt/docker"           │
        │  }, ...]                               │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Filter: Only hosts with               │
        │  needsUpdates == true OR               │
        │  outdatedPackages > 0                  │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Generate Temporary Config             │
        │  HOSTS=(                               │
        │    "webserver,admin,/opt/docker"       │
        │    "database,root,/srv/docker"         │
        │  )                                     │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Process Each Host                     │
        │  (Follow Automatic Mode workflow)      │
        └────────────────────────────────────────┘
```

## Error Handling Flow

```
                ┌────────────────┐
                │  Execute Step  │
                └────────────────┘
                        │
                        ▼
                ┌────────────────┐
                │  Success?      │
                └────────────────┘
                    │       │
            ┌───────┴───┐   │
            │ YES       │ NO│
            └───┬───────┘   │
                │           │
                ▼           ▼
    ┌────────────────┐  ┌──────────────────────┐
    │  Continue to   │  │  Is step critical?   │
    │  next step     │  └──────────────────────┘
    └────────────────┘          │       │
                            ┌───┴───┐   │
                            │ YES   │ NO│
                            └───┬───┘   │
                                │       │
                                ▼       ▼
                    ┌────────────────┐  ┌──────────────────┐
                    │  Log error     │  │  Log warning     │
                    │  Stop updates  │  │  Continue        │
                    │  Report failure│  │                  │
                    └────────────────┘  └──────────────────┘
                                │               │
                                ▼               ▼
                    ┌────────────────────────────────┐
                    │  Add to Failed Hosts List      │
                    └────────────────────────────────┘
                                │
                                ▼
                    ┌────────────────────────────────┐
                    │  Continue with Next Host?      │
                    └────────────────────────────────┘
                            │           │
                        ┌───┴───┐   ┌───┴───┐
                        │ YES   │   │ NO    │
                        └───┬───┘   └───┬───┘
                            │           │
                            ▼           ▼
                    ┌───────────────────────┐
                    │  Final Summary Report │
                    └───────────────────────┘
```

## Security Flow: Sudo Execution

```
┌─────────────────────────────────────────────────────────────┐
│  OpenClaw wants to run: apt upgrade                         │
└─────────────────────────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  SSH to target host with key auth      │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Execute: sudo apt upgrade -y          │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Sudo checks /etc/sudoers.d/           │
        │  linux-patcher                         │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Is command in NOPASSWD list?          │
        └────────────────────────────────────────┘
                    │           │
                ┌───┴───┐   ┌───┴───┐
                │ YES   │   │ NO    │
                └───┬───┘   └───┬───┘
                    │           │
                    ▼           ▼
    ┌──────────────────────┐  ┌──────────────────────┐
    │  Execute command     │  │  Request password    │
    │  without password    │  │  (Will fail for SSH) │
    └──────────────────────┘  └──────────────────────┘
                    │                   │
                    ▼                   ▼
    ┌──────────────────────┐  ┌──────────────────────┐
    │  Command runs        │  │  ERROR: Permission   │
    │  Return output       │  │  denied              │
    └──────────────────────┘  └──────────────────────┘
```

## Legend

```
┌─────┐
│ Box │  = Process or Action
└─────┘

    │
    ▼      = Flow direction

┌───┴───┐
│ YES/NO│  = Decision point
└───┬───┘
```

## Dry-Run Mode

When `DRY_RUN=true` or `--dry-run` flag is used:

```
┌─────────────────────────────────────────────────────────────┐
│  User runs with --dry-run flag                              │
└─────────────────────────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Detect OS (normal)                    │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Detect Docker (normal)                │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  Display what WOULD be executed:       │
        │  • apt update                          │
        │  • apt upgrade -y                      │
        │  • docker prune -af                    │
        │  • docker compose up -d                │
        └────────────────────────────────────────┘
                            │
                            ▼
        ┌────────────────────────────────────────┐
        │  EXIT - No changes made                │
        └────────────────────────────────────────┘
```

All commands are shown but **not executed** in dry-run mode. This allows safe testing of configuration and detection logic without making any changes to systems.
