---
name: linkedin-post-engine
description: Write high-performing, persuasive, and authentic LinkedIn posts across any professional niche. Uses research-backed hooks, proven post structures, and LinkedIn-specific formatting to maximize reach, saves, comments, and profile actions. Use when creating LinkedIn posts, carousels-by-text, thought leadership, founder updates, case studies, hiring posts, launch posts, or converting X/Twitter ideas into LinkedIn content.
metadata:
  {
    "openclaw":
      {
        "emoji": "💼"
      },
  }
---

`READ BEFORE USE`
# [HOW TO USE THIS SKILL EFFECTIVELY](https://www.linkedin.com/)
`READ BEFORE USE`

# LinkedIn Post Engine

## Overview

This skill helps you create strong LinkedIn posts that feel human, useful, and credible.

It combines:
- proven hook frameworks,
- clear narrative structures,
- proof-first writing,
- and practical CTA design.

**Keywords**: linkedin, thought leadership, personal brand, founder posts, b2b content, storytelling, case study, hooks, engagement, authority

---

## Process Workflow

### Phase 1: Audience + Positioning (CRITICAL)

Before writing, define:

1. **Audience** — Who is this for? (founders, recruiters, engineers, operators, marketers, sales leaders, etc.)
2. **Goal** — Reach, authority, leads, hiring, trust, replies, profile visits?
3. **Core insight** — What is the one thing worth remembering?
4. **Proof** — What makes this believable (numbers, before/after, constraints, mistakes, outcomes)?

If proof is missing, use placeholders like `[X%]`, `[Y hours]` and request exact values.

### Phase 2: Structure + Hook Selection

Choose a format first, then write:
- Story
- Framework
- Contrarian
- Case study
- Teardown
- Build-in-public

Then select 2-3 hooks and finalize one.

### Phase 3: Draft + Polish

- Keep paragraphs short (1-2 lines)
- Front-load specifics
- Remove generic filler
- End with one clear CTA
- Add 3-6 hashtags max

---

## LinkedIn Feed Dynamics (Practical)

What usually performs best:

1. **Strong first two lines** (stops the scroll)
2. **Specificity** (numbers > adjectives)
3. **Credible vulnerability** (mistakes + lessons)
4. **Clear structure** (easy to skim on mobile)
5. **Conversation CTA** (quality comments over empty likes)

Avoid:
- Buzzword soup
- Generic motivation posts
- Overlong hashtag blocks
- Fake certainty without evidence

---

## Hook Formulas (Most Important)

### The Contrarian Hook
- “Most people do [X]. That’s exactly why they stay stuck.”
- “Unpopular opinion: [industry belief] is outdated.”

### The Specific Result Hook
- “In [timeframe], we improved [metric] by [number]. Here’s how.”
- “We cut [cost/time] by [X%]. Not with a new tool—by changing this one workflow.”

### The Mistake Hook
- “I made this [role]-mistake for months. It cost us [outcome].”
- “We shipped the wrong thing fast. Here’s what fixed it.”

### The Framework Hook
- “The [3-step/4-step] framework I use for [outcome].”
- “If I had to restart as [role], I’d follow these 5 rules.”

### The Question Hook
- “Would you let your team do [X] without [Y]?”
- “What’s your biggest bottleneck in [domain] right now?”

---

## High-Performing Post Formats

### 1) “This runs now” (Operational Story)
Best for real systems, workflows, and automations.

Template:
- bold claim
- “Not as a demo. As an actual [responsibility/workflow].”
- “Here’s what it does:” with 4-6 concrete bullets
- measurable result
- perspective line + CTA question

### 2) Case Study
Template:
- starting problem
- constraints
- intervention
- before/after metrics
- key lesson
- optional “comment TEMPLATE” CTA

### 3) Contrarian Opinion
Template:
- challenge popular view
- explain why it fails in practice
- give 3 practical principles
- ask a polarizing but constructive question

### 4) Framework Post
Template:
- name framework
- 3-5 steps
- one mistake to avoid
- one practical “do this today” action

### 5) Build-in-Public Update
Template:
- what shipped this week
- what worked
- what broke
- what changed next
- ask for informed feedback

---

## Persuasion Principles

Use these to increase clarity and trust:

- **Specificity**: “Saved 3.2 hours/week” beats “saved time.”
- **Mechanism**: Explain how, not just outcomes.
- **Credibility**: Mention tradeoffs, not only wins.
- **Relevance**: Tie insight to audience reality.
- **Clarity**: One post = one core idea.

---

## Writing Rules

- Hook in first 1-2 lines
- 1-2 sentence paragraphs
- Prefer plain language over hype
- Use emojis sparingly as section markers
- Keep claims realistic
- Never invent outcomes, clients, or credentials

Hashtags:
- 3-6 max
- niche + function + audience mix
- avoid spammy broad tags only

---

## Output Contract

By default, provide:

1. 3 hook options
2. 1 full post
3. 1 spicier variant
4. 3 first-comment ideas (to deepen discussion)

Optional on request:
- NL / EN / NL-EN mixed variants
- X/Twitter adaptation
- Short + long versions
- Carousel text outline

---

## Quick Prompt Template

When user gives a raw idea, ask/fill:

- Audience:
- Goal:
- Topic:
- Proof points:
- Tone:
- CTA preference:

Then generate outputs per contract above.

---

## Common Pitfalls to Avoid

- Generic “AI changed everything” without concrete examples
- No proof signals
- Too many ideas in one post
- CTA mismatch (asking for leads on a pure thought-leadership post)
- Over-formatting with noisy symbols

---

## Execution Checklist

Before finalizing:

- [ ] Hook is strong and specific
- [ ] Core claim is clear
- [ ] Includes at least one proof signal
- [ ] Easy to skim on mobile
- [ ] CTA invites real conversation
- [ ] Hashtags are relevant and limited
- [ ] Tone feels authentic to author
