import json
import sys
import os

def generate_html(prospects_json):
    prospects = json.loads(prospects_json)
    
    html = """
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Qualified LinkedIn Prospects</title>
        <style>
            :root { --primary: #0077b5; --bg: #f3f6f8; --text: #333; }
            body { font-family: 'Segoe UI', sans-serif; background: var(--bg); padding: 40px; color: var(--text); }
            .container { max-width: 800px; margin: 0 auto; background: white; padding: 40px; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); }
            h1 { color: var(--primary); border-bottom: 2px solid var(--primary); padding-bottom: 10px; text-align: center; }
            .prospect { margin-bottom: 30px; border: 1px solid #eee; padding: 20px; border-radius: 8px; }
            .name { font-size: 1.4em; color: var(--primary); font-weight: bold; }
            .company { font-weight: 600; color: #555; margin-bottom: 10px; }
            .meta { font-size: 0.9em; color: #777; margin-bottom: 15px; }
            .analysis { background: #f9f9f9; padding: 15px; border-radius: 6px; border-left: 4px solid var(--primary); }
            .analysis h4 { margin: 0 0 10px 0; color: var(--primary); }
            .pitch { background: #fff3cd; padding: 10px; border-radius: 4px; margin-top: 15px; font-size: 0.9em; }
        </style>
    </head>
    <body>
        <div class="container">
            <h1>Qualified Business Prospects</h1>
    """
    
    for p in prospects:
        html += f"""
        <div class="prospect">
            <div class="name">{p['name']}</div>
            <div class="company">{p['position']}</div>
            <div class="meta">
                Location: {p.get('location', 'N/A')} | 
                <a href="{p['linkedin_url']}">LinkedIn Profile</a>
            </div>
            <div class="analysis">
                <h4>Gap Analysis:</h4>
                <ul>
        """
        for need in p.get('needs', []):
            html += f"<li>{need}</li>"
            
        html += f"""
                </ul>
            </div>
            <div class="pitch">
                <strong>Pitch Idea:</strong> {p.get('pitch', 'N/A')}
            </div>
        </div>
        """
        
    html += """
        </div>
    </body>
    </html>
    """
    return html

if __name__ == "__main__":
    if len(sys.argv) > 1:
        data = sys.stdin.read()
        print(generate_html(data))
